/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.profile;

/**
 * The ProfilPoint interface is to mark objects that can be sampled by a
 * Profiler. The interface only has one sampling method to simplify the items
 * that can be sampled.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 */
public class EventsPerSampleProfilePoint extends AbstractProfilePoint
{
    private       int    m_value = 0;

    /**
     * Creates a EventsPerSampleProfilePoint with an initial name.
     */
    public EventsPerSampleProfilePoint( String name )
    {
        super( name );
    }

    /**
     * Set the sample value
     */
    public void increment( )
    {
        m_value++;
    }

    /**
     * Obtain the sample.  All samples are an integer, so the profiled objects
     * must measure quantity (numbers of items), rate (items/period), time in
     * milliseconds, etc.
     */
    public int getSample()
    {
        final int returnValue = m_value;
        m_value = 0;

        return returnValue;
    }
}
