/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.fortran.FortArrayMethods;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.rmi.RMIStubSource;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LanguageWriterForFortran;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StubSource {
    public static final String s_self = "self";
    public static final String s_return = "retval";
    public static final String s_exception = "exception";
    public static final String s_charCheck = "#ifdef " + Fortran.getFortranPrefix() + "_CHAR_AS_STRING";
    private static final String s_proxy = "_proxy_";
    private static final String s_proxyTwo = "_alt_";
    private static final String s_epv = "_epv";
    private static final boolean d_isF90 = Fortran.isFortran90();
    private static final String s_exceptionFundamentalType = BabelConfiguration.getBaseExceptionType();
    private static final String s_exceptionInterfaceType = BabelConfiguration.getBaseExceptionInterface();
    private LanguageWriter d_writer;

    public static void generateSupers(Class cls, LanguageWriter writer) throws CodeGenerationException {
        StubSource source = new StubSource(writer);
        source.generateSupers(cls);
    }

    public void generateSupers(Class cls) throws CodeGenerationException {
        this.generateSuperEPV(cls);
        this.generateGetIOR(cls.getSymbolID());
        this.generateSuperMethods(cls);
    }

    public StubSource(LanguageWriter writer) {
        this.d_writer = writer;
    }

    public static boolean comma(LanguageWriter writer, boolean needComma) {
        if (needComma) {
            writer.println(",");
        }
        return false;
    }

    public static boolean declareArgument(LanguageWriter writer, String argName, Type argType, boolean needComma) throws CodeGenerationException {
        String pre = "fortran.StubSource.declareArgument: ";
        switch (argType.getDetailedType()) {
            case 0: {
                break;
            }
            case 16: {
                if (argType.isRarray()) {
                    writer.print(Fortran.getFortranTypeInC(argType.getArrayType()) + " *" + argName);
                    needComma = true;
                    break;
                }
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                writer.print(Fortran.getFortranTypeInC(argType) + " *" + argName);
                needComma = true;
                break;
            }
            case 10: {
                writer.println(Fortran.getFortranPrefix() + "_String " + argName);
                writer.print(Fortran.getFortranPrefix() + "_STR_NEAR_LEN_DECL(" + argName + ")");
                needComma = true;
                break;
            }
            case 2: {
                writer.printlnUnformatted(s_charCheck);
                writer.println(Fortran.getFortranPrefix() + "_String " + argName);
                writer.println(Fortran.getFortranPrefix() + "_STR_NEAR_LEN_DECL(" + argName + ")");
                writer.printlnUnformatted("#else");
                writer.println("char *" + argName);
                writer.printlnUnformatted("#endif");
                needComma = true;
                break;
            }
            default: {
                throw new CodeGenerationException("fortran.StubSource.declareArgument: Unsupported Fortran argument type: " + argType.getTypeString() + " " + argName);
            }
        }
        return needComma;
    }

    private static void generateMethodSymbol(LanguageWriter writer, String methodName) {
        writer.println("void");
        writer.disableLineBreak();
        writer.println(Fortran.getFortranSymbol() + "(" + methodName.toLowerCase() + ',' + methodName.toUpperCase() + ',' + methodName + ")");
        writer.println("(");
    }

    private static boolean declareNormalArguments(LanguageWriter writer, Iterator i) throws CodeGenerationException {
        boolean needComma = false;
        while (i.hasNext()) {
            needComma = StubSource.comma(writer, needComma);
            Argument a = (Argument)i.next();
            needComma = StubSource.declareArgument(writer, a.getFormalName(), a.getType(), needComma);
        }
        return needComma;
    }

    private static boolean declareExtraArguments(LanguageWriter writer, Iterator i, boolean needComma) {
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            int t = a.getType().getDetailedType();
            if (10 != t && 2 != t) continue;
            if (needComma) {
                writer.println();
                needComma = false;
            }
            if (2 == t) {
                writer.printlnUnformatted(s_charCheck);
            }
            writer.println(Fortran.getFortranPrefix() + "_STR_FAR_LEN_DECL(" + a.getFormalName() + ")");
            if (2 != t) continue;
            writer.printlnUnformatted("#endif");
        }
        return needComma;
    }

    public static void generateSignature(LanguageWriter writer, String methodName, List arguments) throws CodeGenerationException {
        StubSource.generateMethodSymbol(writer, methodName);
        if (arguments.isEmpty()) {
            writer.print("void");
        } else {
            writer.tab();
            boolean needComma = StubSource.declareNormalArguments(writer, arguments.iterator());
            needComma = StubSource.declareExtraArguments(writer, arguments.iterator(), needComma);
            if (needComma) {
                writer.println();
            }
            writer.backTab();
        }
        writer.print(")");
        writer.enableLineBreak();
    }

    public static boolean hasProxy(Type t) {
        switch (t.getDetailedType()) {
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPointer(Type t) {
        switch (t.getDetailedType()) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private static String getArrayStruct(Type type) throws CodeGenerationException {
        String pointerType = StubSource.getReturnString(type);
        return pointerType.substring(0, pointerType.length() - 1);
    }

    private static String getReturnString(Type type) throws CodeGenerationException {
        return IOR.getReturnString(type, true, false);
    }

    private void declareProxies(List arguments) throws CodeGenerationException {
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            Type t = a.getType();
            String name = a.getFormalName();
            if (!StubSource.hasProxy(t)) continue;
            if (t.isRarray()) {
                int dimen = t.getArrayDimension();
                this.d_writer.println(StubSource.getArrayStruct(t) + ' ' + s_proxyTwo + name + ';');
                this.d_writer.println(StubSource.getReturnString(t) + ' ' + s_proxy + name + " = &" + s_proxyTwo + name + ';');
                this.d_writer.println("int32_t " + name + "_lower[" + dimen + "], " + name + "_upper[" + dimen + "], " + name + "_stride[" + dimen + "];");
                continue;
            }
            this.d_writer.print(StubSource.getReturnString(t) + " " + s_proxy + name);
            if (StubSource.isPointer(t)) {
                this.d_writer.println(" = NULL;");
                continue;
            }
            this.d_writer.println(";");
        }
    }

    private void copyIncomingValues(List arguments) throws CodeGenerationException {
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            if (2 == a.getMode()) continue;
            Type t = a.getType();
            String name = a.getFormalName();
            switch (t.getDetailedType()) {
                case 1: {
                    this.d_writer.println(s_proxy + name + " = ((*" + name + " == " + Fortran.getFortranPrefix() + "_TRUE) ? TRUE : FALSE);");
                    break;
                }
                case 2: {
                    this.d_writer.printlnUnformatted(s_charCheck);
                    this.d_writer.println(s_proxy + name + " = *" + Fortran.getFortranPrefix() + "_STR(" + name + ");");
                    this.d_writer.printlnUnformatted("#else");
                    this.d_writer.println(s_proxy + name + " = *" + name + ";");
                    this.d_writer.printlnUnformatted("#endif");
                    break;
                }
                case 10: {
                    this.d_writer.println(s_proxy + name + " =");
                    this.d_writer.tab();
                    this.d_writer.println("sidl_copy_fortran_str(" + Fortran.getFortranPrefix() + "_STR(" + name + "),");
                    this.d_writer.tab();
                    this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LEN(" + name + "));");
                    this.d_writer.backTab();
                    this.d_writer.backTab();
                    break;
                }
                case 11: {
                    this.d_writer.println(s_proxy + name + " =");
                    this.d_writer.tab();
                    this.d_writer.println("(" + IOR.getEnumName(t.getSymbolID()) + ")*");
                    this.d_writer.println(name + ";");
                    this.d_writer.backTab();
                    break;
                }
                case 16: {
                    if (t.isRarray()) {
                        Iterator indexVar = t.getArrayIndices().iterator();
                        int dimen = t.getArrayDimension();
                        for (int j = 0; j < dimen && indexVar.hasNext(); ++j) {
                            this.d_writer.println(name + "_upper[" + j + "] = (*" + indexVar.next().toString() + ")-1;");
                        }
                        this.d_writer.println(Fortran.getInitArray(t.getArrayType()) + name + ", " + s_proxy + name + ", " + dimen + ", " + name + "_lower, " + name + "_upper, " + name + "_stride);");
                        break;
                    }
                    this.d_writer.println(s_proxy + name + " =");
                    this.d_writer.tab();
                    this.d_writer.println("(" + StubSource.getReturnString(t) + ")");
                    if (d_isF90) {
                        this.d_writer.println("(ptrdiff_t)(" + name + "->d_ior);");
                    } else {
                        this.d_writer.println("(ptrdiff_t)(*" + name + ");");
                    }
                    this.d_writer.backTab();
                    break;
                }
                case 9: 
                case 12: 
                case 13: {
                    this.d_writer.println(s_proxy + name + " =");
                    this.d_writer.tab();
                    this.d_writer.println("(" + StubSource.getReturnString(t) + ")");
                    this.d_writer.println("(ptrdiff_t)(*" + name + ");");
                    this.d_writer.backTab();
                }
            }
        }
    }

    private void copyOutgoingValues(List arguments) throws CodeGenerationException {
        String pre = "fortran.StubSource.copyOutgoingValues: ";
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            String name = a.getFormalName();
            if (0 == a.getMode() || name.equals(s_exception)) continue;
            Type t = a.getType();
            switch (t.getDetailedType()) {
                case 1: {
                    this.d_writer.println("*" + name + " = ((" + s_proxy + name + " == TRUE) ? " + Fortran.getFortranPrefix() + "_TRUE : " + Fortran.getFortranPrefix() + "_FALSE);");
                    break;
                }
                case 16: {
                    if (t.isRarray()) break;
                    if (d_isF90) {
                        if (Fortran.hasDirectAccess(t)) {
                            Type dataType = t.getArrayType();
                            this.d_writer.println("if (sidl_" + dataType.getTypeString() + "__array_convert2f90(" + s_proxy + name + ", " + t.getArrayDimension() + ", " + name + ")) {");
                            this.d_writer.tab();
                            this.d_writer.writeCommentLine("Copy to contiguous column-order");
                            this.d_writer.println(StubSource.getReturnString(t) + " " + s_proxyTwo + name + " =");
                            this.d_writer.tab();
                            this.d_writer.print(Fortran.getEnsureArray(dataType));
                            this.d_writer.println(s_proxy + name + ", " + t.getArrayDimension() + ",");
                            this.d_writer.tab();
                            this.d_writer.println("sidl_column_major_order);");
                            this.d_writer.backTab();
                            this.d_writer.backTab();
                            this.d_writer.println(Fortran.getDelRefArray(dataType) + s_proxy + name + ");");
                            this.d_writer.println("if (sidl_" + dataType.getTypeString() + "__array_convert2f90(" + s_proxyTwo + name + ", " + t.getArrayDimension() + ", " + name + ")) {");
                            this.d_writer.tab();
                            this.d_writer.writeCommentLine("We're S.O.L.");
                            this.d_writer.println("fprintf(stderr, \"convert2f90 failed: %p %d\\n\", (void*)_alt_" + name + ", " + t.getArrayDimension() + ");");
                            this.d_writer.println("exit(1); /*NOTREACHED*/");
                            this.d_writer.backTab();
                            this.d_writer.println("}");
                            this.d_writer.backTab();
                            this.d_writer.println("}");
                            break;
                        }
                        this.d_writer.println(name + "->d_ior = (ptrdiff_t)" + s_proxy + name + ";");
                        break;
                    }
                    this.d_writer.println("*" + name + " = (ptrdiff_t)" + s_proxy + name + ";");
                    break;
                }
                case 9: 
                case 12: 
                case 13: {
                    this.d_writer.println("*" + name + " = (ptrdiff_t)" + s_proxy + name + ";");
                    break;
                }
                case 2: {
                    this.d_writer.printlnUnformatted(s_charCheck);
                    this.d_writer.println("*" + Fortran.getFortranPrefix() + "_STR(" + name + ") = " + s_proxy + name + ";");
                    this.d_writer.printlnUnformatted("#else");
                    this.d_writer.println("*" + name + " = " + s_proxy + name + ";");
                    this.d_writer.printlnUnformatted("#endif");
                    break;
                }
                case 10: {
                    this.d_writer.println("sidl_copy_c_str(");
                    this.d_writer.tab();
                    this.d_writer.println(Fortran.getFortranPrefix() + "_STR(" + name + "),");
                    this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LEN(" + name + "),");
                    this.d_writer.println(s_proxy + name + ");");
                    this.d_writer.backTab();
                    break;
                }
                case 11: {
                    this.d_writer.println("*" + name + " = (int)");
                    this.d_writer.tab();
                    this.d_writer.println(s_proxy + name + ";");
                    this.d_writer.backTab();
                    break;
                }
                case 15: {
                    throw new CodeGenerationException("fortran.StubSource.copyOutgoingValues: Unsupported Type: " + t.getTypeString());
                }
            }
        }
    }

    private void freeResources(List arguments) {
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            if (10 != a.getType().getDetailedType()) continue;
            String name = a.getFormalName();
            this.d_writer.println("free((void *)_proxy_" + name + ");");
        }
    }

    private void declareEntryPointVector(boolean isStatic, SymbolID id) {
        if (isStatic) {
            this.d_writer.println("const " + IOR.getSEPVName(id) + " *" + s_epv + " = _getSEPV();");
        } else {
            this.d_writer.println(IOR.getEPVName(id) + " *" + s_epv + " = NULL;");
        }
    }

    private void generateSuperEPV(Class cls) {
        this.d_writer.println("static const struct " + C.getObjectName(cls.getParentClass().getSymbolID()) + "__epv* superEPV = NULL;");
        this.d_writer.println();
    }

    private void generateSuperMethods(Class cls) throws CodeGenerationException {
        SymbolID clsID = cls.getSymbolID();
        Collection methods = cls.getOverwrittenClassMethods();
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            this.extendAndGenerateSuper(cls, method, cls.getSymbolID(), false);
        }
    }

    private void generateGetIOR(SymbolID id) {
        String ext_name = IOR.getExternalName(id);
        this.d_writer.writeComment("Return pointer to internal IOR functions.", false);
        this.d_writer.println("static const " + ext_name + "* _getIOR(void)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("static const " + ext_name + " *_ior = NULL;");
        this.d_writer.println("if (!_ior) {");
        this.d_writer.tab();
        if (BabelConfiguration.isSIDLBaseClass(id)) {
            this.d_writer.println("_ior = " + IOR.getExternalFunc(id) + "();");
        } else {
            this.d_writer.printlnUnformatted("#ifdef SIDL_STATIC_LIBRARY");
            this.d_writer.println("_ior = " + IOR.getExternalFunc(id) + "();");
            this.d_writer.printlnUnformatted("#else");
            this.d_writer.println("sidl_DLL dll = sidl_DLL__create();");
            this.d_writer.println("const " + ext_name + "*(*dll_f)(void);");
            this.d_writer.writeCommentLine("check global namespace for symbol first");
            this.d_writer.println("if (dll && sidl_DLL_loadLibrary(dll, \"main:\", TRUE, FALSE)) {");
            this.d_writer.tab();
            this.d_writer.println("dll_f =");
            this.d_writer.tab();
            this.d_writer.print("(const " + ext_name + "*(*)(void)) ");
            this.d_writer.println("sidl_DLL_lookupSymbol(");
            this.d_writer.tab();
            this.d_writer.println("dll, \"" + IOR.getExternalFunc(id) + "\");");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println("_ior = (dll_f ? (*dll_f)() : NULL);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (dll) sidl_DLL_deleteRef(dll);");
            this.d_writer.println("if (!_ior) {");
            this.d_writer.tab();
            this.d_writer.println("dll = sidl_Loader_findLibrary(\"" + id.getFullName() + "\",");
            this.d_writer.tab();
            this.d_writer.println("\"ior/impl\", sidl_Scope_SCLSCOPE,");
            this.d_writer.println("sidl_Resolve_SCLRESOLVE);");
            this.d_writer.backTab();
            this.d_writer.println("if (dll) {");
            this.d_writer.tab();
            this.d_writer.println("dll_f =");
            this.d_writer.tab();
            this.d_writer.print("(const " + ext_name + "*(*)(void)) ");
            this.d_writer.println("sidl_DLL_lookupSymbol(");
            this.d_writer.tab();
            this.d_writer.println("dll, \"" + IOR.getExternalFunc(id) + "\");");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println("_ior = (dll_f ? (*dll_f)() : NULL);");
            this.d_writer.println("sidl_DLL_deleteRef(dll);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (!_ior) {");
            this.d_writer.tab();
            this.d_writer.disableLineBreak();
            this.d_writer.println("fputs(\"Unable to find the implementation for " + id.getFullName() + "; please set SIDL_DLL_PATH\\n\", stderr);");
            this.d_writer.enableLineBreak();
            this.d_writer.println("exit(-1);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.printlnUnformatted("#endif");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("return _ior;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateGetStaticEPV(SymbolID id) {
        String sepv_name = IOR.getSEPVName(id);
        this.d_writer.writeComment("Return pointer to static functions.", false);
        this.d_writer.println("static const " + sepv_name + "* _getSEPV(void)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("static const " + sepv_name + " *_sepv = NULL;");
        this.d_writer.println("if (!_sepv) {");
        this.d_writer.tab();
        this.d_writer.println("_sepv = (*(_getIOR()->getStaticEPV))();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("return _sepv;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void getEntryPointVector(boolean isStatic, SymbolID id) {
        if (!isStatic) {
            this.d_writer.println("_epv = _proxy_self->d_epv;");
        }
    }

    private boolean passArgument(Argument a, boolean isInterface, boolean needComma) {
        String varName = a.getFormalName();
        if (!s_return.equals(varName)) {
            needComma = StubSource.comma(this.d_writer, needComma);
            if (StubSource.hasProxy(a.getType())) {
                if (0 != a.getMode()) {
                    this.d_writer.print("&");
                }
                this.d_writer.print(s_proxy + varName);
                if (isInterface && s_self.equals(varName)) {
                    this.d_writer.print("->d_object");
                }
            } else {
                if (0 == a.getMode()) {
                    this.d_writer.print("*");
                }
                this.d_writer.print(varName);
            }
            needComma = true;
        }
        return needComma;
    }

    private void makeMethodCall(Extendable ext, List arguments, Method m, boolean isInterface, boolean isSuper) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        Type returnType = m.getReturnType();
        Iterator i = arguments.iterator();
        boolean needComma = false;
        if (0 != returnType.getDetailedType()) {
            if (StubSource.hasProxy(returnType)) {
                this.d_writer.print(s_proxy);
            } else {
                this.d_writer.print("*");
            }
            this.d_writer.println("retval = ");
            this.d_writer.tab();
        }
        if (isSuper) {
            Class cls = (Class)ext;
            this.d_writer.println("(*(superEPV->" + IOR.getVectorEntry(m.getLongMethodName()) + "))((" + IOR.getObjectName(cls.getParentClass().getSymbolID()) + "*) ");
        } else {
            this.d_writer.println("(*(_epv->" + IOR.getVectorEntry(m.getLongMethodName()) + "))(");
        }
        this.d_writer.tab();
        while (i.hasNext()) {
            needComma = this.passArgument((Argument)i.next(), isInterface, needComma);
        }
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println(");");
        if (0 != returnType.getDetailedType()) {
            this.d_writer.backTab();
        }
    }

    private void checkExceptionBlock(Method m) {
        if (!m.getThrows().isEmpty()) {
            this.d_writer.println("if (_proxy_exception) {");
            this.d_writer.tab();
            this.d_writer.println("*exception = (ptrdiff_t)_proxy_exception;");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("else {");
            this.d_writer.tab();
            this.d_writer.println("*exception = (ptrdiff_t)NULL;");
        }
    }

    private void endExceptionBlock(Method m) {
        if (!m.getThrows().isEmpty()) {
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
    }

    private void generateMethod(Extendable ext, String name, List arguments, List argumentsWithIndices, Method m, SymbolID id, boolean isInterface, boolean isSuper) throws CodeGenerationException {
        this.d_writer.writeComment(m, false);
        StubSource.generateSignature(this.d_writer, name, argumentsWithIndices);
        this.d_writer.println();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.declareEntryPointVector(m.isStatic(), id);
        this.declareProxies(arguments);
        this.copyIncomingValues(arguments);
        this.getEntryPointVector(m.isStatic(), id);
        this.makeMethodCall(ext, arguments, m, isInterface, isSuper);
        this.checkExceptionBlock(m);
        this.copyOutgoingValues(arguments);
        this.endExceptionBlock(m);
        this.freeResources(arguments);
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private static Type convertRarrayToArray(Type array) {
        if (array.isRarray()) {
            return new Type(array.getArrayType(), array.getArrayDimension(), array.getArrayOrder());
        }
        return array;
    }

    public static List convertRarrayToArray(List args) {
        ArrayList<Argument> result = new ArrayList<Argument>(args.size());
        Iterator i = args.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            if (a.getType().isRarray()) {
                result.add(new Argument(a.isCopy(), a.getMode(), StubSource.convertRarrayToArray(a.getType()), a.getFormalName()));
                continue;
            }
            result.add(a);
        }
        return result;
    }

    public static List extendArgs(SymbolID selfId, Method m, boolean indices) throws CodeGenerationException {
        ArrayList origArgs = null;
        origArgs = indices ? m.getArgumentListWithIndices() : m.getArgumentListWithOutIndices();
        ArrayList<Argument> result = new ArrayList<Argument>(origArgs.size() + 3);
        if (3 != m.getDefinitionModifier()) {
            result.add(new Argument(false, 0, new Type(selfId), s_self));
        }
        result.addAll(origArgs);
        if (0 != m.getReturnType().getDetailedType()) {
            result.add(new Argument(false, 2, m.getReturnType(), s_return));
        }
        if (!m.getThrows().isEmpty()) {
            Symbol ex = Utilities.lookupSymbol(s_exceptionFundamentalType);
            result.add(new Argument(false, 2, new Type(ex.getSymbolID()), s_exception));
        }
        return result;
    }

    public static Set extendedReferences(Extendable ext) throws CodeGenerationException {
        HashSet<SymbolID> result = new HashSet<SymbolID>();
        Iterator i = ext.getMethods(true).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            result.addAll(method.getSymbolReferences());
            if (method.getThrows().isEmpty()) continue;
            Symbol symbol = Utilities.lookupSymbol(s_exceptionInterfaceType);
            result.add(symbol.getSymbolID());
        }
        return result;
    }

    public static void generateIncludes(LanguageWriterForC writer, Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        writer.printlnUnformatted("#include <stddef.h>");
        writer.printlnUnformatted("#include <stdlib.h>");
        writer.generateInclude("sidlfortran.h", false);
        if (d_isF90) {
            writer.generateInclude("sidlf90array.h", true);
        }
        writer.generateInclude("sidl_header.h", false);
        writer.generateInclude("sidl_interface_IOR.h", true);
        writer.printlnUnformatted("#include <stdio.h>");
        if (!BabelConfiguration.isSIDLBaseClass(id)) {
            writer.printlnUnformatted("#include \"babel_config.h\"");
            writer.printlnUnformatted("#ifdef SIDL_DYNAMIC_LIBRARY");
            writer.generateInclude("sidl_Loader.h", false);
            writer.printlnUnformatted("#endif");
        }
        writer.generateInclude(IOR.getHeaderFile(id), false);
        if (Fortran.needsAbbrev()) {
            writer.generateInclude(Fortran.getStubNameFile(id), false);
        }
        Set includes = StubSource.extendedReferences(ext);
        includes.remove(id);
        Iterator i = includes.iterator();
        while (i.hasNext()) {
            writer.generateInclude(IOR.getHeaderFile((SymbolID)i.next()), false);
        }
    }

    private void extendAndGenerate(Extendable ext, Method m, SymbolID id, boolean isInterface) throws CodeGenerationException {
        String name = Fortran.getMethodStubName(id, m);
        List extendedArgs = StubSource.extendArgs(id, m, false);
        List extendedArgsWithIndices = StubSource.extendArgs(id, m, true);
        this.generateMethod(ext, name, extendedArgs, extendedArgsWithIndices, m, id, isInterface, false);
        if (d_isF90 && m.hasRarray()) {
            extendedArgs = StubSource.convertRarrayToArray(extendedArgs);
            this.generateMethod(ext, Fortran.getAltStubName(id, m), extendedArgs, extendedArgs, m, id, isInterface, false);
        }
    }

    private void extendAndGenerateSuper(Class cls, Method m, SymbolID id, boolean isInterface) throws CodeGenerationException {
        String name = Fortran.getMethodSuperName(id, m);
        List extendedArgs = StubSource.extendArgs(id, m, false);
        List extendedArgsWithIndices = StubSource.extendArgs(id, m, true);
        this.generateMethod(cls, name, extendedArgs, extendedArgsWithIndices, m, id, isInterface, true);
    }

    private void generateCreateMethod(SymbolID id) throws CodeGenerationException {
        String newName = d_isF90 ? "_new" : "__create";
        String methodName = id.getFullName().replace('.', '_') + newName + Fortran.getMethodSuffix();
        this.d_writer.writeComment("Constructor for the class.", false);
        this.d_writer.println("void");
        this.d_writer.disableLineBreak();
        this.d_writer.println(Fortran.getFortranSymbol() + "(" + methodName.toLowerCase() + ',' + methodName.toUpperCase() + ',' + methodName + ")");
        this.d_writer.enableLineBreak();
        this.d_writer.println("(");
        this.d_writer.tab();
        this.d_writer.println("int64_t *self");
        this.d_writer.backTab();
        this.d_writer.println(")");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("*self = (ptrdiff_t) (*(_getIOR()->createObject))();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateCast(SymbolID id) throws CodeGenerationException {
        Method m = Fortran.createCast(id);
        List extendedArgs = StubSource.extendArgs(id, m, false);
        String name = Fortran.getMethodStubName(id, m);
        this.d_writer.writeComment(m, false);
        StubSource.generateSignature(this.d_writer, name, extendedArgs);
        this.d_writer.println();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("struct sidl_BaseInterface__object  *_base =");
        this.d_writer.tab();
        this.d_writer.println("(struct sidl_BaseInterface__object *)(ptrdiff_t)*ref;");
        this.d_writer.backTab();
        this.d_writer.println("if (_base) {");
        this.d_writer.tab();
        this.d_writer.println("*retval = (ptrdiff_t)(");
        this.d_writer.tab();
        this.d_writer.println("*_base->d_epv->" + IOR.getVectorEntry(IOR.getBuiltinName(0)) + ")(");
        this.d_writer.println("_base->d_object,");
        this.d_writer.println("\"" + id.getFullName() + "\");");
        this.d_writer.backTab();
        this.d_writer.backTab();
        this.d_writer.println("} else {");
        this.d_writer.tab();
        this.d_writer.println("*retval = 0;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateCastTwo(Extendable ext, SymbolID id, boolean isInterface) throws CodeGenerationException {
        Method m = IOR.getBuiltinMethod(0, id);
        List args = StubSource.extendArgs(id, m, false);
        this.generateMethod(ext, Fortran.getMethodStubName(id, Fortran.createCastTwo(id)), args, args, m, id, isInterface, false);
    }

    private void generateExtendable(Extendable ext) throws CodeGenerationException {
        Iterator i = ext.getMethods(true).iterator();
        SymbolID id = ext.getSymbolID();
        boolean isInterface = ext.isInterface();
        this.d_writer.writeBanner(ext, Fortran.getStubFile(id), false, "Client-side glue code for " + id.getFullName());
        this.d_writer.writeComment(ext, false);
        StubSource.generateIncludes((LanguageWriterForC)this.d_writer, ext);
        this.d_writer.println();
        if (!ext.isInterface()) {
            this.generateGetIOR(id);
        }
        if (ext.hasStaticMethod(true)) {
            this.generateGetStaticEPV(id);
        }
        if (!ext.isAbstract()) {
            this.generateCreateMethod(id);
        }
        this.generateCast(id);
        this.generateCastTwo(ext, id, isInterface);
        while (i.hasNext()) {
            this.d_writer.println();
            this.extendAndGenerate(ext, (Method)i.next(), id, isInterface);
        }
        this.d_writer.println();
        FortArrayMethods fam = new FortArrayMethods(id, false);
        fam.generateStub(this.d_writer);
    }

    public void generateEnum(Enumeration enm) throws CodeGenerationException {
        SymbolID id = enm.getSymbolID();
        if (this.d_writer instanceof LanguageWriterForFortran) {
            this.d_writer.writeBanner(enm, Fortran.getEnumStubFile(id), false, "Client-side glue code for " + id.getFullName());
            this.d_writer.println();
            this.d_writer.writeComment(enm, false);
            this.d_writer.println();
            Iterator i = enm.getEnumerators().iterator();
            while (i.hasNext()) {
                String sym = (String)i.next();
                Comment cmt = enm.getEnumeratorComment(sym);
                this.d_writer.writeComment(cmt, true);
                this.d_writer.print(Fortran.getReturnString(new Type(id)));
                if (d_isF90) {
                    this.d_writer.print(" :: ");
                } else {
                    this.d_writer.print(" ");
                }
                this.d_writer.println(sym);
                this.d_writer.println("parameter (" + sym + " = " + enm.getEnumeratorValue(sym) + ")");
                if (cmt == null) continue;
                this.d_writer.println();
            }
        } else {
            this.d_writer.writeBanner(enm, Fortran.getEnumStubImpl(id), false, "Client-side glue code for " + id.getFullName());
            ((LanguageWriterForC)this.d_writer).generateInclude("sidl_int_IOR.h", true);
            ((LanguageWriterForC)this.d_writer).generateInclude("sidlfortran.h", true);
            this.d_writer.printlnUnformatted("#include <stddef.h>");
            if (Fortran.needsAbbrev()) {
                ((LanguageWriterForC)this.d_writer).generateInclude(Fortran.getStubNameFile(id), false);
            }
            FortArrayMethods fam = new FortArrayMethods(id, true);
            fam.generateStub(this.d_writer);
        }
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        String pre = "fortran.StubSource.generateCode: ";
        switch (symbol.getSymbolType()) {
            case 12: 
            case 13: {
                if (this.d_writer instanceof LanguageWriterForC) {
                    this.generateExtendable((Extendable)symbol);
                    RMIStubSource.generateCode(symbol, (LanguageWriterForC)this.d_writer);
                    break;
                }
                throw new CodeGenerationException("fortran.StubSource.generateCode: Extendable stub requires C language writer.");
            }
            case 11: {
                this.generateEnum((Enumeration)symbol);
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new CodeGenerationException("fortran.StubSource.generateCode: Unsupported symbol type.");
            }
        }
    }

    public static void generateCode(Symbol ext, LanguageWriter writer) throws CodeGenerationException {
        StubSource source = new StubSource(writer);
        source.generateCode(ext);
    }
}

