/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.config;

import gov.llnl.babel.config.Configuration;
import gov.llnl.babel.config.InvalidConfiguration;
import gov.llnl.babel.config.Profile;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;

public class ConfigurationTest {
    public static void main(String[] argv) {
        String language;
        Iterator l;
        String metadata_uri = null;
        String configuration_uri = null;
        if (argv.length == 1) {
            configuration_uri = argv[0];
        } else if (argv.length == 2) {
            metadata_uri = argv[0];
            configuration_uri = argv[1];
        } else {
            System.err.println("usage: gov.llnl.babel.config.ConfigurationTest [metadata-uri] configuration-uri");
            System.exit(1);
        }
        Configuration config = new Configuration();
        if (metadata_uri != null) {
            try {
                config.setMetadataDescription(metadata_uri);
            }
            catch (IOException ex) {
                System.err.println("Babel: Error: Invalid metadata URI");
                System.err.println(ex.getMessage());
            }
            catch (SAXException ex) {
                System.err.println("Babel: Error: Metadata format error");
                System.err.println(ex.getMessage());
            }
        }
        try {
            config.readConfiguration(configuration_uri);
        }
        catch (IOException ex) {
            System.err.println("Babel: Error: Invalid configuration URI");
            System.err.println(ex.getMessage());
        }
        catch (InvalidConfiguration ex) {
            System.err.println("Babel: Error: Configuration format error");
            System.err.println(ex.getMessage());
        }
        Set languages = config.getLanguages();
        if (languages.isEmpty()) {
            System.out.println("No languages are supported");
        } else {
            System.out.println();
            System.out.println("Currently supported languages:");
            l = languages.iterator();
            while (l.hasNext()) {
                language = (String)l.next();
                System.out.println("   " + language);
            }
        }
        System.out.println();
        l = languages.iterator();
        while (l.hasNext()) {
            language = (String)l.next();
            System.out.println("Profiles for language " + language + ":");
            Set profiles = config.getProfileNames(language);
            if (profiles == null || profiles.isEmpty()) {
                System.out.println("No profiles defined");
                continue;
            }
            Iterator p = profiles.iterator();
            while (p.hasNext()) {
                String profile_name = (String)p.next();
                Profile profile = config.getProfile(language, profile_name);
                System.out.println("Profile name: " + profile_name);
                System.out.println("Summary: " + profile.getSummary());
                System.out.println("Description:");
                System.out.println(profile.getDescription());
                System.out.println("CPU: " + profile.getCPU());
                System.out.println("OS: " + profile.getOS());
                System.out.println("OS Release: " + profile.getOSRelease());
                System.out.println("Compiler: " + profile.getCompilerName());
                System.out.println("Version: " + profile.getCompilerVersion());
                System.out.println("Configuration options:");
                Map options = profile.getConfiguration();
                if (options == null || options.isEmpty()) {
                    System.out.println("No options given");
                } else {
                    Set keys = options.keySet();
                    Iterator k = keys.iterator();
                    while (k.hasNext()) {
                        String key = (String)k.next();
                        String value = (String)options.get(key);
                        System.out.println("\"" + key + "\"=\"" + value + "\"");
                    }
                }
                System.out.println();
            }
        }
    }
}

