/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.AssertionExpression;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.IdentifierLiteral;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.MethodCall;
import java.util.ArrayList;

public class BinaryExpression
extends AssertionExpression {
    private AssertionExpression d_lhs = null;
    private int d_op = 0;
    private AssertionExpression d_rhs = null;
    private boolean d_array_relation = false;
    private String d_array_name_lhs = null;
    private String d_array_name_rhs = null;
    public static final int NOOP = 0;
    public static final int AND = 1;
    public static final int DIVIDE = 2;
    public static final int EQUALS = 3;
    public static final int EXPON = 4;
    public static final int GREATER_EQUAL = 5;
    public static final int GREATER_THAN = 6;
    public static final int IF_AND_ONLY_IF = 7;
    public static final int IMPLIES = 8;
    public static final int LESS_EQUAL = 9;
    public static final int LESS_GREATER = 10;
    public static final int LESS_THAN = 11;
    public static final int MINUS = 12;
    public static final int MODULUS = 13;
    public static final int MULTIPLY = 14;
    public static final int NOT_EQUAL = 15;
    public static final int OR = 16;
    public static final int PLUS = 17;
    public static final int POWER = 18;
    public static final int REMAINDER = 19;
    public static final int SHIFT_LEFT = 20;
    public static final int SHIFT_RIGHT = 21;
    public static final int XOR = 22;
    public static final int MIN_OP_VALUE = 1;
    public static final int MAX_OP_VALUE = 22;
    private static final String[] s_symbol = new String[]{"", "and", "/", "==", "^", ">=", ">", "iff", "implies", "<=", "<>", "<", "-", "mod", "*", "!=", "or", "+", "**", "rem", "<<", ">>", "xor"};
    private static final String IDENTIFIER_LITERAL = "gov.llnl.babel.symbols.IdentifierLiteral";

    public BinaryExpression(AssertionExpression lhs, int op, AssertionExpression rhs) throws AssertionException {
        super(false);
        if (op < 1 || op > 22) {
            throw new AssertionException("Cannot instantiate BinaryExpression since binary operator value \"" + op + "\" invalid, must be in " + 1 + "..." + 22 + ".");
        }
        if (lhs == null || rhs == null) {
            throw new AssertionException("Cannot instantiate BinaryExpression when lhs \"" + lhs.toString() + "\" and/or rhs \"" + rhs.toString() + "\" is null.");
        }
        this.d_lhs = lhs;
        this.d_op = op;
        this.d_rhs = rhs;
    }

    public AssertionExpression getLeftExpression() {
        return this.d_lhs;
    }

    public int getOp() {
        return this.d_op;
    }

    public String getOpSymbol() {
        return s_symbol[this.d_op];
    }

    public AssertionExpression getRightExpression() {
        return this.d_rhs;
    }

    public void setArrayRelationRequired(boolean isReq) {
        this.d_array_relation = isReq;
    }

    public boolean isArrayRelationRequired() {
        return this.d_array_relation;
    }

    public String getArrayRelationVariable(boolean onLeft) {
        return onLeft ? this.d_array_name_lhs : this.d_array_name_rhs;
    }

    public String getArrayRelation() {
        String rel = null;
        rel = this.arrayOnLeft() && this.arrayOnRight() ? s_symbol[this.d_op] : (this.arrayOnLeft() ? s_symbol[this.d_op] + this.d_rhs.cExpression(null, null) : this.d_lhs.cExpression(null, null) + s_symbol[this.d_op]);
        return rel;
    }

    public boolean arrayOnLeft() {
        return this.d_array_name_lhs != null;
    }

    public boolean arrayOnRight() {
        return this.d_array_name_rhs != null;
    }

    public boolean hasPure() {
        return this.d_lhs.hasPure() || this.d_rhs.hasPure();
    }

    public boolean hasResult() {
        return this.d_lhs.hasResult() || this.d_rhs.hasResult();
    }

    public boolean hasMethodCall() {
        return this.d_lhs.hasMethodCall() || this.d_rhs.hasMethodCall();
    }

    public boolean hasReservedMethod(int type) {
        return this.d_lhs.hasReservedMethod(type) || this.d_rhs.hasReservedMethod(type);
    }

    public boolean hasUnreservedMethod(boolean any) {
        return this.d_lhs.hasUnreservedMethod(any) || this.d_rhs.hasUnreservedMethod(any);
    }

    public boolean requiresExtendableContext() {
        return this.d_lhs.requiresExtendableContext() || this.d_rhs.requiresExtendableContext();
    }

    public boolean requiresMethodContext() {
        return this.d_lhs.requiresMethodContext() || this.d_rhs.requiresMethodContext();
    }

    private boolean isNullIdentifier(AssertionExpression expr) {
        boolean isNull = false;
        IdentifierLiteral id = null;
        String litname = IDENTIFIER_LITERAL;
        if (expr.getClass().getName().equals(litname)) {
            id = (IdentifierLiteral)expr;
        }
        if (id != null && id.isNull()) {
            isNull = true;
        }
        return isNull;
    }

    private void validateSubexpressions(Extendable ext, Method m) throws AssertionException {
        if (this.d_lhs.hasPure() || this.d_rhs.hasPure()) {
            throw new AssertionException("Binary expression cannot contain a PURE clause.");
        }
        boolean setleft = this.isNullIdentifier(this.d_lhs);
        boolean setright = this.isNullIdentifier(this.d_rhs);
        if (setleft && setright) {
            this.d_lhs.setReturnToOpaque();
            this.d_lhs.validateExpression(ext, m);
            this.d_rhs.setReturnToOpaque();
            this.d_rhs.validateExpression(ext, m);
        } else if (setleft) {
            this.d_rhs.validateExpression(ext, m);
            this.d_lhs.setReturnType(this.d_rhs.getReturnType());
            this.d_lhs.validateExpression(ext, m);
        } else if (setright) {
            this.d_lhs.validateExpression(ext, m);
            this.d_rhs.setReturnType(this.d_lhs.getReturnType());
            this.d_rhs.validateExpression(ext, m);
        } else {
            this.d_lhs.validateExpression(ext, m);
            this.d_rhs.validateExpression(ext, m);
        }
    }

    private boolean returnBoolean(int lType, int rType) {
        boolean isBool = false;
        if (this.returnIsBoolean()) {
            isBool = true;
        } else if (lType == 1 && rType == 1) {
            isBool = true;
        }
        return isBool;
    }

    private boolean returnInteger(int lType, int rType) {
        boolean isInt = false;
        if (this.returnIsInteger()) {
            isInt = true;
        } else if (lType == 7 && rType == 7) {
            isInt = true;
        }
        return isInt;
    }

    private boolean returnLong(int lType, int rType) {
        boolean isLong = false;
        if (this.returnIsLong()) {
            isLong = true;
        } else if (lType == 7 && rType == 7 || lType == 8 && rType == 7 || lType == 8 && rType == 8) {
            isLong = true;
        }
        return isLong;
    }

    private boolean returnFloat(int lType, int rType) {
        boolean isFloat = false;
        if (this.returnIsFloat()) {
            isFloat = true;
        } else if (lType == 7 && rType == 6 || lType == 6 && rType == 7 || lType == 8 && rType == 6 || lType == 6 && rType == 8 || lType == 6 && rType == 6) {
            isFloat = true;
        }
        return isFloat;
    }

    private boolean returnDouble(int lType, int rType) {
        boolean isDouble = false;
        if (this.returnIsDouble()) {
            isDouble = true;
        } else if (lType == 7 && rType == 4 || lType == 4 && rType == 7 || lType == 8 && rType == 4 || lType == 4 && rType == 8 || lType == 6 && rType == 4 || lType == 4 && rType == 6 || lType == 4 && rType == 4) {
            isDouble = true;
        }
        return isDouble;
    }

    private boolean returnFComplex(int lType, int rType) {
        boolean isFComplex = false;
        if (this.returnIsFComplex()) {
            isFComplex = true;
        } else if (lType == 5 && rType == 5) {
            isFComplex = true;
        }
        return isFComplex;
    }

    private boolean returnDComplex(int lType, int rType) {
        boolean isDComplex = false;
        if (this.returnIsDComplex()) {
            isDComplex = true;
        } else if (lType == 5 && rType == 3 || lType == 3 && rType == 5 || lType == 3 && rType == 3) {
            isDComplex = true;
        }
        return isDComplex;
    }

    private boolean returnCharacter(int lType, int rType) {
        boolean isChar = false;
        if (this.returnIsCharacter()) {
            isChar = true;
        } else if (lType == 2 && rType == 2 && this.d_op != 17) {
            isChar = true;
        }
        return isChar;
    }

    private boolean returnString(int lType, int rType) {
        boolean isString = false;
        if (this.returnIsString()) {
            isString = true;
        } else if (lType == 2 && rType == 2 && this.d_op == 17 || lType == 2 && rType == 10 || lType == 10 && rType == 2 || lType == 10 && rType == 10) {
            isString = true;
        }
        return isString;
    }

    private boolean returnOpaque(int lType, int rType) {
        boolean isOpaque = false;
        if (this.returnIsOpaque()) {
            isOpaque = true;
        } else if (lType == 9 && rType == 9) {
            isOpaque = true;
        }
        return isOpaque;
    }

    private String getReturnExceptionMessage(String required) {
        return "Unable to set return type for expression \"" + this.toString() + "\" since both subexpressions must return " + required + " values to apply the \"" + this.getOpSymbol() + "\" operator.  The left expression returns \"" + this.d_lhs.getReturnTypeName() + "\" while the right returns \"" + this.d_rhs.getReturnTypeName() + "\".";
    }

    private String getStringCompareExceptionMessage() {
        return "Unable to set return type for expression \"" + this.toString() + "\" since string comparison operations are not currently " + "supported.  The left expression returns \"" + this.d_lhs.getReturnTypeName() + "\" while the right returns \"" + this.d_rhs.getReturnTypeName() + "\".";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setArrayName(AssertionExpression ae, boolean onLeft) throws AssertionException {
        String className = ae.getClass().getName();
        if (!className.equals(IDENTIFIER_LITERAL)) throw new AssertionException("Semantic Validation Failure: Expecting to find an array variable name in \"" + this.toString() + "\" but detected an expression class of type " + className + " instead.");
        IdentifierLiteral lit = (IdentifierLiteral)ae;
        if (!lit.isArgument()) throw new AssertionException("Semantic Validation Failure: Expecting to find an array variable name in \"" + this.toString() + "\" but detected an identifier/literal expression of type " + lit.getIdentifierTypeName() + " instead.");
        if (onLeft) {
            this.d_array_name_lhs = lit.getIdentifier();
            return;
        } else {
            this.d_array_name_rhs = lit.getIdentifier();
        }
    }

    private void setBooleanRelationData() throws AssertionException {
        int lType = this.d_lhs.getReturnTypeValue();
        int rType = this.d_rhs.getReturnTypeValue();
        if (lType == 16) {
            this.setArrayName(this.d_lhs, true);
        }
        if (rType == 16) {
            this.setArrayName(this.d_rhs, false);
        }
        if (lType != 16 && rType != 16) {
            throw new AssertionException("Semantic Validation Failure: Expecting a simple boolean expression with an array variable on one or both sides but no array detected in \"" + this.toString() + "\".  The left side returns type \"" + this.d_lhs.getReturnTypeName() + "\" while the right returns \"" + this.d_rhs.getReturnTypeName() + "\".");
        }
        this.setReturnToBoolean();
    }

    private void setNumericType() throws AssertionException {
        int rType;
        int lType = this.d_lhs.getReturnTypeValue();
        if (this.returnInteger(lType, rType = this.d_rhs.getReturnTypeValue())) {
            this.setReturnToInteger();
        } else if (this.returnLong(lType, rType)) {
            this.setReturnToLong();
        } else if (this.returnFloat(lType, rType)) {
            this.setReturnToFloat();
        } else if (this.returnDouble(lType, rType)) {
            this.setReturnToDouble();
        } else if (this.returnFComplex(lType, rType)) {
            this.setReturnToFComplex();
        } else if (this.returnDComplex(lType, rType)) {
            this.setReturnToDComplex();
        } else {
            throw new AssertionException("Unable to set return to a numeric type. Numeric binary expression \"" + this.toString() + "\" does not appear to contain expressions with compatible " + "return types.  Left returns " + this.d_lhs.getReturnTypeName() + " while right returns " + this.d_rhs.getReturnTypeName() + ".");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setNumericTypeToBoolean() throws AssertionException {
        if (!this.d_array_relation) {
            int rType;
            int lType = this.d_lhs.getReturnTypeValue();
            if (this.returnInteger(lType, rType = this.d_rhs.getReturnTypeValue())) {
                this.setReturnToBoolean();
                return;
            } else if (this.returnLong(lType, rType)) {
                this.setReturnToBoolean();
                return;
            } else if (this.returnFloat(lType, rType)) {
                this.setReturnToBoolean();
                return;
            } else if (this.returnDouble(lType, rType)) {
                this.setReturnToBoolean();
                return;
            } else if (this.returnFComplex(lType, rType)) {
                this.setReturnToBoolean();
                return;
            } else {
                if (!this.returnDComplex(lType, rType)) throw new AssertionException("Cannot set return of numeric to boolean. Numeric binary expression \"" + this.toString() + "\" does not appear to contain expressions with compatible " + "return types.  Left returns " + this.d_lhs.getReturnTypeName() + " while right returns " + this.d_rhs.getReturnTypeName() + ".");
                this.setReturnToBoolean();
            }
            return;
        } else {
            this.setBooleanRelationData();
        }
    }

    private void setBooleanOrIntegerType() throws AssertionException {
        int rType;
        int lType = this.d_lhs.getReturnTypeValue();
        if (this.returnBoolean(lType, rType = this.d_rhs.getReturnTypeValue())) {
            this.setReturnToBoolean();
        } else if (this.returnInteger(lType, rType)) {
            this.setReturnToInteger();
        } else if (this.returnLong(lType, rType)) {
            this.setReturnToLong();
        } else {
            throw new AssertionException(this.getReturnExceptionMessage("either boolean, integer, or long"));
        }
    }

    private void setIntegerType() throws AssertionException {
        int rType;
        int lType = this.d_lhs.getReturnTypeValue();
        if (this.returnInteger(lType, rType = this.d_rhs.getReturnTypeValue())) {
            this.setReturnToInteger();
        } else if (this.returnLong(lType, rType)) {
            this.setReturnToLong();
        } else {
            throw new AssertionException(this.getReturnExceptionMessage("integer or long"));
        }
    }

    private void setSameTypeToBoolean() throws AssertionException {
        if (!this.d_array_relation) {
            if (this.d_lhs.getReturnTypeValue() == this.d_rhs.getReturnTypeValue()) {
                this.setReturnToBoolean();
            } else {
                this.setNumericTypeToBoolean();
            }
        } else {
            this.setBooleanRelationData();
        }
    }

    protected void validateSemantics(Extendable ext, Method m) throws AssertionException {
        this.validateSubexpressions(ext, m);
        switch (this.d_op) {
            case 1: {
                this.setBooleanOrIntegerType();
                break;
            }
            case 2: {
                this.setNumericType();
                break;
            }
            case 3: {
                if (!this.returnString(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue())) {
                    this.setSameTypeToBoolean();
                    break;
                }
                throw new AssertionException(this.getStringCompareExceptionMessage());
            }
            case 4: {
                this.setNumericType();
                break;
            }
            case 5: {
                if (!this.returnString(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue())) {
                    this.setNumericTypeToBoolean();
                    break;
                }
                throw new AssertionException(this.getStringCompareExceptionMessage());
            }
            case 6: {
                if (!this.returnString(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue())) {
                    this.setNumericTypeToBoolean();
                    break;
                }
                throw new AssertionException(this.getStringCompareExceptionMessage());
            }
            case 7: {
                if (this.returnBoolean(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue())) {
                    this.setReturnToBoolean();
                    break;
                }
                throw new AssertionException(this.getReturnExceptionMessage("boolean"));
            }
            case 8: {
                if (this.returnBoolean(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue())) {
                    this.setReturnToBoolean();
                    break;
                }
                throw new AssertionException(this.getReturnExceptionMessage("boolean"));
            }
            case 9: {
                if (!this.returnString(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue())) {
                    this.setNumericTypeToBoolean();
                    break;
                }
                throw new AssertionException(this.getStringCompareExceptionMessage());
            }
            case 10: {
                if (!this.returnString(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue())) {
                    this.setNumericTypeToBoolean();
                    break;
                }
                throw new AssertionException(this.getStringCompareExceptionMessage());
            }
            case 11: {
                this.setNumericTypeToBoolean();
                break;
            }
            case 12: {
                this.setNumericType();
                break;
            }
            case 13: {
                this.setIntegerType();
                break;
            }
            case 14: {
                this.setNumericType();
                break;
            }
            case 15: {
                if (!this.returnString(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue())) {
                    this.setSameTypeToBoolean();
                    break;
                }
                throw new AssertionException(this.getStringCompareExceptionMessage());
            }
            case 16: {
                this.setBooleanOrIntegerType();
                break;
            }
            case 17: {
                if (this.returnString(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue())) {
                    throw new AssertionException("Unable to validate expression semantics for \"" + this.getExceptionPrefix(ext, m) + "\" since do not currently support string concatentation" + ", which is being attempted with the expressions \"" + this.d_lhs.toString() + "\" and \"" + this.d_rhs.toString() + "\".");
                }
                this.setNumericType();
                break;
            }
            case 18: {
                this.setNumericType();
                break;
            }
            case 19: {
                this.setIntegerType();
                break;
            }
            case 20: {
                this.setIntegerType();
                break;
            }
            case 21: {
                this.setIntegerType();
                break;
            }
            case 22: {
                this.setBooleanOrIntegerType();
                break;
            }
            default: {
                throw new AssertionException("Unable to validate expression semantics for \"" + this.getExceptionPrefix(ext, m) + "\" since invalid or unrecognized operator value \"" + this.d_op + "\" for an expression whose left expression returns " + this.d_lhs.getReturnTypeName() + " values and right returns " + this.d_rhs.getReturnTypeName() + " values.");
            }
        }
    }

    private int[] getNextStartInd(int[] startInd) {
        int[] nextStartInd = new int[3];
        for (int i = 0; i < 3; ++i) {
            nextStartInd[i] = startInd[i] + this.d_lhs.getNumArrayIterMacrosByType(MethodCall.MACRO_RETURN_TYPE[i]);
        }
        return nextStartInd;
    }

    public ArrayList getArrayIterMacros(String epvVar, int[] startInd) {
        ArrayList list = new ArrayList();
        ArrayList ll = this.d_lhs.getArrayIterMacros(epvVar, startInd);
        ArrayList rl = this.d_rhs.getArrayIterMacros(epvVar, this.getNextStartInd(startInd));
        if (ll != null && ll.size() > 0) {
            list.addAll(ll);
        }
        if (rl != null && rl.size() > 0) {
            list.addAll(rl);
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    public int getNumArrayIterMacrosByType(char type) {
        return this.d_lhs.getNumArrayIterMacrosByType(type) + this.d_rhs.getNumArrayIterMacrosByType(type);
    }

    public String cExpression(String epvVar, int[] startInd) {
        String expr = null;
        String lhs = this.d_lhs.cExpression(epvVar, startInd);
        String rhs = this.d_rhs.cExpression(epvVar, this.getNextStartInd(startInd));
        switch (this.d_op) {
            case 1: {
                if (this.returnBoolean(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue())) {
                    expr = "( " + lhs + " && " + rhs + " )";
                    break;
                }
                expr = "( (" + lhs + ") & (" + rhs + ") )";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: {
                expr = "( (" + lhs + ") " + this.getOpSymbol() + " (" + rhs + ") )";
                break;
            }
            case 4: 
            case 18: {
                expr = "pow(" + lhs + ", " + rhs + ")";
                break;
            }
            case 7: {
                expr = "(  ( " + lhs + " && " + rhs + " ) " + "|| ( (!" + lhs + ") && (!" + rhs + ") )  )";
                break;
            }
            case 8: {
                expr = "( (!" + lhs + ") || " + rhs + " )";
                break;
            }
            case 13: 
            case 19: {
                expr = "( (" + lhs + ") % (" + rhs + ") )";
                break;
            }
            case 16: {
                if (this.returnBoolean(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue())) {
                    expr = "( " + lhs + " || " + rhs + " )";
                    break;
                }
                expr = "( (" + lhs + ") | (" + rhs + ") )";
                break;
            }
            case 22: {
                expr = this.returnBoolean(this.d_lhs.getReturnTypeValue(), this.d_rhs.getReturnTypeValue()) ? "( ( " + lhs + " || " + rhs + " ) " + "&& !( " + lhs + " && " + rhs + " ) )" : "( (" + lhs + ") ^ (" + rhs + ") )";
            }
        }
        return expr;
    }

    public String toString() {
        String expr = this.d_lhs + " " + this.getOpSymbol() + " " + this.d_rhs;
        return this.hasParens() ? "(" + expr + ")" : expr;
    }
}

