// 
// File:          gov_cca_Services.cc
// Symbol:        gov.cca.Services-v0.6.3
// Symbol Type:   interface
// Babel Version: 0.10.2
// Description:   Client-side glue code for gov.cca.Services
// 
// WARNING: Automatically generated; changes will be lost
// 
// babel-version = 0.10.2
// 

#ifndef included_gov_cca_Services_hh
#include "gov_cca_Services.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_BaseClass_hh
#include "sidl_BaseClass.hh"
#endif
#ifndef included_sidl_BaseException_hh
#include "sidl_BaseException.hh"
#endif
#include "sidl_String.h"
#include "babel_config.h"
#ifdef SIDL_DYNAMIC_LIBRARY
#include <stdio.h>
#include <stdlib.h>
#include "sidl_Loader.hh"
#endif


//////////////////////////////////////////////////
// 
// User Defined Methods
// 


/**
 * Return true if and only if <code>obj</code> refers to the same
 * object as this object.
 */
bool
gov::cca::Services::isSame( /* in */ ::sidl::BaseInterface iobj )
throw ()

{
  bool _result;
  sidl_bool _local_result;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_isSame))(d_self->d_object,
    /* in */ iobj._get_ior() );
  /*dispatch to ior*/
  _result = _local_result;
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Check whether the object can support the specified interface or
 * class.  If the <code>sidl</code> type name in <code>name</code>
 * is supported, then a reference to that object is returned with the
 * reference count incremented.  The callee will be responsible for
 * calling <code>deleteRef</code> on the returned object.  If
 * the specified type is not supported, then a null reference is
 * returned.
 */
::sidl::BaseInterface
gov::cca::Services::queryInt( /* in */ const ::std::string& name )
throw ()

{
  ::sidl::BaseInterface _result;
  /*pack args to dispatch to ior*/
  _result = ::sidl::BaseInterface( 
    (*(d_self->d_epv->f_queryInt))(d_self->d_object, /* in */ name.c_str() ),
    false);
  /*dispatch to ior*/
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Return whether this object is an instance of the specified type.
 * The string name must be the <code>sidl</code> type name.  This
 * routine will return <code>true</code> if and only if a cast to
 * the string type name would succeed.
 */
bool
gov::cca::Services::isType( /* in */ const ::std::string& name )
throw ()

{
  bool _result;
  sidl_bool _local_result;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_isType))(d_self->d_object,
    /* in */ name.c_str() );
  /*dispatch to ior*/
  _result = _local_result;
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Return the meta-data about the class implementing this interface.
 */
::sidl::ClassInfo
gov::cca::Services::getClassInfo(  )
throw ()

{
  ::sidl::ClassInfo _result;
  /*pack args to dispatch to ior*/
  _result = ::sidl::ClassInfo( 
    (*(d_self->d_epv->f_getClassInfo))(d_self->d_object ), false);
  /*dispatch to ior*/
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Fetch a previously registered Port (defined by either 
 * addProvidePort or (more typically) registerUsesPort).  
 * @return Will return the Port (possibly waiting forever while
 * attempting to acquire it) or throw an exception. Does not return
 * NULL, even in the case where no connection has been made. 
 * If a Port is returned,
 * there is then a contract that the port will remain valid for use
 * by the caller until the port is released via releasePort(), or a 
 * Disconnect Event is successfully dispatched to the caller,
 * or a runtime exception (such as network failure) occurs during 
 * invocation of some function in the Port. 
 * <p>
 * Subtle interpretation: If the Component is not listening for
 * Disconnect events, then the framework has no clean way to
 * break the connection until after the component calls releasePort.
 * </p>
 * <p>The framework may go through some machinations to obtain
 *    the port, possibly involving an interactive user or network 
 *    queries, before giving up and throwing an exception.
 * </p>
 * 
 * @param portName The previously registered or provide port which
 * 	   the component now wants to use.
 * @exception CCAException with the following types: NotConnected, PortNotDefined, 
 *                NetworkError, OutOfMemory.
 */
::gov::cca::Port
gov::cca::Services::getPort( /* in */ const ::std::string& portName )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::Port _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::Port( (*(d_self->d_epv->f_getPort))(d_self->d_object,
    /* in */ portName.c_str(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Get a previously registered Port (defined by
 * either addProvide or registerUses) and return that
 * Port if it is available immediately (already connected
 * without further connection machinations).
 * There is an contract that the
 * port will remain valid per the description of getPort.
 * @return The named port, if it exists and is connected or self-provided,
 * 	      or NULL if it is registered and is not yet connected. Does not
 * 	      return if the Port is neither registered nor provided, but rather
 * 	      throws an exception.
 * @param portName registered or provided port that
 * 	     the component now wants to use.
 * @exception CCAException with the following types: PortNotDefined, OutOfMemory.
 */
::gov::cca::Port
gov::cca::Services::getPortNonblocking( /* in */ const ::std::string& portName )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::Port _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::Port( 
    (*(d_self->d_epv->f_getPortNonblocking))(d_self->d_object,
    /* in */ portName.c_str(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Notifies the framework that this component is finished 
 * using the previously fetched Port that is named.     
 * The releasePort() method calls should be paired with 
 * getPort() method calls; however, an extra call to releasePort()
 * for the same name may (is not required to) generate an exception.
 * Calls to release ports which are not defined or have never be fetched
 * with one of the getPort functions generate exceptions.
 * @param portName The name of a port.
 * @exception CCAException with the following types: PortNotDefined, PortNotInUse.
 */
void
gov::cca::Services::releasePort( /* in */ const ::std::string& portName )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_releasePort))(d_self->d_object, /* in */ portName.c_str(),
    &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Creates a TypeMap, potentially to be used in subsequent
 * calls to describe a Port.  Initially, this map is empty.
 */
::gov::cca::TypeMap
gov::cca::Services::createTypeMap(  )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::TypeMap _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::TypeMap( 
    (*(d_self->d_epv->f_createTypeMap))(d_self->d_object, &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Register a request for a Port that will be retrieved subsequently 
 * with a call to getPort().
 * @param portName A string uniquely describing this port.  This string
 * must be unique for this component, over both uses and provides ports.
 * @param type A string desribing the type of this port.
 * @param properties A TypeMap describing optional properties
 * associated with this port. This can be a null pointer, which
 * indicates an empty list of properties.  Properties may be
 * obtained from createTypeMap or any other source.  The properties
 * be copied into the framework, and subsequent changes to the
 * properties object will have no effect on the properties
 * associated with this port.
 * In these properties, all frameworks recognize at least the
 * following keys and values in implementing registerUsesPort:
 * <pre xml:space="preserve">
 * key:              standard values (in string form)     default
 * "MAX_CONNECTIONS" any nonnegative integer, "unlimited".   1
 * "MIN_CONNECTIONS" any integer > 0.                        0
 * "ABLE_TO_PROXY"   "true", "false"                      "false"
 * </pre>
 * The component is not expected to work if the framework
 * has not satisfied the connection requirements.
 * The framework is allowed to return an error if it
 * is incapable of meeting the connection requirements,
 * e.g. it does not implement multiple uses ports.
 * The caller of registerUsesPort is not obligated to define
 * these properties. If left undefined, the default listed above is
 *       assumed.
 * @exception CCAException with the following types: PortAlreadyDefined, OutOfMemory.
 */
void
gov::cca::Services::registerUsesPort( /* in */ const ::std::string& portName,
  /* in */ const ::std::string& type, /* in */ ::gov::cca::TypeMap properties )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_registerUsesPort))(d_self->d_object,
    /* in */ portName.c_str(), /* in */ type.c_str(),
    /* in */ properties._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Notify the framework that a Port, previously registered by this
 * component but currently not in use, is no longer desired. 
 * Unregistering a port that is currently 
 * in use (i.e. an unreleased getPort() being outstanding) 
 * is an error.
 * @param name The name of a registered Port.
 * @exception CCAException with the following types: UsesPortNotReleased, PortNotDefined.
 */
void
gov::cca::Services::unregisterUsesPort( /* in */ const ::std::string& portName )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_unregisterUsesPort))(d_self->d_object,
    /* in */ portName.c_str(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Exposes a Port from this component to the framework.  
 * This Port is now available for the framework to connect 
 * to other components. 
 * @param inPort An abstract interface (tagged with CCA-ness
 * 	by inheriting from gov.cca.Port) the framework will
 * 	make available to other components.
 * 
 * @param portName string uniquely describing this port.  This string
 * must be unique for this component, over both uses and provides ports.
 * 
 * @param type string describing the type (class) of this port.
 * 
 * @param properties A TypeMap describing optional properties
 * associated with this port. This can be a null pointer, which
 * indicates an empty list of properties.  Properties may be
 * obtained from createTypeMap or any other source.  The properties
 * be copied into the framework, and subsequent changes to the
 * properties object will have no effect on the properties
 * associated with this port.
 * In these properties, all frameworks recognize at least the
 * following keys and values in implementing registerUsesPort:
 * <pre xml:space="preserve">
 * key:              standard values (in string form)     default
 * "MAX_CONNECTIONS" any nonnegative integer, "unlimited".   1
 * "MIN_CONNECTIONS" any integer > 0.                        0
 * "ABLE_TO_PROXY"   "true", "false"                      "false"
 * </pre>
 * The component is not expected to work if the framework
 * has not satisfied the connection requirements.
 * The framework is allowed to return an error if it
 * is incapable of meeting the connection requirements,
 * e.g. it does not implement multiple uses ports.
 * The caller of addProvidesPort is not obligated to define
 * these properties. If left undefined, the default listed above is
 * assumed.
 * @exception CCAException with the following types: PortAlreadyDefined, OutOfMemory.
 */
void
gov::cca::Services::addProvidesPort( /* in */ ::gov::cca::Port inPort,
  /* in */ const ::std::string& portName, /* in */ const ::std::string& type,
  /* in */ ::gov::cca::TypeMap properties )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_addProvidesPort))(d_self->d_object,
    /* in */ inPort._get_ior(), /* in */ portName.c_str(),
    /* in */ type.c_str(), /* in */ properties._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Returns the complete list of the properties for a Port.  This
 * includes the properties defined when the port was registered
 * (these properties can be modified by the framework), two special
 * properties "cca.portName" and "cca.portType", and any other
 * properties that the framework wishes to disclose to the component.
 * The framework may also choose to provide only the subset of input
 * properties (i.e. from addProvidesPort/registerUsesPort) that it
 * will honor.
 */
::gov::cca::TypeMap
gov::cca::Services::getPortProperties( /* in */ const ::std::string& name )
throw ()

{
  ::gov::cca::TypeMap _result;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::TypeMap( 
    (*(d_self->d_epv->f_getPortProperties))(d_self->d_object,
    /* in */ name.c_str() ), false);
  /*dispatch to ior*/
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Notifies the framework that a previously exposed Port is no longer 
 * available for use. The Port being removed must exist
 * until this call returns, or a CCAException may occur.
 * @param name The name of a provided Port.
 * @exception PortNotDefined. In general, the framework will not dictate 
 * when the component chooses to stop offering services.
 */
void
gov::cca::Services::removeProvidesPort( /* in */ const ::std::string& portName )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_removeProvidesPort))(d_self->d_object,
    /* in */ portName.c_str(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Get a reference to the component to which this 
 * Services object belongs. 
 */
::gov::cca::ComponentID
gov::cca::Services::getComponentID(  )
throw ()

{
  ::gov::cca::ComponentID _result;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::ComponentID( 
    (*(d_self->d_epv->f_getComponentID))(d_self->d_object ), false);
  /*dispatch to ior*/
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Obtain a callback for component destruction.
 * @param callback an object that implements the ComponentRelease
 * interface that will be called when the component is to be destroyed.
 * 
 * Register a callback to be executed when the component is going
 * to be destroyed.  During this callback, the Services object passed
 * through setServices will still be valid, but after all such
 * callbacks are made for a specific component, subsequent usage
 * of the Services object is not allowed/is undefined.
 */
void
gov::cca::Services::registerForRelease( /* in */ ::gov::cca::ComponentRelease 
  callback )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_registerForRelease))(d_self->d_object,
    /* in */ callback._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



//////////////////////////////////////////////////
// 
// End User Defined Methods
// (everything else in this file is specific to
//  Babel's C++ bindings)
// 

// default destructor
gov::cca::Services::~Services () {
  if ( d_self != 0 ) {
    deleteRef();
  }
}

// copy constructor
gov::cca::Services::Services ( const ::gov::cca::Services& original ) {
  d_self = const_cast< ior_t*>(original.d_self);
  d_weak_reference = original.d_weak_reference;
  if (d_self != 0 ) {
    addRef();
  }
}

// assignment operator
::gov::cca::Services&
gov::cca::Services::operator=( const ::gov::cca::Services& rhs ) {
  if ( d_self != rhs.d_self ) {
    if ( d_self != 0 ) {
      deleteRef();
    }
    d_self = const_cast< ior_t*>(rhs.d_self);
    d_weak_reference = rhs.d_weak_reference;
    if ( d_self != 0 ) {
      addRef();
    }
  }
  return *this;
}

// conversion from ior to C++ class
gov::cca::Services::Services ( ::gov::cca::Services::ior_t* ior ) 
    : d_self( ior ), d_weak_reference(false) {
  if ( d_self != 0 ) {
    addRef();
  }
}

// Alternate constructor: does not call addRef()
// (sets d_weak_reference=isWeak)
// For internal use by Impls (fixes bug#275)
gov::cca::Services::Services ( ::gov::cca::Services::ior_t* ior, bool isWeak ) 
    : d_self( ior ), d_weak_reference(isWeak) { 
}

// conversion from a StubBase
gov::cca::Services::Services ( const ::sidl::StubBase& base )
{
  d_self = reinterpret_cast< ior_t*>(base._cast("gov.cca.Services"));
  d_weak_reference = false;
  if (d_self != 0) {
    addRef();
  }
}

// protected method that implements casting
void* gov::cca::Services::_cast(const char* type) const
{
  void* ptr = 0;
  if ( d_self != 0 ) {
    ptr = reinterpret_cast< void*>((*d_self->d_epv->f__cast)(d_self->d_object,
      type));
  }
  return ptr;
}

extern "C" {


} // end extern "C"
