#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Args.h"
#include "synch.h"

void declare_part( synch_RegOut tracker, int *part_no );
void end_part( synch_RegOut tracker, int part_no, 
               enum synch_ResultType__enum result);

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}

#define MYASSERT( AAA ) \
  declare_part( tracker, &part_no ); \
  magicNumber = clearstack(magicNumber); \
  synch_RegOut_writeComment(tracker, #AAA); \
  if ( AAA ) result = synch_ResultType_PASS; \
  else result = synch_ResultType_FAIL;  \
  end_part( tracker, part_no, result);

#define MYXFAIL( AAA ) \
  declare_part( tracker, &part_no ); \
  magicNumber = clearstack(magicNumber); \
  synch_RegOut_writeComment(tracker, #AAA); \
  if ( AAA ) result = synch_ResultType_XPASS; \
  else result = synch_ResultType_XFAIL;  \
  end_part( tracker, part_no, result);

#define MYBROKEN( AAA ) \
  declare_part( tracker,  &part_no ); \
  synch_RegOut_writeComment(tracker, #AAA); \
  end_part( tracker, part_no, synch_ResultType_FAIL);

int main(int argc, char** argv) { 
  enum synch_ResultType__enum result = synch_ResultType_PASS;
  synch_RegOut tracker = synch_RegOut__create();
  int magicNumber = 1;
  int part_no = 0;
  const char *language = "";
  synch_RegOut_setExpectations(tracker, -1);
  if (argc == 2){
    language = argv[1];
  }
  
  { /* bool */
    int out;
    int inout = TRUE;
    Args_Cbool obj = Args_Cbool__create();;
 
    MYASSERT( Args_Cbool_returnback( obj ) == TRUE );
    MYASSERT( Args_Cbool_passin( obj, TRUE ) == TRUE );
    MYASSERT( Args_Cbool_passout( obj, &out ) == TRUE && out == TRUE );
    MYASSERT( Args_Cbool_passinout( obj, &inout ) == TRUE && inout == FALSE );
    MYASSERT( Args_Cbool_passeverywhere( obj, TRUE, &out, &inout ) == TRUE &&
	      out == TRUE && inout == TRUE );
    
    Args_Cbool_deleteRef( obj );
  } 

  { /* char */
    char out;
    char inout = 'A';
    Args_Cchar obj = Args_Cchar__create();;
 
    MYASSERT( Args_Cchar_returnback( obj ) == '3' );
    MYASSERT( Args_Cchar_passin( obj, '3' ) == TRUE );
    MYASSERT( Args_Cchar_passout( obj, &out ) == TRUE && out == '3' );
    MYASSERT( Args_Cchar_passinout( obj, &inout ) == TRUE && inout == 'a' );
    MYASSERT( Args_Cchar_passeverywhere( obj, '3', &out, &inout ) == '3' &&
	     out == '3' && inout == 'A' );

    Args_Cchar_deleteRef( obj );
  }


  { /* int */
    int32_t out;
    int32_t inout = 3;
    Args_Cint obj = Args_Cint__create();;
 
    MYASSERT( Args_Cint_returnback( obj ) == 3 );
    MYASSERT( Args_Cint_passin( obj, 3 ) == TRUE );
    MYASSERT( Args_Cint_passout( obj, &out ) == TRUE && out == 3 );
    MYASSERT( Args_Cint_passinout( obj, &inout ) == TRUE && inout == -3 );
    MYASSERT( Args_Cint_passeverywhere( obj, 3, &out, &inout ) == 3 &&
	      out == 3 && inout == 3 );
    
    Args_Cint_deleteRef( obj );
  }

  { /* long */
    int64_t out;
    int64_t inout = 3;
    Args_Clong obj = Args_Clong__create();;
 
    MYASSERT( Args_Clong_returnback( obj ) == 3 );
    MYASSERT( Args_Clong_passin( obj, 3 ) == TRUE );
    MYASSERT( Args_Clong_passout( obj, &out ) == TRUE && out == 3 );
    MYASSERT( Args_Clong_passinout( obj, &inout ) == TRUE && inout == -3 );
    MYASSERT( Args_Clong_passeverywhere( obj, 3, &out, &inout ) == 3 &&
	      out == 3 && inout == 3 );
    
    Args_Clong_deleteRef( obj );
  }

  { /* float */
    float out;
    float inout = 3.1F;
    Args_Cfloat obj = Args_Cfloat__create();;
 
    MYASSERT( Args_Cfloat_returnback( obj ) == 3.1F );
    MYASSERT( Args_Cfloat_passin( obj, 3.1F ) == TRUE );
    MYASSERT( Args_Cfloat_passout( obj, &out ) == TRUE && out == 3.1F );
    MYASSERT( Args_Cfloat_passinout( obj, &inout ) == TRUE && inout == -3.1F
              );
    MYASSERT( Args_Cfloat_passeverywhere( obj, 3.1F, &out, &inout ) ==
              3.1F && out == 3.1F && inout == 3.1F );
    
    Args_Cfloat_deleteRef( obj );
  }


  { /* double */
    double out;
    double inout = 3.14;
    Args_Cdouble obj = Args_Cdouble__create();;
 
    MYASSERT( Args_Cdouble_returnback( obj ) == 3.14 );
    MYASSERT( Args_Cdouble_passin( obj, 3.14 ) == TRUE );
    MYASSERT( Args_Cdouble_passout( obj, &out ) == TRUE && out == 3.14 );
    MYASSERT( Args_Cdouble_passinout( obj, &inout ) == TRUE && inout == -3.14 );
    MYASSERT( Args_Cdouble_passeverywhere( obj, 3.14, &out, &inout ) == 3.14 &&
	      out == 3.14 && inout == 3.14 );
    
    Args_Cdouble_deleteRef( obj );
  }


  { /* fcomplex */
    struct sidl_fcomplex retval;
    struct sidl_fcomplex in = { 3.1F, 3.1F };
    struct sidl_fcomplex out;
    struct sidl_fcomplex inout = { 3.1F, 3.1F };
    Args_Cfcomplex obj = Args_Cfcomplex__create();;
 
    printf("COMMENT: retval = Args_Cfcomplex_returnback( obj );\n");
    retval = Args_Cfcomplex_returnback( obj );
    MYASSERT( retval.real == 3.1F && retval.imaginary == 3.1F);
    MYASSERT( Args_Cfcomplex_passin( obj, in ) == TRUE );
    
    MYASSERT( Args_Cfcomplex_passout( obj, &out ) == TRUE && 
	      out.real == 3.1F && out.imaginary == 3.1F );
    MYASSERT( Args_Cfcomplex_passinout( obj, &inout ) == TRUE && 
	      inout.real == 3.1F && inout.imaginary == -3.1F );
    printf("COMMENT: retval = Args_Cfcomplex_passeverywhere( obj, in, &out, &inout );\n");
    retval = Args_Cfcomplex_passeverywhere( obj, in, &out, &inout );
    MYASSERT( retval.real == 3.1F && retval.imaginary == 3.1F &&
              out.real == 3.1F && out.imaginary == 3.1F && 
              inout.real == 3.1F && inout.imaginary == 3.1F );
    
    Args_Cfcomplex_deleteRef( obj );
  }

  
  { /* dcomplex */
    struct sidl_dcomplex retval;
    struct sidl_dcomplex in = { 3.14, 3.14 };
    struct sidl_dcomplex out;
    struct sidl_dcomplex inout = { 3.14, 3.14 };
    Args_Cdcomplex obj = Args_Cdcomplex__create();;

    printf("COMMENT: retval = Args_Cdcomplex_returnback( obj );\n");
    retval = Args_Cdcomplex_returnback( obj ); 
    MYASSERT( retval.real == 3.14 && retval.imaginary == 3.14);
    MYASSERT( Args_Cdcomplex_passin( obj, in ) == TRUE );
    MYASSERT( Args_Cdcomplex_passout( obj, &out ) == TRUE && 
	      out.real == 3.14 && out.imaginary == 3.14 );
    MYASSERT( Args_Cdcomplex_passinout( obj, &inout ) == TRUE && 
	      inout.real == 3.14 && inout.imaginary == -3.14 );
    printf("COMMENT: retval = Args_Cdcomplex_passeverywhere( obj, in, &out, &inout );\n");
    retval = Args_Cdcomplex_passeverywhere( obj, in, &out, &inout ); 
    MYASSERT( retval.real == 3.14 && retval.imaginary == 3.14 &&
	      out.real == 3.14 && out.imaginary == 3.14 && 
	      inout.real == 3.14 && inout.imaginary == 3.14 );
    
    Args_Cdcomplex_deleteRef( obj );
  }

  synch_RegOut_close(tracker);
  synch_RegOut_deleteRef(tracker);
  return 0;
}

void declare_part( synch_RegOut tracker, int * part_no ) {
  synch_RegOut_startPart(tracker, ++(*part_no));
}

void end_part( synch_RegOut tracker, int part_no, 
               enum synch_ResultType__enum result) {
  synch_RegOut_endPart(tracker, part_no, result);
}

