/*
 * File:          sidl_Loader_jniStub.c
 * Symbol:        sidl.Loader-v0.9.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.Loader
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_Loader_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * External reference to IOR methods.
 */

static const struct sidl_Loader__external* s_external = NULL;

/*
 * External reference to static EPV.
 */

static const struct sidl_Loader__sepv* s_sepv = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * Load the specified library if it has not already been loaded.
 * The URI format is defined in class <code>DLL</code>.  The search
 * path is not searched to resolve the library name.
 * 
 * @param uri          the URI to load. This can be a .la file
 *                     (a metadata file produced by libtool) or
 *                     a shared library binary (i.e., .so,
 *                     .dll or whatever is appropriate for your
 *                     OS)
 * @param loadGlobally <code>true</code> means that the shared
 *                     library symbols will be loaded into the
 *                     global namespace; <code>false</code> 
 *                     means they will be loaded into a 
 *                     private namespace. Some operating systems
 *                     may not be able to honor the value presented
 *                     here.
 * @param loadLazy     <code>true</code> instructs the loader to
 *                     that symbols can be resolved as needed (lazy)
 *                     instead of requiring everything to be resolved
 *                     now.
 * @return if the load was successful, a non-NULL DLL object is returned.
 */

static jobject
jni_loadLibrary(
  JNIEnv* env,
  jclass  cls,
  jstring _arg_uri,
  jboolean _arg_loadGlobally,
  jboolean _arg_loadLazy)
{
  /*
   * Declare return and temporary variables.
   */

  char* _tmp_uri = (char*) NULL;
  sidl_bool _tmp_loadGlobally = FALSE;
  sidl_bool _tmp_loadLazy = FALSE;
  struct sidl_DLL__object* _ior_res = (struct sidl_DLL__object*) NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_uri = sidl_Java_J2I_string(env, _arg_uri);
  _tmp_loadGlobally = (sidl_bool) _arg_loadGlobally;
  _tmp_loadLazy = (sidl_bool) _arg_loadLazy;

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_loadLibrary))(
    _tmp_uri,
    _tmp_loadGlobally,
    _tmp_loadLazy);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_uri);
  _res = sidl_Java_I2J_cls(env, _ior_res, "sidl.DLL");

  return _res;
}

/*
 * Append the specified DLL to the beginning of the list of already
 * loaded DLLs.
 */

static void
jni_addDLL(
  JNIEnv* env,
  jclass  cls,
  jobject _arg_dll)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_DLL__object* _tmp_dll = (struct sidl_DLL__object*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_dll = (struct sidl_DLL__object*) sidl_Java_J2I_cls(env, _arg_dll);

  /*
   * Call the IOR method through the EPV.
   */

  (*(s_sepv->f_addDLL))(
    _tmp_dll);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Unload all dynamic link libraries.  The library may no longer
 * be used to access symbol names.  When the library is actually
 * unloaded from the memory image depends on details of the operating
 * system.
 */

static void
jni_unloadLibraries(
  JNIEnv* env,
  jclass  cls)
{
  /*
   * Declare return and temporary variables.
   */


  /*
   * Preprocess Java types and convert into IOR.
   */


  /*
   * Call the IOR method through the EPV.
   */

  (*(s_sepv->f_unloadLibraries))();

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Find a DLL containing the specified information for a sidl
 * class. This method searches SCL files in the search path looking
 * for a shared library that contains the client-side or IOR
 * for a particular sidl class.
 * 
 * This call is implemented by calling the current
 * <code>Finder</code>. The default finder searches the local
 * file system for <code>.scl</code> files to locate the
 * target class/interface.
 * 
 * @param sidl_name  the fully qualified (long) name of the
 *                   class/interface to be found. Package names
 *                   are separated by period characters from each
 *                   other and the class/interface name.
 * @param target     to find a client-side binding, this is
 *                   normally the name of the language.
 *                   To find the implementation of a class
 *                   in order to make one, you should pass
 *                   the string "ior/impl" here.
 * @param lScope     this specifies whether the symbols should
 *                   be loaded into the global scope, a local
 *                   scope, or use the setting in the SCL file.
 * @param lResolve   this specifies whether symbols should be
 *                   resolved as needed (LAZY), completely
 *                   resolved at load time (NOW), or use the
 *                   setting from the SCL file.
 * @return a non-NULL object means the search was successful.
 *         The DLL has already been added.
 */

static jobject
jni_findLibrary(
  JNIEnv* env,
  jclass  cls,
  jstring _arg_sidl_name,
  jstring _arg_target,
  jint _arg_lScope,
  jint _arg_lResolve)
{
  /*
   * Declare return and temporary variables.
   */

  char* _tmp_sidl_name = (char*) NULL;
  char* _tmp_target = (char*) NULL;
  enum sidl_Scope__enum _tmp_lScope = (enum sidl_Scope__enum) 0;
  enum sidl_Resolve__enum _tmp_lResolve = (enum sidl_Resolve__enum) 0;
  struct sidl_DLL__object* _ior_res = (struct sidl_DLL__object*) NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_sidl_name = sidl_Java_J2I_string(env, _arg_sidl_name);
  _tmp_target = sidl_Java_J2I_string(env, _arg_target);
  _tmp_lScope = (enum sidl_Scope__enum) _arg_lScope;
  _tmp_lResolve = (enum sidl_Resolve__enum) _arg_lResolve;

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_findLibrary))(
    _tmp_sidl_name,
    _tmp_target,
    _tmp_lScope,
    _tmp_lResolve);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_sidl_name);
  sidl_String_free(_tmp_target);
  _res = sidl_Java_I2J_cls(env, _ior_res, "sidl.DLL");

  return _res;
}

/*
 * Set the search path, which is a semi-colon separated sequence of
 * URIs as described in class <code>DLL</code>.  This method will
 * invalidate any existing search path.
 * 
 * This updates the search path in the current <code>Finder</code>.
 */

static void
jni_setSearchPath(
  JNIEnv* env,
  jclass  cls,
  jstring _arg_path_name)
{
  /*
   * Declare return and temporary variables.
   */

  char* _tmp_path_name = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_path_name = sidl_Java_J2I_string(env, _arg_path_name);

  /*
   * Call the IOR method through the EPV.
   */

  (*(s_sepv->f_setSearchPath))(
    _tmp_path_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_path_name);
}

/*
 * Return the current search path.  The default
 * <code>Finder</code> initializes the search path
 * from environment variable SIDL_DLL_PATH.
 * 
 */

static jstring
jni_getSearchPath(
  JNIEnv* env,
  jclass  cls)
{
  /*
   * Declare return and temporary variables.
   */

  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */


  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_getSearchPath))();

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);

  return _res;
}

/*
 * Append the specified path fragment to the beginning of the
 * current search path.  This method operates on the Loader's
 * current <code>Finder</code>. This will add a path to the
 * current search path. Normally, the search path is initialized
 * from the SIDL_DLL_PATH environment variable.
 */

static void
jni_addSearchPath(
  JNIEnv* env,
  jclass  cls,
  jstring _arg_path_fragment)
{
  /*
   * Declare return and temporary variables.
   */

  char* _tmp_path_fragment = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_path_fragment = sidl_Java_J2I_string(env, _arg_path_fragment);

  /*
   * Call the IOR method through the EPV.
   */

  (*(s_sepv->f_addSearchPath))(
    _tmp_path_fragment);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_path_fragment);
}

/*
 * This method sets the <code>Finder</code> that
 * <code>Loader</code> will use to find DLLs.  If no
 * <code>Finder</code> is set or if NULL is passed in, the Default
 * Finder <code>DFinder</code> will be used.
 * 
 * Future calls to <code>findLibrary</code>,
 * <code>addSearchPath</code>, <code>getSearchPath</code>, and
 * <code>setSearchPath</code> are deligated to the
 * <code>Finder</code> set here.
 */

static void
jni_setFinder(
  JNIEnv* env,
  jclass  cls,
  jobject _arg_f)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_Finder__object* _tmp_f = (struct sidl_Finder__object*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_f = (struct sidl_Finder__object*) sidl_Java_J2I_ifc(env, _arg_f,
    "sidl.Finder");

  /*
   * Call the IOR method through the EPV.
   */

  (*(s_sepv->f_setFinder))(
    _tmp_f);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * This method gets the <code>Finder</code> that <code>Loader</code>
 * uses to find DLLs.  
 */

static jobject
jni_getFinder(
  JNIEnv* env,
  jclass  cls)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_Finder__object* _ior_res = (struct sidl_Finder__object*) NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */


  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_getFinder))();

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.Finder");

  return _res;
}

/*
 * Register JNI methods with the Java JVM.
 */

void sidl_Loader__register(JNIEnv* env)
{
  JNINativeMethod methods[10];
  jclass cls;

  s_external = sidl_Loader__externals();
  s_sepv = (*(s_external->getStaticEPV))();

  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "loadLibrary";
  methods[1].signature = "(Ljava/lang/String;ZZ)Lsidl/DLL;";
  methods[1].fnPtr     = (void *)jni_loadLibrary;
  methods[2].name      = "addDLL";
  methods[2].signature = "(Lsidl/DLL;)V";
  methods[2].fnPtr     = (void *)jni_addDLL;
  methods[3].name      = "unloadLibraries";
  methods[3].signature = "()V";
  methods[3].fnPtr     = (void *)jni_unloadLibraries;
  methods[4].name      = "findLibrary";
  methods[4].signature = "(Ljava/lang/String;Ljava/lang/String;II)Lsidl/DLL;";
  methods[4].fnPtr     = (void *)jni_findLibrary;
  methods[5].name      = "setSearchPath";
  methods[5].signature = "(Ljava/lang/String;)V";
  methods[5].fnPtr     = (void *)jni_setSearchPath;
  methods[6].name      = "getSearchPath";
  methods[6].signature = "()Ljava/lang/String;";
  methods[6].fnPtr     = (void *)jni_getSearchPath;
  methods[7].name      = "addSearchPath";
  methods[7].signature = "(Ljava/lang/String;)V";
  methods[7].fnPtr     = (void *)jni_addSearchPath;
  methods[8].name      = "setFinder";
  methods[8].signature = "(Lsidl/Finder;)V";
  methods[8].fnPtr     = (void *)jni_setFinder;
  methods[9].name      = "getFinder";
  methods[9].signature = "()Lsidl/Finder;";
  methods[9].fnPtr     = (void *)jni_getFinder;


  cls = (*env)->FindClass(env, "sidl/Loader");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 10);
    (*env)->DeleteLocalRef(env, cls);
  }
}
