/*
 * File:          sort_MergeSort_Impl.c
 * Symbol:        sort.MergeSort-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for sort.MergeSort
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sort.MergeSort" (version 0.1)
 * 
 * Merge sort
 */

#include "sort_MergeSort_Impl.h"

#line 26 "../../../../babel/regression/sort/libC/sort_MergeSort_Impl.c"
/* DO-NOT-DELETE splicer.begin(sort.MergeSort._includes) */
#include "sort_Container.h"
#include "sort_Comparator.h"
#include "sort_Counter.h"
#include "sidl_String.h"

static void
mergeLists(sort_Container  elems,
           sort_Comparator comp,
           sort_Counter    cmp,
           sort_Counter    swp,
           int32_t         start,
           int32_t         mid,
           const int32_t   end)
{
  int32_t j;
  while ((start < mid) && (mid < end)) {
    sort_Counter_inc(cmp);
    if (sort_Container_compare(elems, start, mid, comp) > 0) {
      /* move first element of upper list into place */
      for(j = mid;j > start; --j) {
        sort_Counter_inc(swp);
        sort_Container_swap(elems, j, j - 1);
      }
      ++mid;
    }
    ++start;
  }
}

/**
 * end is one past the end
 */
static void
mergeSort(sort_Container  elems,
          sort_Comparator comp,
          sort_Counter    cmp,
          sort_Counter    swp,
          const int32_t   start,
          const int32_t   end)
{
  if ((end - start) > 1) {
    int32_t mid = (start + end) >> 1;
    mergeSort(elems, comp, cmp, swp, start, mid);
    mergeSort(elems, comp, cmp, swp, mid, end);
    mergeLists(elems, comp, cmp, swp, start, mid, end);
  }
}
/* DO-NOT-DELETE splicer.end(sort.MergeSort._includes) */
#line 76 "sort_MergeSort_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_MergeSort__load"

void
impl_sort_MergeSort__load(
  void)
{
#line 87 "../../../../babel/regression/sort/libC/sort_MergeSort_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sort.MergeSort._load) */
  /* Insert the implementation of the static class initializer method here... */
  /* DO-NOT-DELETE splicer.end(sort.MergeSort._load) */
#line 93 "sort_MergeSort_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_MergeSort__ctor"

void
impl_sort_MergeSort__ctor(
  /* in */ sort_MergeSort self)
{
#line 102 "../../../../babel/regression/sort/libC/sort_MergeSort_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sort.MergeSort._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.MergeSort._ctor) */
#line 110 "sort_MergeSort_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_MergeSort__dtor"

void
impl_sort_MergeSort__dtor(
  /* in */ sort_MergeSort self)
{
#line 118 "../../../../babel/regression/sort/libC/sort_MergeSort_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sort.MergeSort._dtor) */
  /* Insert the implementation of the destructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.MergeSort._dtor) */
#line 128 "sort_MergeSort_Impl.c"
}

/*
 * Sort elements using Merge Sort.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_MergeSort_sort"

void
impl_sort_MergeSort_sort(
  /* in */ sort_MergeSort self,
  /* in */ sort_Container elems,
  /* in */ sort_Comparator comp)
{
#line 136 "../../../../babel/regression/sort/libC/sort_MergeSort_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sort.MergeSort.sort) */
  const int32_t num = sort_Container_getLength(elems);
  sort_Counter cmp = sort_MergeSort_getCompareCounter(self);
  sort_Counter swp = sort_MergeSort_getSwapCounter(self);
  mergeSort(elems, comp, cmp, swp, 0, num);
  sort_Counter_deleteRef(cmp);
  sort_Counter_deleteRef(swp);
  /* DO-NOT-DELETE splicer.end(sort.MergeSort.sort) */
#line 153 "sort_MergeSort_Impl.c"
}

/*
 * Return merge sort.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_MergeSort_getName"

char*
impl_sort_MergeSort_getName(
  /* in */ sort_MergeSort self)
{
#line 157 "../../../../babel/regression/sort/libC/sort_MergeSort_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sort.MergeSort.getName) */
  return sidl_String_strdup("Merge sort");
  /* DO-NOT-DELETE splicer.end(sort.MergeSort.getName) */
#line 171 "sort_MergeSort_Impl.c"
}
