!
! File:       sorttest.f90
! Copyright:  (c) 2002 The Regents of the University of California
! Revision:   @(#) $Revision: 4434 $
! Date:       $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
! Description:Exercise the FORTRAN interface for sorting
!
!
#include "sort_SortingAlgorithm_fAbbrev.h"
#include "sort_MergeSort_fAbbrev.h"
#include "sort_QuickSort_fAbbrev.h"
#include "sort_HeapSort_fAbbrev.h"
#include "sort_SortTest_fAbbrev.h"
#include "synch_RegOut_fAbbrev.h"
#include "synch_ResultType_fAbbrev.h"

subroutine starttest(number)
  use synch_RegOut
  implicit none
  integer (selected_int_kind(9)) :: number
  type(synch_RegOut_t) :: tracker
  call getInstance(tracker)
  call startPart(tracker, number)
  call deleteRef(tracker)
end subroutine starttest

subroutine reporttest(test, number)
  use synch_RegOut
  use synch_ResultType
  implicit none
  integer (selected_int_kind(9)) :: number
  logical                        :: test
  type(synch_RegOut_t) :: tracker
  call getInstance(tracker)
  if (test) then
     call endPart(tracker, number, PASS)
  else
     call endPart(tracker, number, FAIL)
  endif
  number = number + 1
  call deleteRef(tracker)
end subroutine reporttest

subroutine testsort(test)
  use sort_SortingAlgorithm
  use sort_QuickSort
  use sort_HeapSort
  use sort_MergeSort
  use sort_SortTest
  use sort_SortingAlgorithm_array
  implicit none
  type(sort_SortingAlgorithm_1d) :: algs
  type(sort_SortingAlgorithm_t) :: alg
  type(sort_MergeSort_t) :: merge
  type(sort_HeapSort_t) :: heap
  type(sort_QuickSort_t) :: quick
  integer (selected_int_kind(9))  :: test
  logical                         :: retval

  call create1d(3, algs)
  call starttest(test)
  call new(merge)
  call reporttest(not_null(merge), test)
  call starttest(test)
  call new(quick)
  call reporttest(not_null(quick), test)
  call starttest(test)
  call new(heap)
  call reporttest(not_null(heap), test)

  call cast(merge, alg)
  call set(algs, 0, alg)
  call cast(heap, alg)
  call set(algs, 1, alg)
  call cast(quick, alg)
  call set(algs, 2, alg)
  ! remove extraneous references
  call deleteRef(merge)
  call deleteRef(quick)
  call deleteRef(heap)

  call starttest(test)
  call stressTest(algs, retval)
  call reporttest(retval, test)
  call deleteRef(algs)
end subroutine testsort

program sorttest
  use synch_RegOut
  implicit none
  integer (selected_int_kind(9)) :: test
  type(synch_RegOut_t) :: tracker
  test = 1
  call getInstance(tracker)
  call setExpectations(tracker, 4)
  call writeComment(tracker, 'Sort tests')
  call testsort(test)
  call close(tracker)
  call deleteRef(tracker)
end program sorttest
