/*
 * File:          sidl_rmi_ProtocolFactory_Impl.c
 * Symbol:        sidl.rmi.ProtocolFactory-v0.9.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Server-side implementation for sidl.rmi.ProtocolFactory
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sidl.rmi.ProtocolFactory" (version 0.9.1)
 * 
 * This singleton class keeps a table of string prefixes (e.g. "babel" or "proteus")
 * to protocol implementations.  The intent is to parse a URL (e.g. "babel://server:port/class")
 * and create classes that implement <code>sidl.rmi.InstanceHandle</code>.
 */

#include "sidl_rmi_ProtocolFactory_Impl.h"

#line 54 "../../../babel/runtime/sidl/sidl_rmi_ProtocolFactory_Impl.c"
/* DO-NOT-DELETE splicer.begin(sidl.rmi.ProtocolFactory._includes) */
#include <string.h>
#include <stdio.h>
#include "sidl_String.h"
#include "sidl_DLL.h"
#include "sidl_Loader.h"
#include "sidl_BaseClass.h"
#include "sidl_rmi_InstanceHandle.h"
#include "sidl_Exception.h"
#include "sidl_rmi_NetworkException.h"
static char ** reg; /* reg[2*i] is associated w/ reg[2*i+1] */
static int len; /* really 2*len entries */
static int maxlen; /* 1/2 size of buffer malloc'd */
/* DO-NOT-DELETE splicer.end(sidl.rmi.ProtocolFactory._includes) */
#line 68 "sidl_rmi_ProtocolFactory_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_sidl_rmi_ProtocolFactory__load"

void
impl_sidl_rmi_ProtocolFactory__load(
  void)
{
#line 82 "../../../babel/runtime/sidl/sidl_rmi_ProtocolFactory_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidl.rmi.ProtocolFactory._load) */
  maxlen=1024;
  reg = (char**) malloc ( sizeof(char*)*maxlen*2 );
  len = 0;
  /* DO-NOT-DELETE splicer.end(sidl.rmi.ProtocolFactory._load) */
#line 87 "sidl_rmi_ProtocolFactory_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidl_rmi_ProtocolFactory__ctor"

void
impl_sidl_rmi_ProtocolFactory__ctor(
  /* in */ sidl_rmi_ProtocolFactory self)
{
#line 101 "../../../babel/runtime/sidl/sidl_rmi_ProtocolFactory_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidl.rmi.ProtocolFactory._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(sidl.rmi.ProtocolFactory._ctor) */
#line 104 "sidl_rmi_ProtocolFactory_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidl_rmi_ProtocolFactory__dtor"

void
impl_sidl_rmi_ProtocolFactory__dtor(
  /* in */ sidl_rmi_ProtocolFactory self)
{
#line 119 "../../../babel/runtime/sidl/sidl_rmi_ProtocolFactory_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidl.rmi.ProtocolFactory._dtor) */
  /* Insert the implementation of the destructor method here... */
  /* DO-NOT-DELETE splicer.end(sidl.rmi.ProtocolFactory._dtor) */
#line 122 "sidl_rmi_ProtocolFactory_Impl.c"
}

/*
 * Associate a particular prefix in the URL to a typeName <code>sidl.Loader</code> can find.
 * The actual type is expected to implement <code>sidl.rmi.InstanceHandle</code>
 * Return true iff the addition is successful.  (no collisions allowed)
 */

#undef __FUNC__
#define __FUNC__ "impl_sidl_rmi_ProtocolFactory_addProtocol"

sidl_bool
impl_sidl_rmi_ProtocolFactory_addProtocol(
  /* in */ const char* prefix,
  /* in */ const char* typeName,
  /* out */ sidl_BaseInterface *_ex)
{
#line 141 "../../../babel/runtime/sidl/sidl_rmi_ProtocolFactory_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidl.rmi.ProtocolFactory.addProtocol) */
  int i;
  /* push new protocol to back of list */
  if ( len >= maxlen ) { 
    ;/*TODO implement realloc */
  } 
  /* return false is prefix already exists */
  for (i=0;i<2*len;i+=2) { 
    if ( !strcmp( reg[i], prefix )) { 
      return FALSE;
    }
  }
  /* now add prefix into list */
  reg[2*len] = (char*)sidl_String_strdup(prefix);
  reg[2*len+1] = (char*) sidl_String_strdup(typeName);
  len++;
  return TRUE;
  /* DO-NOT-DELETE splicer.end(sidl.rmi.ProtocolFactory.addProtocol) */
#line 159 "sidl_rmi_ProtocolFactory_Impl.c"
}

/*
 * Return the typeName associated with a particular prefix.
 * Return empty string if the prefix
 */

#undef __FUNC__
#define __FUNC__ "impl_sidl_rmi_ProtocolFactory_getProtocol"

char*
impl_sidl_rmi_ProtocolFactory_getProtocol(
  /* in */ const char* prefix,
  /* out */ sidl_BaseInterface *_ex)
{
#line 176 "../../../babel/runtime/sidl/sidl_rmi_ProtocolFactory_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidl.rmi.ProtocolFactory.getProtocol) */
  int i;
  for (i=0;i<2*len;i+=2) { 
    if ( !strcmp( reg[i], prefix )) { 
      return (char*) sidl_String_strdup( reg[i+1] );
    }
  }
  return NULL;
  /* DO-NOT-DELETE splicer.end(sidl.rmi.ProtocolFactory.getProtocol) */
#line 185 "sidl_rmi_ProtocolFactory_Impl.c"
}

/*
 * Remove a protocol from the active list.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidl_rmi_ProtocolFactory_deleteProtocol"

sidl_bool
impl_sidl_rmi_ProtocolFactory_deleteProtocol(
  /* in */ const char* prefix,
  /* out */ sidl_BaseInterface *_ex)
{
#line 201 "../../../babel/runtime/sidl/sidl_rmi_ProtocolFactory_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidl.rmi.ProtocolFactory.deleteProtocol) */
  int i;
  for (i=0;i<2*len;i+=2) { 
    if ( !strcmp( reg[i], prefix )) { 
      --len;
      if (i<2*len) { 
	/* swap i entry to back of list */
	char *tmp;
	tmp=reg[i];
	reg[i]=reg[2*len];
	reg[2*len]= tmp;
	tmp=reg[i+1];
	reg[i+1] = reg[2*len+1];
	reg[2*len+1] = tmp;
      }
      sidl_String_free(reg[2*len]);
      reg[2*len]=NULL;
      sidl_String_free(reg[2*len+1]);
      reg[2*len+1]=NULL;
      return TRUE;
    }
  }
  return FALSE;
  /* DO-NOT-DELETE splicer.end(sidl.rmi.ProtocolFactory.deleteProtocol) */
#line 225 "sidl_rmi_ProtocolFactory_Impl.c"
}

/*
 * Create a new remote object and a return an instance handle for that object. 
 * The server and port number are in the url.  Return nil 
 * if protocol unknown or InstanceHandle.init() failed.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidl_rmi_ProtocolFactory_createInstance"

sidl_rmi_InstanceHandle
impl_sidl_rmi_ProtocolFactory_createInstance(
  /* in */ const char* url,
  /* in */ const char* typeName,
  /* out */ sidl_BaseInterface *_ex)
{
#line 244 "../../../babel/runtime/sidl/sidl_rmi_ProtocolFactory_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidl.rmi.ProtocolFactory.createInstance) */
  char * prefix = NULL;
  char * protocol = NULL;
  char * server_name = NULL;
  int port = 0;
  int i=0, start=0;
  int end = strlen(url);
  char* myurl = sidl_String_strdup( url );
  char tmp;
  sidl_BaseClass bc;
  sidl_rmi_InstanceHandle ih;

  /* extract the protocol name */
  while ((i<end) && (myurl[i]!=':')) { 
    i++;
  }
  if ( (i==start) || (i==end) ) { 
    printf("ERROR: invalid URL format\n");
    exit(2);
  }
  
  myurl[i]=0;
  prefix=sidl_String_strdup(myurl);
  myurl[i]=':';

  /* skip colons & slashes (should be "://") */
  if ( ((i+3)>=end) || (myurl[i]!=':') || (myurl[i+1]!='/') || (myurl[i+2]!='/')) { 
    SIDL_THROW(*_ex, sidl_rmi_NetworkException, "ERROR: malformed URL\n");
  } else { 
    i+=3;
  }
  /* extract server name */
  start=i;
  while ( (i<end) && myurl[i]!=':'&& myurl[i]!='/') { 
    i++;
  }

  if (i==start) { 
    SIDL_THROW(*_ex, sidl_rmi_NetworkException, "ERROR: invalid URL format\n");
  }
  tmp=myurl[i];
  myurl[i]=0;
  server_name = sidl_String_strdup(myurl + start);
  myurl[i]=tmp;

  /* extract port number (if it exists ) */
  if ( (i<end) && (myurl[i]==':')) {
    ++i;
    start=i;
    while ((i<end) && (myurl[i] != '/')) { 
      if ( (myurl[i]<'0') || myurl[i]>'9') { 
	SIDL_THROW(*_ex, sidl_rmi_NetworkException, "ERROR: invalid URL format\n");
      }
      i++;
    }
    tmp = myurl[i];
    myurl[i]=0;
    port = atoi( myurl+start );
    myurl[i]=tmp;
  }

  /* now find the protocol associated with the prefix */
  
  protocol = sidl_rmi_ProtocolFactory_getProtocol( prefix, _ex );
  if ( protocol == NULL ) { return NULL; }
  sidl_DLL dll = sidl_Loader_findLibrary( protocol, "ior/impl", 
					  sidl_Scope_SCLSCOPE, 
					  sidl_Resolve_SCLRESOLVE );
  if ( dll == NULL ) { return NULL; }
  bc = sidl_DLL_createClass( dll, protocol );
  if ( bc == NULL ) { return NULL; }    
  ih = sidl_rmi_InstanceHandle__cast( bc );
  if ( ih == NULL ) { return NULL; }
  sidl_rmi_InstanceHandle_initCreate( ih, protocol, server_name, port, typeName, _ex );
  return ih;
 EXIT:
  return NULL;
  /* DO-NOT-DELETE splicer.end(sidl.rmi.ProtocolFactory.createInstance) */
#line 322 "sidl_rmi_ProtocolFactory_Impl.c"
}

/*
 * Create an new connection linked to an already existing object on a remote 
 * server.  The server and port number are in the url, the objectID is the unique ID
 * of the remote object in the remote instance registry. 
 * Return nil if protocol unknown or InstanceHandle.init() failed.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidl_rmi_ProtocolFactory_connectInstance"

sidl_rmi_InstanceHandle
impl_sidl_rmi_ProtocolFactory_connectInstance(
  /* in */ const char* url,
  /* in */ const char* typeName,
  /* in */ const char* objectID,
  /* out */ sidl_BaseInterface *_ex)
{
#line 342 "../../../babel/runtime/sidl/sidl_rmi_ProtocolFactory_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidl.rmi.ProtocolFactory.connectInstance) */
  char * prefix = NULL;
  char * protocol = NULL;
  char * server_name = NULL;
  int port = 0;
  int i=0, start=0;
  int end = strlen(url);
  char* myurl = sidl_String_strdup( url );
  char tmp;
  sidl_BaseClass bc;
  sidl_rmi_InstanceHandle ih;
  
  /* extract the protocol name */
  while ((i<end) && (myurl[i]!=':')) { 
    i++;
  }
  if ( (i==start) || (i==end) ) { 
    printf("ERROR: invalid URL format\n");
    exit(2);
  }
  
  myurl[i]=0;
  prefix=sidl_String_strdup(myurl);
  myurl[i]=':';

  /* skip colons & slashes (should be "://") */
  if ( ((i+3)>=end) || (myurl[i]!=':') || (myurl[i+1]!='/') || (myurl[i+2]!='/')) { 
    SIDL_THROW(*_ex, sidl_rmi_NetworkException, "ERROR: malformed URL\n");
  } else { 
    i+=3;
  }
  /* extract server name */
  start=i;
  while ( (i<end) && myurl[i]!=':'&& myurl[i]!='/') { 
    i++;
  }

  if (i==start) { 
    SIDL_THROW(*_ex, sidl_rmi_NetworkException, "ERROR: invalid URL format\n");
  }
  tmp=myurl[i];
  myurl[i]=0;
  server_name = sidl_String_strdup(myurl + start);
  myurl[i]=tmp;

  /* extract port number (if it exists ) */
  if ( (i<end) && (myurl[i]==':')) {
    ++i;
    start=i;
    while ((i<end) && (myurl[i] != '/')) { 
      if ( (myurl[i]<'0') || myurl[i]>'9') { 
	SIDL_THROW(*_ex, sidl_rmi_NetworkException, "ERROR: invalid URL format\n");
      }
      i++;
    }
    tmp = myurl[i];
    myurl[i]=0;
    port = atoi( myurl+start );
    myurl[i]=tmp;
  }

  /* now find the protocol associated with the prefix */
  
  protocol = sidl_rmi_ProtocolFactory_getProtocol( prefix, _ex );
  if ( protocol == NULL ) { return NULL; }
  sidl_DLL dll = sidl_Loader_findLibrary( protocol, "ior/impl", 
					  sidl_Scope_SCLSCOPE, 
					  sidl_Resolve_SCLRESOLVE );
  if ( dll == NULL ) { return NULL; }
  bc = sidl_DLL_createClass( dll, protocol );
  if ( bc == NULL ) { return NULL; }    
  ih = sidl_rmi_InstanceHandle__cast( bc );
  if ( ih == NULL ) { return NULL; }
  sidl_rmi_InstanceHandle_initConnect( ih, protocol, server_name, port, typeName, objectID, _ex );
  return ih;
 EXIT:
  return NULL;
  /* DO-NOT-DELETE splicer.end(sidl.rmi.ProtocolFactory.connectInstance) */
#line 421 "sidl_rmi_ProtocolFactory_Impl.c"
}
