/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.AsyncProxy;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncProxyBase<T>
implements AsyncProxy<T> {
    private List<ParamCommand<T>> commands = new ArrayList<ParamCommand<T>>();
    private boolean hasAsyncBeenIssued = false;
    private boolean hasAsyncFailed = false;
    private boolean hasAsyncReturned = false;
    private T instance = null;

    public void enableLoadForTest0() {
        this.hasAsyncBeenIssued = false;
        this.hasAsyncFailed = false;
        this.hasAsyncReturned = false;
    }

    @Override
    public final T getProxiedInstance() {
        return this.instance;
    }

    @Override
    public abstract void setProxyCallback(AsyncProxy.ProxyCallback<T> var1);

    public void suppressLoadForTest0() {
        this.hasAsyncBeenIssued = true;
        this.hasAsyncFailed = false;
        this.hasAsyncReturned = false;
    }

    protected abstract void doAsync0();

    protected final void doFailure0(Throwable t) {
        this.hasAsyncFailed = true;
        this.getCallback0().onFailure(t);
    }

    protected final void enqueue0(ParamCommand<T> cmd) {
        try {
            if (this.hasAsyncFailed) {
                throw new IllegalStateException("runAsync load previously failed");
            }
            if (!this.hasAsyncBeenIssued) {
                this.hasAsyncBeenIssued = true;
                this.commands.add(cmd);
                this.doAsync0();
            } else if (this.hasAsyncReturned) {
                assert (this.instance != null);
                cmd.execute(this.instance);
            } else {
                assert (this.instance == null);
                this.commands.add(cmd);
            }
        }
        catch (Throwable t) {
            if (this.getCallback0() != null) {
                this.getCallback0().onFailure(t);
            }
            GWT.getUncaughtExceptionHandler().onUncaughtException(t);
        }
    }

    protected abstract AsyncProxy.ProxyCallback<T> getCallback0();

    protected final void setInstance0(T instance) {
        assert (this.commands != null) : "No commands";
        assert (this.hasAsyncBeenIssued) : "async request not yet started";
        this.hasAsyncReturned = true;
        this.instance = instance;
        List<ParamCommand<T>> localCommands = this.commands;
        this.commands = null;
        if (this.getCallback0() != null) {
            this.getCallback0().onInit(instance);
        }
        for (ParamCommand<T> cmd : localCommands) {
            cmd.execute(instance);
        }
        if (this.getCallback0() != null) {
            this.getCallback0().onComplete(instance);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ParamCommand<T> {
        public void execute(T var1);
    }
}

