/*
 * Decompiled with CFR 0.152.
 */
package bsh.classpath;

import bsh.ClassPathException;
import bsh.ConsoleInterface;
import bsh.NameCompletion;
import bsh.StringUtil;
import bsh.classpath.ClassPathListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class BshClassPath
implements ClassPathListener {
    String name;
    private List path;
    private List compPaths;
    private Map packageMap;
    private Map classSource;
    private boolean mapsInitialized;
    private UnqualifiedNameTable unqNameTable;
    private NameCompletion.Table nameCompletionTable;
    private boolean nameCompletionIncludesUnqNames;
    Vector listeners = new Vector();
    static URL[] userClassPathComp;
    static BshClassPath userClassPath;
    static BshClassPath bootClassPath;

    public BshClassPath(String string) {
        this.name = string;
        this.reset();
    }

    public BshClassPath(String string, URL[] uRLArray) {
        this(string);
        this.add(uRLArray, null);
    }

    public void setPath(URL[] uRLArray) {
        this.reset();
        this.add(uRLArray, null);
    }

    public void addComponent(BshClassPath bshClassPath) {
        if (this.compPaths == null) {
            this.compPaths = new ArrayList();
        }
        this.compPaths.add(bshClassPath);
        bshClassPath.addListener(this);
    }

    public void add(URL[] uRLArray, ConsoleInterface consoleInterface) {
        this.path.addAll(Arrays.asList(uRLArray));
        if (this.mapsInitialized) {
            this.map(uRLArray, consoleInterface);
        }
    }

    public void add(URL uRL, ConsoleInterface consoleInterface) throws IOException {
        this.path.add(uRL);
        if (this.mapsInitialized) {
            this.map(uRL, consoleInterface);
        }
    }

    public URL[] getPathComponents() {
        return this.getFullPath().toArray(new URL[0]);
    }

    public synchronized Set getClassesForPackage(String string) {
        this.insureInitialized(null);
        HashSet hashSet = new HashSet();
        Collection collection = (Collection)this.packageMap.get(string);
        if (collection != null) {
            hashSet.addAll(collection);
        }
        if (this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size()) {
                collection = ((BshClassPath)this.compPaths.get(n)).getClassesForPackage(string);
                if (collection != null) {
                    hashSet.addAll(collection);
                }
                ++n;
            }
        }
        return hashSet;
    }

    public synchronized ClassSource getClassSource(String string) {
        this.insureInitialized(null);
        ClassSource classSource = (ClassSource)this.classSource.get(string);
        if (classSource == null && this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size() && classSource == null) {
                classSource = ((BshClassPath)this.compPaths.get(n)).getClassSource(string);
                ++n;
            }
        }
        return classSource;
    }

    public synchronized void insureInitialized(ConsoleInterface consoleInterface) {
        if (this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size()) {
                ((BshClassPath)this.compPaths.get(n)).insureInitialized(consoleInterface);
                ++n;
            }
        }
        if (!this.mapsInitialized) {
            if (consoleInterface == null) {
                System.out.println("Mapping : " + this);
            }
            this.map(this.path.toArray(new URL[0]), consoleInterface);
        }
        this.mapsInitialized = true;
    }

    protected List getFullPath() {
        ArrayList arrayList = new ArrayList();
        if (this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size()) {
                List list = ((BshClassPath)this.compPaths.get(n)).getFullPath();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (arrayList.contains(e)) continue;
                    arrayList.add(e);
                }
                ++n;
            }
        }
        arrayList.addAll(this.path);
        return arrayList;
    }

    public String getClassNameByUnqName(String string) throws ClassPathException {
        UnqualifiedNameTable unqualifiedNameTable = this.getUnqualifiedNameTable();
        Object v = unqualifiedNameTable.get(string);
        if (v instanceof AmbiguousName) {
            throw new ClassPathException("Ambigous class names: " + ((AmbiguousName)v).get());
        }
        return (String)v;
    }

    UnqualifiedNameTable getUnqualifiedNameTable() {
        if (this.unqNameTable == null) {
            this.unqNameTable = this.buildUnqualifiedNameTable();
        }
        return this.unqNameTable;
    }

    private UnqualifiedNameTable buildUnqualifiedNameTable() {
        Object object;
        this.insureInitialized(null);
        UnqualifiedNameTable unqualifiedNameTable = new UnqualifiedNameTable();
        if (this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size()) {
                object = ((BshClassPath)this.compPaths.get((int)n)).classSource.keySet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    unqualifiedNameTable.add((String)iterator.next());
                }
                ++n;
            }
        }
        object = this.classSource.keySet().iterator();
        while (object.hasNext()) {
            unqualifiedNameTable.add((String)object.next());
        }
        return unqualifiedNameTable;
    }

    public String[] completeClassName(String string) {
        return this.getNameCompletionTable().completeName(string);
    }

    public NameCompletion.Table getNameCompletionTable() {
        if (this.nameCompletionTable == null) {
            this.nameCompletionTable = this.buildNameCompletionTable();
        }
        return this.nameCompletionTable;
    }

    private NameCompletion.Table buildNameCompletionTable() {
        this.insureInitialized(null);
        NameCompletion.Table table = new NameCompletion.Table();
        Iterator iterator = this.getPackagesSet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            table.addAll(BshClassPath.removeInnerClassNames(this.getClassesForPackage(string)));
        }
        if (this.nameCompletionIncludesUnqNames) {
            table.addAll(this.getUnqualifiedNameTable().keySet());
        }
        return table;
    }

    synchronized void map(URL[] uRLArray, ConsoleInterface consoleInterface) {
        int n = 0;
        while (n < uRLArray.length) {
            try {
                this.map(uRLArray[n], consoleInterface);
            }
            catch (IOException iOException) {
                String string = "Error constructing classpath: " + uRLArray[n] + ": " + iOException;
                if (consoleInterface != null) {
                    consoleInterface.println(string);
                }
                System.err.println(string);
            }
            ++n;
        }
    }

    synchronized void map(URL uRL, ConsoleInterface consoleInterface) throws IOException {
        String string = uRL.getFile();
        File file = new File(string);
        if (file.isDirectory()) {
            if (consoleInterface != null) {
                consoleInterface.println("Mapping directory: " + file);
            }
            this.map(BshClassPath.traverseDirForClasses(file), new DirClassSource(file));
        } else if (BshClassPath.isArchiveFileName(string)) {
            if (consoleInterface != null) {
                consoleInterface.println("Mapping archive: " + uRL);
            }
            this.map(BshClassPath.searchJarForClasses(uRL), new JarClassSource(uRL));
        } else {
            String string2 = "Not a classpath component: " + string;
            if (consoleInterface != null) {
                consoleInterface.println(string2);
            } else {
                System.err.println(string2);
            }
        }
    }

    private void map(String[] stringArray, Object object) {
        int n = 0;
        while (n < stringArray.length) {
            this.mapClass(stringArray[n], object);
            ++n;
        }
    }

    private void mapClass(String string, Object object) {
        String[] stringArray = BshClassPath.splitClassname(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        HashSet<String> hashSet = (HashSet<String>)this.packageMap.get(string2);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            this.packageMap.put(string2, hashSet);
        }
        hashSet.add(string);
        Object v = this.classSource.get(string);
        if (v == null) {
            this.classSource.put(string, object);
        }
    }

    private synchronized void reset() {
        this.path = new ArrayList();
        this.compPaths = null;
        this.clearCachedStructures();
    }

    private synchronized void clearCachedStructures() {
        this.mapsInitialized = false;
        this.packageMap = new HashMap();
        this.classSource = new HashMap();
        this.unqNameTable = null;
        this.nameCompletionTable = null;
    }

    public void classPathChanged() {
        this.clearCachedStructures();
        this.notifyListeners();
    }

    public void setNameCompletionIncludeUnqNames(boolean bl) {
        if (this.nameCompletionIncludesUnqNames != bl && this.nameCompletionTable != null) {
            this.nameCompletionTable = null;
        }
        this.nameCompletionIncludesUnqNames = bl;
    }

    static String[] traverseDirForClasses(File file) throws IOException {
        List list = BshClassPath.traverseDirForClassesAux(file, file);
        return list.toArray(new String[0]);
    }

    static List traverseDirForClassesAux(File file, File file2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = file.getAbsolutePath();
        File[] fileArray = file2.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file3 = fileArray[n];
            if (file3.isDirectory()) {
                arrayList.addAll(BshClassPath.traverseDirForClassesAux(file, file3));
            } else {
                String string2 = file3.getAbsolutePath();
                if (BshClassPath.isClassFileName(string2)) {
                    if (!string2.startsWith(string)) {
                        throw new IOException("problem parsing paths");
                    }
                    string2 = string2.substring(string.length() + 1);
                    string2 = BshClassPath.canonicalizeClassName(string2);
                    arrayList.add(string2);
                }
            }
            ++n;
        }
        return arrayList;
    }

    static String[] searchJarForClasses(URL uRL) throws IOException {
        Object[] objectArray;
        ZipEntry zipEntry;
        Vector<String> vector = new Vector<String>();
        InputStream inputStream = uRL.openStream();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            objectArray = zipEntry.getName();
            if (!BshClassPath.isClassFileName((String)objectArray)) continue;
            vector.addElement(BshClassPath.canonicalizeClassName((String)objectArray));
        }
        zipInputStream.close();
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean isClassFileName(String string) {
        return string.toLowerCase().endsWith(".class");
    }

    public static boolean isArchiveFileName(String string) {
        return (string = string.toLowerCase()).endsWith(".jar") || string.endsWith(".zip");
    }

    public static String canonicalizeClassName(String string) {
        String string2 = string.replace('/', '.');
        if ((string2 = string2.replace('\\', '.')).startsWith("class ")) {
            string2 = string2.substring(6);
        }
        if (string2.endsWith(".class")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        return string2;
    }

    public static String[] splitClassname(String string) {
        String string2;
        String string3;
        int n = (string = BshClassPath.canonicalizeClassName(string)).lastIndexOf(".");
        if (n == -1) {
            string3 = string;
            string2 = "<unpackaged>";
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        return new String[]{string2, string3};
    }

    public static Collection removeInnerClassNames(Collection collection) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(collection);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.indexOf("$") == -1) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public static URL[] getUserClassPathComponents() throws ClassPathException {
        if (userClassPathComp != null) {
            return userClassPathComp;
        }
        String string = System.getProperty("java.class.path");
        String[] stringArray = StringUtil.split(string, File.pathSeparator);
        URL[] uRLArray = new URL[stringArray.length];
        try {
            int n = 0;
            while (n < stringArray.length) {
                uRLArray[n] = new File(stringArray[n]).toURL();
                ++n;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClassPathException("can't parse class path: " + malformedURLException);
        }
        userClassPathComp = uRLArray;
        return uRLArray;
    }

    public Set getPackagesSet() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.packageMap.keySet());
        if (this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size()) {
                hashSet.addAll(((BshClassPath)this.compPaths.get((int)n)).packageMap.keySet());
                ++n;
            }
        }
        return hashSet;
    }

    public void addListener(ClassPathListener classPathListener) {
        this.listeners.addElement(new WeakReference<ClassPathListener>(classPathListener));
    }

    public void removeListener(ClassPathListener classPathListener) {
        this.listeners.removeElement(classPathListener);
    }

    void notifyListeners() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            WeakReference weakReference = (WeakReference)enumeration.nextElement();
            ClassPathListener classPathListener = (ClassPathListener)weakReference.get();
            if (classPathListener == null) {
                this.listeners.removeElement(weakReference);
                continue;
            }
            classPathListener.classPathChanged();
        }
    }

    public static BshClassPath getUserClassPath() throws ClassPathException {
        if (userClassPath == null) {
            userClassPath = new BshClassPath("User Class Path", BshClassPath.getUserClassPathComponents());
        }
        return userClassPath;
    }

    public static BshClassPath getBootClassPath() throws ClassPathException {
        if (bootClassPath == null) {
            try {
                String string = System.getProperty("java.home") + "/lib/rt.jar";
                URL uRL = new File(string).toURL();
                bootClassPath = new BshClassPath("Boot Class Path", new URL[]{uRL});
            }
            catch (MalformedURLException malformedURLException) {
                throw new ClassPathException(" can't find boot jar: " + malformedURLException);
            }
        }
        return bootClassPath;
    }

    public static void main(String[] stringArray) throws Exception {
        URL[] uRLArray = new URL[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            uRLArray[n] = new File(stringArray[n]).toURL();
            ++n;
        }
        BshClassPath bshClassPath = new BshClassPath("Test", uRLArray);
    }

    public String toString() {
        return "BshClassPath " + this.name + "(" + super.toString() + ") path= " + this.path + "\n" + "compPaths = {" + this.compPaths + " }";
    }

    public static class AmbiguousName {
        List list = new ArrayList();

        public void add(String string) {
            this.list.add(string);
        }

        public List get() {
            return this.list;
        }
    }

    static class UnqualifiedNameTable
    extends HashMap {
        UnqualifiedNameTable() {
        }

        void add(String string) {
            String string2 = BshClassPath.splitClassname(string)[1];
            Object v = super.get(string2);
            if (v == null) {
                super.put(string2, string);
            } else if (v instanceof AmbiguousName) {
                ((AmbiguousName)v).add(string);
            } else {
                AmbiguousName ambiguousName = new AmbiguousName();
                ambiguousName.add((String)v);
                ambiguousName.add(string);
                super.put(string2, ambiguousName);
            }
        }
    }

    public static class DirClassSource
    extends ClassSource {
        DirClassSource(File file) {
            this.source = file;
        }

        public File getDir() {
            return (File)this.source;
        }

        public String toString() {
            return "Dir: " + this.source;
        }
    }

    public static class JarClassSource
    extends ClassSource {
        JarClassSource(URL uRL) {
            this.source = uRL;
        }

        public URL getURL() {
            return (URL)this.source;
        }

        public String toString() {
            return "Jar: " + this.source;
        }
    }

    public static class ClassSource {
        Object source;
    }
}

