/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.cs.util.CodeBuffer;
import com.ibm.cs.util.IOUtils;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Main {
    private static String DEFAULT_IN_FILE_NAME = "<STDIN>";
    private static String DEFAULT_COMPILE_FLAG = "off";
    private static String DEFAULT_CLASS_NAME = "Test";
    static /* synthetic */ Class class$com$ibm$bsf$BSFManager;

    private static void printHelp() {
        System.err.println("Usage:");
        System.err.println();
        System.err.println("  java " + (class$com$ibm$bsf$BSFManager != null ? class$com$ibm$bsf$BSFManager : (class$com$ibm$bsf$BSFManager = Main.class$("com.ibm.bsf.BSFManager"))).getName() + " [args]");
        System.err.println();
        System.err.println("    args:");
        System.err.println();
        System.err.println("      [-in            fileName]   default: " + DEFAULT_IN_FILE_NAME);
        System.err.println("      [-language  languageName]   default: <If -in is specified and -language ");
        System.err.println("                                            is not, attempt to determine ");
        System.err.println("                                            language from file extension; ");
        System.err.println("                                            otherwise, -language is required.>");
        System.err.println("      [-compile       (on|off)]   default: " + DEFAULT_COMPILE_FLAG);
        System.err.println();
        System.err.println("    Additional args used only if -compile flag is set to \"on\":");
        System.err.println();
        System.err.println("      [-out          className]   default: " + DEFAULT_CLASS_NAME);
    }

    public static void main(String[] stringArray) throws BSFException, IOException {
        InputStreamReader inputStreamReader;
        if (stringArray.length == 0 || stringArray.length % 2 != 0) {
            Main.printHelp();
            System.exit(1);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("-compile", DEFAULT_COMPILE_FLAG);
        hashtable.put("-out", DEFAULT_CLASS_NAME);
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], stringArray[n + 1]);
            n += 2;
        }
        String string = (String)hashtable.get("-in");
        String string2 = (String)hashtable.get("-language");
        if (string2 == null) {
            if (string != null) {
                string2 = BSFManager.getLangFromFilename(string);
            } else {
                throw new BSFException(BSFException.REASON_OTHER_ERROR, "unable to determine language");
            }
        }
        if (string != null) {
            inputStreamReader = new FileReader(string);
        } else {
            inputStreamReader = new InputStreamReader(System.in);
            string = "<STDIN>";
        }
        BSFManager bSFManager = new BSFManager();
        String string3 = (String)hashtable.get("-compile");
        if (string3 != null && string3.equals("on")) {
            String string4 = (String)hashtable.get("-out");
            FileWriter fileWriter = new FileWriter(String.valueOf(string4) + ".java");
            PrintWriter printWriter = new PrintWriter(fileWriter);
            CodeBuffer codeBuffer = new CodeBuffer();
            codeBuffer.setClassName(string4);
            bSFManager.compileScript(string2, string, 0, 0, IOUtils.getStringFromReader(inputStreamReader), codeBuffer);
            codeBuffer.print(printWriter, true);
            fileWriter.close();
            return;
        }
        bSFManager.exec(string2, string, 0, 0, IOUtils.getStringFromReader(inputStreamReader));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

