/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.util;

import com.ibm.cs.util.IOUtils;
import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    private static boolean debug;
    public static String lineSeparator;
    public static String lineSeparatorStr;

    public static String getSafeString(String string) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string2 != null) {
                    stringBuffer.append("\"" + string2 + lineSeparatorStr + "\" +" + lineSeparator);
                }
                string2 = StringUtils.cleanString(string3);
            }
        }
        catch (IOException iOException) {}
        stringBuffer.append("\"" + (string2 != null ? string2 : "") + "\"" + lineSeparator);
        return stringBuffer.toString();
    }

    public static String cleanString(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getClassName(Class clazz) {
        String string = clazz.getName();
        if (clazz.isArray()) {
            return StringUtils.parseDescriptor(string);
        }
        return string;
    }

    private static String parseDescriptor(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (cArray[n2] == '[') {
            ++n;
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (cArray[n2++]) {
            case 'B': {
                stringBuffer.append("byte");
                break;
            }
            case 'C': {
                stringBuffer.append("char");
                break;
            }
            case 'D': {
                stringBuffer.append("double");
                break;
            }
            case 'F': {
                stringBuffer.append("float");
                break;
            }
            case 'I': {
                stringBuffer.append("int");
                break;
            }
            case 'J': {
                stringBuffer.append("long");
                break;
            }
            case 'S': {
                stringBuffer.append("short");
                break;
            }
            case 'Z': {
                stringBuffer.append("boolean");
                break;
            }
            case 'L': {
                stringBuffer.append(cArray, n2, cArray.length - n2 - 1);
                break;
            }
        }
        n2 = 0;
        while (n2 < n) {
            stringBuffer.append("[]");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getCommaListFromVector(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append(String.valueOf(n > 0 ? ", " : "") + vector.elementAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getChars(int n, char c) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static boolean isValidIdentifierName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            return false;
        }
        int n = 1;
        while (n < cArray.length) {
            if (!Character.isJavaIdentifierPart(cArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isValidPackageName(String var0) {
        if (var0 == null) {
            return false;
        }
        if (var0.length() == 0) {
            return true;
        }
        var1_1 = new StringTokenizer(var0, ".", true);
        if (var1_1.countTokens() % 2 != 1) {
            return false;
        }
        if (StringUtils.isValidIdentifierName(var1_1.nextToken())) ** GOTO lbl16
        return false;
lbl-1000:
        // 1 sources

        {
            if (!var1_1.nextToken().equals(".")) {
                return false;
            }
            if (var1_1.hasMoreTokens()) {
                if (StringUtils.isValidIdentifierName(var1_1.nextToken())) continue;
                return false;
            }
            return false;
lbl16:
            // 2 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl17:
        // 1 sources

        return true;
    }

    public static String classNameToVarName(String string) {
        int n = 0;
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            ++n;
        }
        int n2 = string.lastIndexOf(46);
        String string2 = Introspector.decapitalize(n2 != -1 ? string.substring(n2 + 1) : string);
        if (n > 0) {
            string2 = String.valueOf(string2) + "_" + n + "D";
        }
        return StringUtils.getValidIdentifierName(string2);
    }

    public static String getValidIdentifierName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        stringBuffer.append(Character.isJavaIdentifierStart(cArray[0]) ? cArray[0] : (char)'_');
        int n = 1;
        while (n < cArray.length) {
            stringBuffer.append(Character.isJavaIdentifierPart(cArray[n]) ? cArray[n] : (char)'_');
            ++n;
        }
        return stringBuffer.toString();
    }

    private static URL getURL(URL uRL, String string, int n) throws MalformedURLException {
        Vector<String> vector = null;
        if (debug) {
            vector = new Vector<String>();
            System.err.println();
            System.err.println("getURL(depth: " + n + "):");
            System.err.println("contextURL=" + uRL);
            System.err.println("spec=" + string);
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
            try {
                uRL2.openStream();
            }
            catch (IOException iOException) {
                if (debug) {
                    vector.addElement("1st failed to open.");
                }
                throw new MalformedURLException("This file was not found: " + uRL2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (debug) {
                vector.addElement("1st failed.");
            }
            uRL2 = new URL("file", "", string);
            try {
                uRL2.openStream();
            }
            catch (IOException iOException) {
                String string2;
                String string3;
                if (debug) {
                    vector.addElement("2nd failed to open.");
                }
                if (uRL != null && (string3 = new File(string2 = uRL.getFile()).getParent()) != null && n < 3) {
                    if (debug) {
                        System.err.println("failures: " + vector);
                    }
                    return StringUtils.getURL(new URL("file", "", String.valueOf(string3) + '/'), string, n + 1);
                }
                throw new MalformedURLException("This file was not found: " + uRL2);
            }
        }
        if (debug) {
            System.err.println("failures: " + vector);
            System.err.println("finalURL=" + uRL2);
        }
        return uRL2;
    }

    public static URL getURL(URL uRL, String string) throws MalformedURLException {
        if (debug) {
            System.err.println();
            System.err.println("Loading " + string + "...");
        }
        return StringUtils.getURL(uRL, string, 1);
    }

    public static Reader getContentAsReader(URL uRL) throws SecurityException, IllegalArgumentException, IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        try {
            Object object = uRL.getContent();
            if (object == null) {
                throw new IllegalArgumentException("No content.");
            }
            if (object instanceof InputStream) {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
                if (((Reader)inputStreamReader).ready()) {
                    return inputStreamReader;
                }
                throw new FileNotFoundException();
            }
            throw new IllegalArgumentException(object instanceof String ? (String)object : "This URL points to a: " + StringUtils.getClassName(object.getClass()));
        }
        catch (SecurityException securityException) {
            throw new SecurityException("Your JVM's SecurityManager has disallowed this.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("This file was not found: " + uRL);
        }
    }

    public static String getContentAsString(URL uRL) throws SecurityException, IllegalArgumentException, IOException {
        return IOUtils.getStringFromReader(StringUtils.getContentAsReader(uRL));
    }

    static {
        lineSeparator = System.getProperty("line.separator");
        lineSeparatorStr = StringUtils.cleanString(lineSeparator);
    }
}

