/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.ldap;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.ldap.LdapContext;
import org.apache.cocoon.processor.ldap.LdapContextCreator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LdapDefs {
    protected Hashtable creators = new Hashtable();
    protected Hashtable query_props = new Hashtable();
    protected Properties default_query_props = master_default_query_props;
    protected static Properties master_default_query_props = new Properties();

    static {
        ((Hashtable)master_default_query_props).put("doc-element", "ldapsearch");
        ((Hashtable)master_default_query_props).put("row-element", "searchresult");
        ((Hashtable)master_default_query_props).put("id-attribute", "ID");
        ((Hashtable)master_default_query_props).put("id-attribute-column", "");
        ((Hashtable)master_default_query_props).put("variable-left-delimiter", "{@");
        ((Hashtable)master_default_query_props).put("variable-right-delimiter", "}");
        ((Hashtable)master_default_query_props).put("session-variable-left-delimiter", "{@session.");
        ((Hashtable)master_default_query_props).put("session-variable-right-delimiter", "}");
        ((Hashtable)master_default_query_props).put("error-element", "ldaperror");
        ((Hashtable)master_default_query_props).put("error-message-attribute", "message");
        ((Hashtable)master_default_query_props).put("error-message-element", "");
        ((Hashtable)master_default_query_props).put("error-stacktrace-attribute", "");
        ((Hashtable)master_default_query_props).put("error-stacktrace-element", "");
    }

    public LdapDefs(Document document) throws Exception {
        NodeList ldapdefs = document.getElementsByTagName("ldap-defs");
        Node[] ldap_defs_ary = new Node[ldapdefs.getLength()];
        int i = 0;
        while (i < ldapdefs.getLength()) {
            ldap_defs_ary[i] = ldapdefs.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < ldap_defs_ary.length) {
            Node ldap_def_node = ldap_defs_ary[i2];
            NodeList ldaps = ldap_def_node.getChildNodes();
            int j = 0;
            while (j < ldaps.getLength()) {
                Node node = ldaps.item(j);
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    String name = element.getNodeName();
                    if (name.equals("ldap-server")) {
                        this.processLdapDef(element);
                    } else if (name.equals("ldap-querydefs")) {
                        this.processQueryDef(element);
                    }
                }
                ++j;
            }
            ldap_def_node.getParentNode().removeChild(ldap_def_node);
            ++i2;
        }
    }

    public LdapContext getLdapContext(String name) throws Exception {
        LdapContextCreator creator = (LdapContextCreator)this.creators.get(name);
        return creator.getLdapContext();
    }

    public Properties getQueryProperties(String name) throws Exception {
        if (name == null || name.equals("")) {
            return this.default_query_props;
        }
        Properties props = (Properties)this.query_props.get(name);
        return props;
    }

    protected void processLdapDef(Element ldap) throws Exception {
        String name = ldap.getAttribute("name");
        if (name == null || name.equals("")) {
            return;
        }
        Properties ldap_props = new Properties();
        NodeList ldap_children = ldap.getChildNodes();
        int k = 0;
        while (k < ldap_children.getLength()) {
            Node ldap_parameter = ldap_children.item(k);
            String prop_name = ldap_parameter.getNodeName();
            NodeList ldap_parameter_values = ldap_parameter.getChildNodes();
            StringBuffer value = new StringBuffer();
            int l = 0;
            while (l < ldap_parameter_values.getLength()) {
                Node value_node = ldap_parameter_values.item(l);
                if (value_node.getNodeType() == 3) {
                    value.append(value_node.getNodeValue());
                }
                ++l;
            }
            ((Hashtable)ldap_props).put(prop_name, value.toString());
            ++k;
        }
        if (!((Hashtable)ldap_props).containsKey("ldap-serverurl")) {
            return;
        }
        this.creators.put(name, new LdapContextCreator(ldap_props));
    }

    protected void processQueryDef(Element querydef) {
        String name = querydef.getAttribute("name");
        if (name == null || name.equals("")) {
            return;
        }
        NamedNodeMap attributes = querydef.getAttributes();
        Properties props = new Properties(master_default_query_props);
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            ((Hashtable)props).put(attribute.getNodeName(), attribute.getNodeValue());
            ++i;
        }
        this.query_props.put(name, props);
        String def = querydef.getAttribute("default");
        if (def != null && (def.equals("y") || def.equals("yes"))) {
            this.default_query_props = props;
        }
    }
}

