/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.library;

import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.apache.cocoon.framework.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class XSPSessionLibrary {
    public static Element getAttribute(HttpSession session, String name, Document document) {
        Object value = session.getAttribute(name);
        if (value == null) {
            return null;
        }
        Element element = document.createElement("session:attribute");
        element.setAttribute("name", name);
        if (value instanceof XObject) {
            DocumentFragment fragment = document.createDocumentFragment();
            ((XObject)value).toDOM(fragment);
            element.appendChild(fragment);
        } else {
            element.appendChild(document.createTextNode(value.toString()));
        }
        return element;
    }

    public static String[] getAttributeNames(HttpSession session) {
        Vector<Object> v = new Vector<Object>();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            v.addElement(session.getAttribute((String)e.nextElement()));
        }
        Object[] attributeNames = new String[v.size()];
        v.copyInto(attributeNames);
        return attributeNames;
    }

    public static Element getAttributeNames(HttpSession session, Document document) {
        String[] attributeNames = XSPSessionLibrary.getAttributeNames(session);
        Element element = document.createElement("session:attribute-names");
        int i = 0;
        while (i < attributeNames.length) {
            Element nameElement = document.createElement("session:attribute-name");
            nameElement.appendChild(document.createTextNode(attributeNames[i]));
            element.appendChild(nameElement);
            ++i;
        }
        return element;
    }

    public static Element getCreationTime(HttpSession session, Document document) {
        Element element = document.createElement("session:creation-time");
        element.appendChild(document.createTextNode(String.valueOf(session.getCreationTime())));
        return element;
    }

    public static Element getId(HttpSession session, Document document) {
        Element element = document.createElement("session:id");
        element.appendChild(document.createTextNode(session.getId()));
        return element;
    }

    public static Element getLastAccessedTime(HttpSession session, Document document) {
        Element element = document.createElement("session:last-accessed-time");
        element.appendChild(document.createTextNode(String.valueOf(session.getLastAccessedTime())));
        return element;
    }

    public static Element getMaxInactiveInterval(HttpSession session, Document document) {
        Element element = document.createElement("session:max-inactive-interval");
        element.appendChild(document.createTextNode(String.valueOf(session.getMaxInactiveInterval())));
        return element;
    }

    public static Element getValue(HttpSession session, String name, Document document) {
        Object value = session.getValue(name);
        Element element = document.createElement("session:value");
        element.setAttribute("name", name);
        if (value == null) {
            return element;
        }
        if (value instanceof XObject) {
            DocumentFragment fragment = document.createDocumentFragment();
            ((XObject)value).toDOM(fragment);
            element.appendChild(fragment);
        } else {
            element.appendChild(document.createTextNode(value.toString()));
        }
        return element;
    }

    public static Element getValueNames(HttpSession session, Document document) {
        String[] attributeNames = session.getValueNames();
        Element element = document.createElement("session:value-names");
        int i = 0;
        while (i < attributeNames.length) {
            Element nameElement = document.createElement("session:value-name");
            nameElement.appendChild(document.createTextNode(attributeNames[i]));
            element.appendChild(nameElement);
            ++i;
        }
        return element;
    }

    public static Element isNew(HttpSession session, Document document) {
        Element element = document.createElement("session:is-new");
        element.appendChild(document.createTextNode(String.valueOf(session.isNew())));
        return element;
    }
}

