/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Version;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.PreviewDialog;
import org.apache.fop.viewer.SecureResourceBundle;
import org.apache.fop.viewer.Translator;
import org.apache.fop.viewer.UserMessage;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;

public class AWTCommandLine {
    public static String TRANSLATION_PATH = "/org/apache/fop/viewer/resources/";
    private Translator resource;

    public AWTCommandLine(String string, String string2) {
        if (string2 == null) {
            string2 = System.getProperty("user.language");
        }
        this.resource = this.getResourceBundle(String.valueOf(TRANSLATION_PATH) + "resources." + string2);
        UserMessage.setTranslator(this.getResourceBundle(String.valueOf(TRANSLATION_PATH) + "messages." + string2));
        this.resource.setMissingEmphasized(false);
        AWTRenderer aWTRenderer = new AWTRenderer(this.resource);
        PreviewDialog previewDialog = this.createPreviewDialog(aWTRenderer, this.resource);
        aWTRenderer.setProgressListener(previewDialog);
        previewDialog.progress(String.valueOf(this.resource.getString("Init parser")) + " ...");
        Parser parser = AWTCommandLine.createParser();
        if (parser == null) {
            System.err.println("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            Driver driver = new Driver();
            driver.setRenderer(aWTRenderer);
            previewDialog.progress(String.valueOf(this.resource.getString("Init mappings")) + " ...");
            driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
            driver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            previewDialog.progress(String.valueOf(this.resource.getString("Build FO tree")) + " ...");
            driver.buildFOTree(parser, AWTCommandLine.fileInputSource(string));
            previewDialog.progress(String.valueOf(this.resource.getString("Layout FO tree")) + " ...");
            driver.format();
            previewDialog.progress(String.valueOf(this.resource.getString("Render")) + " ...");
            driver.render();
            previewDialog.progress(this.resource.getString("Show"));
        }
        catch (Exception exception) {
            System.err.println("FATAL ERROR: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static Parser createParser() {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "com.jclark.xml.sax.Driver";
        }
        System.err.println("using SAX parser " + string);
        try {
            return (Parser)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            System.err.println(String.valueOf(string) + " is not a SAX driver");
        }
        return null;
    }

    protected PreviewDialog createPreviewDialog(AWTRenderer aWTRenderer, Translator translator) {
        PreviewDialog previewDialog = new PreviewDialog(aWTRenderer, translator);
        previewDialog.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = previewDialog.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        ((Component)previewDialog).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)previewDialog).setVisible(true);
        return previewDialog;
    }

    protected static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = String.valueOf('/') + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    private SecureResourceBundle getResourceBundle(String string) {
        InputStream inputStream = null;
        try {
            URL uRL = this.getClass().getResource(string);
            inputStream = uRL.openStream();
        }
        catch (Exception exception) {
            System.out.println("Can't find URL to: <" + string + "> " + exception.getMessage());
        }
        return new SecureResourceBundle(inputStream);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = null;
        String string2 = null;
        Object var3_4 = null;
        System.err.println(Version.getVersion());
        if (stringArray.length < 1 || stringArray.length > 3) {
            System.err.println("usage: java AWTCommandLine formatting-object-file [language] ");
            System.exit(1);
        }
        string = stringArray[0];
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        new AWTCommandLine(string, string2);
    }
}

