/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.net.URL;
import java.util.Hashtable;
import org.apache.fop.image.FopImage;

public class GifJpegImage
implements FopImage {
    int X;
    int Y;
    int width;
    int height;
    int pixelwidth;
    int pixelheight;
    String ref;
    boolean color = true;
    int bitperpixel = 8;
    int[] imagemap;
    int[] tempmap;
    protected Integer imageWait = new Integer(0);

    public GifJpegImage(String string, int n, int n2, int n3, int n4) {
        this.ref = string;
        this.X = n;
        this.Y = n2;
        this.pixelheight = -1;
        this.pixelwidth = -1;
        try {
            URL uRL = new URL(string);
            ImageProducer imageProducer = (ImageProducer)uRL.getContent();
            FopImageConsumer fopImageConsumer = new FopImageConsumer(this);
            imageProducer.startProduction(fopImageConsumer);
            Object object = this.imageWait;
            synchronized (object) {
                this.imageWait.wait();
            }
            while ((this.pixelheight = fopImageConsumer.getHeight()) == -1) {
            }
            while ((this.pixelwidth = fopImageConsumer.getWidth()) == -1) {
            }
            this.tempmap = new int[this.pixelwidth * this.pixelheight];
            object = new PixelGrabber(imageProducer, 0, 0, this.pixelwidth, this.pixelheight, this.tempmap, 0, this.pixelwidth);
            try {
                ((PixelGrabber)object).grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Image grabbing interrupted");
            }
        }
        catch (ClassCastException classCastException) {
            System.err.println("Image format not supported: " + string);
        }
        catch (Exception exception) {
            System.err.println("Error loading image " + string + " : " + exception);
        }
        this.width = n3 == 0 ? this.pixelwidth * 1000 : n3;
        this.height = n4 == 0 ? this.pixelheight * 1000 : n4;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.X;
    }

    public int getY() {
        return this.Y;
    }

    public int getbitperpixel() {
        return this.bitperpixel;
    }

    public boolean getcolor() {
        return true;
    }

    public String gethref() {
        return this.ref;
    }

    public int[] getimagemap() {
        this.imagemap = new int[this.pixelheight * this.pixelwidth * 3];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n3 = (this.pixelheight - 1) * this.pixelwidth;
        while (n3 >= 0) {
            n2 = 0;
            while (n2 < this.pixelwidth) {
                int n4 = this.tempmap[n3 + n2];
                this.imagemap[n++] = n4 >> 16 & 0xFF;
                this.imagemap[n++] = n4 >> 8 & 0xFF;
                this.imagemap[n++] = n4 & 0xFF;
                ++n2;
            }
            n3 -= this.pixelwidth;
        }
        return this.imagemap;
    }

    public int getpixelheight() {
        return this.pixelheight;
    }

    public int getpixelwidth() {
        return this.pixelwidth;
    }

    public static class FopImageConsumer
    implements ImageConsumer {
        int width = -1;
        int height = -1;
        GifJpegImage graphic;

        public FopImageConsumer(GifJpegImage gifJpegImage) {
            this.graphic = gifJpegImage;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public void imageComplete(int n) {
            Integer n2 = this.graphic.imageWait;
            synchronized (n2) {
                this.graphic.imageWait.notifyAll();
            }
        }

        public void setColorModel(ColorModel colorModel) {
        }

        public void setDimensions(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public void setHints(int n) {
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        }

        public void setProperties(Hashtable hashtable) {
        }
    }
}

