/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.parsers;

import java.io.IOException;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Parser;
import org.apache.stylebook.parsers.AbstractParser;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XercesParser
extends AbstractParser
implements Parser,
ErrorHandler {
    public Document create() {
        this.debug("Creating new Document");
        return new DocumentImpl();
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(String.valueOf(sAXParseException.getMessage()) + " [File: \"" + sAXParseException.getSystemId() + "\" Line: " + sAXParseException.getLineNumber() + " Column: " + sAXParseException.getColumnNumber() + "]", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(String.valueOf(sAXParseException.getMessage()) + " [File: \"" + sAXParseException.getSystemId() + "\" Line: " + sAXParseException.getLineNumber() + " Column: " + sAXParseException.getColumnNumber() + "]", sAXParseException);
    }

    public Document parse(InputSource inputSource) throws IOException, CreationException {
        this.debug("Parsing \"" + inputSource.getSystemId() + "\"");
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
            dOMParser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            dOMParser.setErrorHandler((ErrorHandler)this);
            dOMParser.parse(inputSource);
            Document document = dOMParser.getDocument();
            if (document == null) {
                throw new CreationException("Cannot retrieve parsed document");
            }
            return document;
        }
        catch (SAXException sAXException) {
            this.log(sAXException.getMessage());
            throw new CreationException("SAXException caught while parsing", sAXException);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(String.valueOf(sAXParseException.getMessage()) + " [File: \"" + sAXParseException.getSystemId() + "\" Line: " + sAXParseException.getLineNumber() + " Column: " + sAXParseException.getColumnNumber() + "]", sAXParseException);
    }
}

