/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;

public class Project {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    private static final String VISITING = "VISITING";
    private static final String VISITED = "VISITED";
    private static String javaVersion;
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String TOKEN_START = "@";
    public static final String TOKEN_END = "@";
    private String name;
    private Hashtable properties = new Hashtable();
    private Hashtable userProperties = new Hashtable();
    private Hashtable references = new Hashtable();
    private String defaultTarget;
    private Hashtable taskClassDefinitions = new Hashtable();
    private Hashtable targets = new Hashtable();
    private Hashtable filters = new Hashtable();
    private File baseDir;
    private Vector listeners = new Vector();

    public void addBuildListener(BuildListener listener) {
        this.listeners.addElement(listener);
    }

    public void addFilter(String token, String value) {
        if (token == null) {
            return;
        }
        this.log("Setting token to filter: " + token + " -> " + value, 3);
        this.filters.put(token, value);
    }

    public void addOrReplaceTarget(String targetName, Target target) {
        String msg = " +Target: " + targetName;
        this.log(msg, 3);
        target.setProject(this);
        this.targets.put(targetName, target);
    }

    public void addOrReplaceTarget(Target target) {
        this.addOrReplaceTarget(target.getName(), target);
    }

    public void addReference(String name, Object value) {
        this.references.put(name, value);
    }

    public void addTarget(String targetName, Target target) throws BuildException {
        if (this.targets.get(targetName) != null) {
            throw new BuildException("Duplicate target: `" + targetName + "'");
        }
        this.addOrReplaceTarget(targetName, target);
    }

    public void addTarget(Target target) {
        String name = target.getName();
        if (this.targets.get(name) != null) {
            throw new BuildException("Duplicate target: `" + name + "'");
        }
        this.addOrReplaceTarget(name, target);
    }

    public void addTaskDefinition(String taskName, Class taskClass) {
        String msg = " +User task: " + taskName + "     " + taskClass.getName();
        this.log(msg, 3);
        this.taskClassDefinitions.put(taskName, taskClass);
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        this.copyFile(sourceFile, destFile, false);
    }

    public void copyFile(File sourceFile, File destFile, boolean filtering) throws IOException {
        this.copyFile(sourceFile, destFile, filtering, false);
    }

    public void copyFile(File sourceFile, File destFile, boolean filtering, boolean overwrite) throws IOException {
        if (overwrite || destFile.lastModified() < sourceFile.lastModified()) {
            this.log("Copy: " + sourceFile.getAbsolutePath() + " > " + destFile.getAbsolutePath(), 3);
            File parent = new File(destFile.getParent());
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (filtering) {
                BufferedReader in = new BufferedReader(new FileReader(sourceFile));
                BufferedWriter out = new BufferedWriter(new FileWriter(destFile));
                String newline = null;
                String line = in.readLine();
                while (line != null) {
                    if (line.length() == 0) {
                        out.newLine();
                    } else {
                        newline = this.replace(line, this.filters);
                        out.write(newline);
                        out.newLine();
                    }
                    line = in.readLine();
                }
                out.close();
                in.close();
            } else {
                FileInputStream in = new FileInputStream(sourceFile);
                FileOutputStream out = new FileOutputStream(destFile);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in.close();
                out.close();
            }
        }
    }

    public void copyFile(String sourceFile, String destFile) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), false);
    }

    public void copyFile(String sourceFile, String destFile, boolean filtering) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filtering);
    }

    public void copyFile(String sourceFile, String destFile, boolean filtering, boolean overwrite) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filtering, overwrite);
    }

    public Task createTask(String taskType) throws BuildException {
        Class c = (Class)this.taskClassDefinitions.get(taskType);
        if (c == null) {
            throw new BuildException("Could not create task of type: " + taskType + " because I can't find it in the list of task" + " class definitions");
        }
        try {
            Object o = c.newInstance();
            Task task = null;
            if (o instanceof Task) {
                task = (Task)o;
            } else {
                TaskAdapter taskA = new TaskAdapter();
                taskA.setProxy(o);
                task = taskA;
            }
            task.setProject(this);
            task.setTaskType(taskType);
            task.setTaskName(taskType);
            String msg = "   +Task: " + taskType;
            this.log(msg, 3);
            return task;
        }
        catch (Exception e) {
            String msg = "Could not create task of type: " + taskType + " due to " + e;
            throw new BuildException(msg);
        }
    }

    private void detectJavaVersion() {
        try {
            javaVersion = JAVA_1_0;
            Class.forName("java.lang.Void");
            javaVersion = JAVA_1_1;
            Class.forName("java.lang.ThreadLocal");
            javaVersion = JAVA_1_2;
            Class.forName("java.lang.StrictMath");
            javaVersion = JAVA_1_3;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        this.setProperty("ant.java.version", javaVersion);
        if (javaVersion == JAVA_1_0) {
            throw new BuildException("Ant cannot work on Java 1.0");
        }
        this.log("Detected Java Version: " + javaVersion, 3);
        this.log("Detected OS: " + System.getProperty("os.name"), 3);
    }

    public void executeTarget(String targetName) throws BuildException {
        Target curtarget;
        if (targetName == null) {
            String msg = "No target specified";
            throw new BuildException(msg);
        }
        Vector sortedTargets = this.topoSort(targetName, this.targets);
        int curidx = 0;
        do {
            curtarget = (Target)sortedTargets.elementAt(curidx++);
            this.runTarget(curtarget);
        } while (!curtarget.getName().equals(targetName));
    }

    public void executeTargets(Vector targetNames) throws BuildException {
        Object error = null;
        int i = 0;
        while (i < targetNames.size()) {
            this.executeTarget((String)targetNames.elementAt(i));
            ++i;
        }
    }

    protected void fireBuildFinished(Throwable exception) {
        BuildEvent event = new BuildEvent(this);
        event.setException(exception);
        int i = 0;
        while (i < this.listeners.size()) {
            BuildListener listener = (BuildListener)this.listeners.elementAt(i);
            listener.buildFinished(event);
            ++i;
        }
    }

    protected void fireBuildStarted() {
        BuildEvent event = new BuildEvent(this);
        int i = 0;
        while (i < this.listeners.size()) {
            BuildListener listener = (BuildListener)this.listeners.elementAt(i);
            listener.buildStarted(event);
            ++i;
        }
    }

    protected void fireMessageLogged(Project project, String message, int priority) {
        BuildEvent event = new BuildEvent(project);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    protected void fireMessageLogged(Target target, String message, int priority) {
        BuildEvent event = new BuildEvent(target);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    protected void fireMessageLogged(Task task, String message, int priority) {
        BuildEvent event = new BuildEvent(task);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    private void fireMessageLoggedEvent(BuildEvent event, String message, int priority) {
        event.setMessage(message, priority);
        int i = 0;
        while (i < this.listeners.size()) {
            BuildListener listener = (BuildListener)this.listeners.elementAt(i);
            listener.messageLogged(event);
            ++i;
        }
    }

    protected void fireTargetFinished(Target target, Throwable exception) {
        BuildEvent event = new BuildEvent(target);
        event.setException(exception);
        int i = 0;
        while (i < this.listeners.size()) {
            BuildListener listener = (BuildListener)this.listeners.elementAt(i);
            listener.targetFinished(event);
            ++i;
        }
    }

    protected void fireTargetStarted(Target target) {
        BuildEvent event = new BuildEvent(target);
        int i = 0;
        while (i < this.listeners.size()) {
            BuildListener listener = (BuildListener)this.listeners.elementAt(i);
            listener.targetStarted(event);
            ++i;
        }
    }

    protected void fireTaskFinished(Task task, Throwable exception) {
        BuildEvent event = new BuildEvent(task);
        int i = 0;
        while (i < this.listeners.size()) {
            BuildListener listener = (BuildListener)this.listeners.elementAt(i);
            listener.taskFinished(event);
            ++i;
        }
    }

    protected void fireTaskStarted(Task task) {
        BuildEvent event = new BuildEvent(task);
        int i = 0;
        while (i < this.listeners.size()) {
            BuildListener listener = (BuildListener)this.listeners.elementAt(i);
            listener.taskStarted(event);
            ++i;
        }
    }

    public File getBaseDir() {
        block2: {
            if (this.baseDir != null) break block2;
            try {
                this.setBasedir(".");
            }
            catch (BuildException ex) {
                ex.printStackTrace();
            }
        }
        return this.baseDir;
    }

    public Vector getBuildListeners() {
        return this.listeners;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public Hashtable getFilters() {
        return this.filters;
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        if (name == null) {
            return null;
        }
        String property = (String)this.properties.get(name);
        return property;
    }

    public Hashtable getReferences() {
        return this.references;
    }

    public Hashtable getTargets() {
        return this.targets;
    }

    public Hashtable getTaskDefinitions() {
        return this.taskClassDefinitions;
    }

    public Hashtable getUserProperties() {
        return this.userProperties;
    }

    public String getUserProperty(String name) {
        if (name == null) {
            return null;
        }
        String property = (String)this.userProperties.get(name);
        return property;
    }

    public void init() throws BuildException {
        this.detectJavaVersion();
        String defs = "/org/apache/tools/ant/taskdefs/defaults.properties";
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getResourceAsStream(defs);
            props.load(in);
            in.close();
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = props.getProperty(key);
                try {
                    Class<?> taskClass = Class.forName(value);
                    this.addTaskDefinition(key, taskClass);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            Properties systemP = System.getProperties();
            Enumeration e = ((Hashtable)systemP).keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = (String)((Hashtable)systemP).get(name);
                this.setProperty(name, value);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Can't load default task list");
        }
    }

    public void log(String msg) {
        this.log(msg, 2);
    }

    public void log(String msg, int msgLevel) {
        this.fireMessageLogged(this, msg, msgLevel);
    }

    public void log(Target target, String msg, int msgLevel) {
        this.fireMessageLogged(target, msg, msgLevel);
    }

    public void log(Task task, String msg, int msgLevel) {
        this.fireMessageLogged(task, msg, msgLevel);
    }

    private static BuildException makeCircularException(String end, Stack stk) {
        String c;
        StringBuffer sb = new StringBuffer("Circular dependency: ");
        sb.append(end);
        do {
            c = (String)stk.pop();
            sb.append(" <- ");
            sb.append(c);
        } while (!c.equals(end));
        return new BuildException(new String(sb));
    }

    public void removeBuildListener(BuildListener listener) {
        this.listeners.removeElement(listener);
    }

    private String replace(String s, Hashtable tokens) {
        int index = s.indexOf("@");
        if (index > -1) {
            try {
                StringBuffer b = new StringBuffer();
                int i = 0;
                String token = null;
                String value = null;
                do {
                    token = s.substring(index + "@".length(), s.indexOf("@", index + "@".length() + 1));
                    b.append(s.substring(i, index));
                    if (tokens.containsKey(token)) {
                        value = (String)tokens.get(token);
                        this.log("Replacing: @" + token + "@" + " -> " + value, 3);
                        b.append(value);
                        continue;
                    }
                    b.append("@");
                    b.append(token);
                    b.append("@");
                } while ((index = s.indexOf("@", i = index + "@".length() + token.length() + "@".length())) > -1);
                b.append(s.substring(i));
                return b.toString();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return s;
            }
        }
        return s;
    }

    public File resolveFile(String fileName) {
        if (fileName.startsWith("/")) {
            return new File(fileName);
        }
        if (fileName.startsWith(System.getProperty("file.separator"))) {
            return new File(fileName);
        }
        if (fileName.length() >= 2 && Character.isLetter(fileName.charAt(0)) && fileName.charAt(1) == ':') {
            char[] ca = fileName.replace('/', '\\').toCharArray();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < ca.length) {
                if (ca[i] != '\\' || ca[i] == '\\' && i > 0 && ca[i - 1] != '\\') {
                    char c = i == 0 && Character.isLetter(ca[i]) && i < ca.length - 1 && ca[i + 1] == ':' ? Character.toUpperCase(ca[i]) : ca[i];
                    sb.append(c);
                }
                ++i;
            }
            return new File(sb.toString());
        }
        File file = new File(this.baseDir.getAbsolutePath());
        StringTokenizer tok = new StringTokenizer(fileName, "/", false);
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            if (part.equals("..")) {
                file = new File(file.getParent());
                continue;
            }
            if (part.equals(".")) continue;
            file = new File(file, part);
        }
        try {
            return new File(file.getCanonicalPath());
        }
        catch (IOException e) {
            this.log("IOException getting canonical path for " + file + ": " + e.getMessage(), 0);
            return new File(file.getAbsolutePath());
        }
    }

    public void runTarget(Target target) throws BuildException {
        try {
            this.fireTargetStarted(target);
            target.execute();
            this.fireTargetFinished(target, null);
        }
        catch (RuntimeException exc) {
            this.fireTargetFinished(target, exc);
            throw exc;
        }
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        this.setProperty("basedir", baseDir.getAbsolutePath());
        String msg = "Project base dir set to: " + baseDir;
        this.log(msg, 3);
    }

    public void setBasedir(String baseD) throws BuildException {
        try {
            this.setBaseDir(new File(new File(baseD).getCanonicalPath()));
        }
        catch (IOException ioe) {
            String msg = "Can't set basedir " + this.baseDir + " due to " + ioe.getMessage();
            throw new BuildException(msg);
        }
    }

    public void setDefault(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public void setDefaultTarget(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperty(String name, String value) {
        if (this.userProperties.get(name) != null) {
            return;
        }
        this.log("Setting project property: " + name + " -> " + value, 3);
        this.properties.put(name, value);
    }

    public void setUserProperty(String name, String value) {
        this.log("Setting ro project property: " + name + " -> " + value, 3);
        this.userProperties.put(name, value);
        this.properties.put(name, value);
    }

    public static boolean toBoolean(String s) {
        return s.equalsIgnoreCase("on") || s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes");
    }

    private final Vector topoSort(String root, Hashtable targets) throws BuildException {
        Vector ret = new Vector();
        Hashtable state = new Hashtable();
        Stack visiting = new Stack();
        this.tsort(root, targets, state, visiting, ret);
        this.log("Build sequence for target `" + root + "' is " + ret, 3);
        Enumeration en = targets.keys();
        while (en.hasMoreElements()) {
            String curTarget = (String)en.nextElement();
            String st = (String)state.get(curTarget);
            if (st == null) {
                this.tsort(curTarget, targets, state, visiting, ret);
                continue;
            }
            if (st != VISITING) continue;
            throw new RuntimeException("Unexpected node in visiting state: " + curTarget);
        }
        this.log("Complete build sequence is " + ret, 3);
        return ret;
    }

    public static String translatePath(String to_process) {
        if (to_process == null || to_process.length() == 0) {
            return "";
        }
        StringBuffer path = new StringBuffer(to_process.length() + 50);
        PathTokenizer tokenizer = new PathTokenizer(to_process);
        while (tokenizer.hasMoreTokens()) {
            String pathComponent = tokenizer.nextToken();
            pathComponent = pathComponent.replace('/', File.separatorChar);
            pathComponent = pathComponent.replace('\\', File.separatorChar);
            if (path.length() != 0) {
                path.append(File.pathSeparatorChar);
            }
            path.append(pathComponent);
        }
        return path.toString();
    }

    private final void tsort(String root, Hashtable targets, Hashtable state, Stack visiting, Vector ret) throws BuildException {
        state.put(root, VISITING);
        visiting.push(root);
        Target target = (Target)targets.get(root);
        if (target == null) {
            StringBuffer sb = new StringBuffer("Target `");
            sb.append(root);
            sb.append("' does not exist in this project. ");
            visiting.pop();
            if (!visiting.empty()) {
                String parent = (String)visiting.peek();
                sb.append("It is used from target `");
                sb.append(parent);
                sb.append("'.");
            }
            throw new BuildException(new String(sb));
        }
        Enumeration en = target.getDependencies();
        while (en.hasMoreElements()) {
            String cur = (String)en.nextElement();
            String m = (String)state.get(cur);
            if (m == null) {
                this.tsort(cur, targets, state, visiting, ret);
                continue;
            }
            if (m != VISITING) continue;
            throw Project.makeCircularException(cur, visiting);
        }
        String p = (String)visiting.pop();
        if (root != p) {
            throw new RuntimeException("Unexpected internal error: expected to pop " + root + " but got " + p);
        }
        state.put(root, VISITED);
        ret.addElement(target);
    }
}

