/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Exec;

public class Patch
extends Exec {
    private File originalFile;
    private File patchFile;
    private boolean backup = false;
    private boolean ignoreWhitespace = false;
    private int strip = -1;
    private boolean quiet = false;
    private boolean reverse = false;

    public void execute() throws BuildException {
        if (this.patchFile == null) {
            throw new BuildException("patchfile argument is required", this.location);
        }
        if (!this.patchFile.exists()) {
            throw new BuildException("patchfile " + this.patchFile + " doesn't exist", this.location);
        }
        StringBuffer command = new StringBuffer("patch -i " + this.patchFile + " ");
        if (this.backup) {
            command.append("-b ");
        }
        if (this.ignoreWhitespace) {
            command.append("-l ");
        }
        if (this.strip >= 0) {
            command.append("-p" + this.strip + " ");
        }
        if (this.quiet) {
            command.append("-s ");
        }
        if (this.reverse) {
            command.append("-R ");
        }
        if (this.originalFile != null) {
            command.append(this.originalFile);
        }
        this.run(command.toString());
    }

    public void setBackups(boolean backups) {
        this.backup = backups;
    }

    public final void setCommand(String command) throws BuildException {
        throw new BuildException("Cannot set attribute command in patch task", this.location);
    }

    public void setIgnorewhitespace(boolean ignore) {
        this.ignoreWhitespace = ignore;
    }

    public void setOriginalfile(File file) {
        this.originalFile = file;
    }

    public void setPatchfile(File file) {
        this.patchFile = file;
    }

    public void setQuiet(boolean q) {
        this.quiet = q;
    }

    public void setReverse(boolean r) {
        this.reverse = r;
    }

    public void setStrip(int num) throws BuildException {
        if (num < 0) {
            throw new BuildException("strip has to be >= 0", this.location);
        }
        this.strip = num;
    }
}

