/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICPAI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgChangePathINI(char *name)

	Change the path where to look for the system INI file.

	If name == NULL, the default is restored, which is "appPath()\..\ETC\".

	'name' is not duplicated into the heap!

	Return:
		0 on success

ob(ject): cfgChangePathINI
su(bsystem): inifile
ty(pe): 
sy(nopsis): 
sh(ort description): Change the path of the current application
he(ader files): 
lo(ng description): Changes the path of the currently active application
	as it used by the \subsys{inifile}. By default it is the path of the
	executable. The path of the application is also the default path to
	look for system INI files.
pr(erequistes):
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfgicpai.c
in(itialized by): 
wa(rning): The path is not duplicated into the heap and the previous one is 
	not deallocted.\par
	Note: Expect inconsitencies if the path of the application is changed
	after the \subsys{inifile} has been initialized already.
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICPAI.C 1.4 1999/12/13 02:22:19 ska Exp ska $";
#endif

int cfgChangePathINI(char * const name)
{	DBG_ENTER("cfgChangePathINI", Suppl_inifile)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )
	chkHeap
	cfgi_apppath = name;
	DBG_RETURN_I( 0)
}
