/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_SBAL.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfgSetBuildArgList(struct Cfg_Getopt *optstru)

ob(ject): cfgSetBuildArgList
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Configures the output stream to cache into memory
he(ader files): 
lo(ng description): Configures the output stack that all arguments are
	cached into memory.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_sbal.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_SBAL.C 1.5 1999/12/13 02:22:06 ska Exp ska $";
#endif

void cfgSetBuildArgList(struct Cfg_Getopt *optstru)
{	struct Cfg_oStackGetopt *p;

	DBG_ENTER("cfgSetBuildArgList", Suppl_cmdline)

	assert(optstru);

	C(_foundArg) = aF(cfg_addArgToList);
	p = cfg_ostkNew();
	assert(p);
	cfg_ostkInitMem(p);

	DBG_EXIT
}
