
import java.sql.*;


/**
 * test ResultSetMetaData.isReadonly, ResultSetMetaData.isNullable,
 *      ResultSetMetaData.isAutoIncrement
 *
 */
public class t0050
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException,
      java.lang.Exception
   {
      boolean passed = true;





      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop procedure p0050");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the procedure 'p0050', because it does")))
         {
            throw e;
         }
      }
      try
      {
         stmt.executeUpdate("drop table t0050b");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0050b', because it does")))
         {
            throw e;
         }
      }
      try
      {
         stmt.executeUpdate("drop table t0050a");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0050a', because it does")))
         {
            throw e;
         }
      }


      String query = 
         "create table t0050a(                    " +
         "  a integer identity(1,1) primary key,  " +
         "  b char    not null)";
         
      count = stmt.executeUpdate(query);
      System.out.println("Creating table affected " + count + " rows");


      query = 
         "create table t0050b(                    " +
         "  a integer not null,                   " +
         "  c char    not null,                   " +
         "  foreign key (a) references t0050a(a)) ";
      count = stmt.executeUpdate(query);
      System.out.println("Creating table affected " + count + " rows");

      query = 
         "create procedure p0050 (@a integer, @c char) as " +
         "   insert into t0050b (a, c) values (@a, @c)    ";
      count = stmt.executeUpdate(query);
      System.out.println("Creating procedure affected " + count + " rows");


      query = "exec p0050 ?, ?";
      java.sql.PreparedStatement pstmt = cx.prepareStatement(query);

      try
      {
         pstmt.setInt(1, 1);
         pstmt.setString(2, "a");
         count = pstmt.executeUpdate();
      }
      catch(SQLException e)
      {
         if (! (e.getMessage().startsWith("INSERT statement conflicted")))
         {
            throw e;
         }
      }

      query = "insert into t0050a (b) values ('a')";
      count = stmt.executeUpdate(query);
      System.out.println("insert affected " + count + " rows");

      pstmt.setInt(1, 1);
      pstmt.setString(2, "a");
      count = pstmt.executeUpdate();


      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0050.\n");
      System.exit(passed ? 0 : 1);
   }
}

