/*
 * BackupEnvironment.java
 *
 * Created on December 19, 2003, 9:55 PM
 */

package com.sun.enterprise.config.backup.pluggable.impl;

import com.sun.enterprise.config.backup.pluggable.BackupEnvironment;
import com.sun.enterprise.config.backup.pluggable.EnvironmentFactory;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.DefaultConstants;
import com.sun.enterprise.config.backup.BackupAbortException;
import com.sun.enterprise.config.backup.EnvironmentConstants;
import com.sun.enterprise.config.backup.utils.SystemPropsHelper;

/**
 * This class provides Default implementation of BackupEnvironment
 * It reads Environment variables for determining locations.
 *
 * This class expects EXECUTION_TYPE, DIRS_TO_BACKUP, 
 * DIR_TO_STORE_BACKUP_FILES to be set in environment
 *
 * @author  sridatta
 */
public class DefaultBackupEnvironment implements BackupEnvironment, 
                                                StatusConstants, 
                                                DefaultConstants,
                                                EnvironmentConstants {
    
   
    
    private String _snapshotFileNamePrefix;
    private String _backupFileNamePrefix;
    private String _backupHistoryFileName;
    private int _maxBackups;
    private int _maxSnapShots;
    private String _backupStorageType;
    
    private String[] _directoriesToBackup;
    private String _directoryToStoreBackupFiles;
    private String _directoryToStoreSnapshotFile;
    private String _directoryToStoreHistoryFile;
    private String _statusInfoFileName;
    
    /** Creates a new instance of BackupEnvironment */
    public DefaultBackupEnvironment() {
        initialize();
    }
    
    protected void initialize() {
        initializeDefaults();
        initializeFromEnvironment();
    }
    
    private void initializeDefaults() {        
        _snapshotFileNamePrefix = DEFAULT_SNAPSHOT_FILENAME_PREFIX;
        _backupFileNamePrefix = DEFAULT_BACKUP_FILENAME_PREFIX;
        _backupHistoryFileName = DEFAULT_BACKUP_HISTORY_FILENAME;
        _maxBackups = DEFAULT_MAX_BACKUPS;
        _maxSnapShots = DEFAULT_MAX_SNAPSHOTS;
        _statusInfoFileName = DEFAULT_STATUS_INFO_FILENAME;
    }
    
    private void initializeFromEnvironment() {
        setDirectoriesToBackup(getEnvArr(DIRS_TO_BACKUP));
        
        String dir = getEnv(DIR_TO_STORE_BACKUP_FILES);
        
        setDirectoryToStoreBackupFiles(dir);
        setDirectoryToStoreSnapshotFile(dir);
        setDirectoryToStoreHistoryFile(dir);
        setBackupStorageType(getEnv(BACKUP_STORAGE_TYPE));
    }
    
    /**
     * This method is expected to be overridden
     */
    protected String getEnv(String var) {
        return SystemPropsHelper.getProperty(var);
    }
    
    /**
     * This method is expected to be overridden
     */
    protected String[] getEnvArr(String var) {
        //FIXME null checks
        return SystemPropsHelper.getProperty(var).split(",");
    }
    
    /*private void setExecutionType(String type) throws BackupInitException {
        _executionType = type;
    }
     */
    
    public String[] getDirectoriesToBackup() {
        return _directoriesToBackup;
    }
    
    public String getDirectoryToStoreBackupFiles() {
        return _directoryToStoreBackupFiles;
    }
    
    public String getDirectoryToStoreHistoryFile() {
        return _directoryToStoreHistoryFile;
    }
    
    public String getDirectoryToStoreSnapshotFile() {
        return _directoryToStoreSnapshotFile;
    }
    
    /**
     * name of the snapshot file
     * Timestamp is added to this prefix
     */
    public String getSnapshotFileNamePrefix() {
        return _snapshotFileNamePrefix;
    }
    
    /**
     * prefix to be used for backup files
     * timestamp and the backup number is
     * added to this prefix
     */
    public String getBackupFileNamePrefix() {
        return _backupFileNamePrefix;
    }
    
    /**
     * Name of the history file
     */
    public String getBackupHistoryFileName() {
        return _backupHistoryFileName;
    }
    
    /**
     * Keeps backups upto max backups. After that many backups,
     * oldest backup is deleted.
     */
    public int getMaxBackups() {
        return _maxBackups;
    }
      /**
     * Keeps backups upto max backups. After that many backups,
     * oldest backup is deleted.
     */
    public int getMaxSnapShots() {
        return _maxSnapShots;
    }
    
    
    public String getExecutionType() {
        return getEnv(EXECUTION_TYPE);
    }
    
    private void    setDirectoryToStoreBackupFiles(String dir) {
        _directoryToStoreBackupFiles = dir;
    }
    private void setDirectoryToStoreSnapshotFile(String dir) {
        _directoryToStoreSnapshotFile = dir;
    }
    private void setDirectoryToStoreHistoryFile(String dir) {
        _directoryToStoreHistoryFile = dir;
    }
    private void setDirectoriesToBackup(String[] dirs) {
        _directoriesToBackup = dirs;
    }
    
    public String getBackupStorageType() {
        return _backupStorageType;
    }
    
    private void setBackupStorageType(String type) {
        _backupStorageType = type;
    }
    
    public String getStatusInfoFileName() {
        return _statusInfoFileName;
    }
    
}
