/*
 * BackupStatus.java
 *
 * Created on December 13, 2000, 6:52 AM
 */

package com.sun.enterprise.config.backup.status;

import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.utils.BackupHelper;
import com.sun.enterprise.config.backup.utils.LocalStringsHelper;

/**
 *
 * @author  sridatta
 */
public class RestoreStatus extends Status {
    
    /**
     * This file is used to undo restore operation
     */
    private String _snapshotBackupFile;
    private String _backupFileName;
    private String _absoluteBackupFileName;
    
    /** Creates a new instance of BackupStatus */
    public RestoreStatus() {
    }
    
     public RestoreStatus(String name) throws BackupException {
         super(true);
       _absoluteBackupFileName = name;
    }

    public String getOperation() {
        return "restore";
    }
    
    public String thisToString() {
        return "Backup File= " + _absoluteBackupFileName;
    }
    
    public static RestoreStatus createFailedRestoreStatus(String msg, String file) {
        RestoreStatus rs = new RestoreStatus();
        BackupHelper.setExceptionInStatus(rs, new BackupException(
                msg,
                LocalStringsHelper.getString(msg,file)));
        return rs;
    }
}
