/*
 * StatusCode.java
 *
 * Created on December 13, 2000, 6:32 AM
 */

package com.sun.enterprise.config.backup.status;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.config.backup.utils.LocalStringsHelper;

//import i18n UTIL
//TBD FIXME

/**
 *
 * @author  sridatta
 */
public class StatusCode implements StatusConstants {
    private String _status;
    
    /** Creates a new instance of StatusCode */
    public StatusCode() {
        _status = STATUS_UNKNOWN;
    }
    
    public String getStatusCode() {
        return _status;
    }
    
    void setStatus(String status) throws BackupException {
        if(status != STATUS_SUCCESS &&
                status != STATUS_FAILURE) {
            throw new BackupException
                ("config_backup_wrong_status_code", LocalStringsHelper.getString
                    ("config_backup_wrong_status_code", status));
        }
        _status = status;
    }
    
    public boolean isSuccess() {
        return (_status == STATUS_SUCCESS);
    }
    
     public String toString() {
        return _status;
    }
}
