/*
 * HPTalx
 * A PC<->HP48/49 communication program for Linux
 *
 * (C) 1999, 2000 by Bruno Barberi Gnecco
 *
 * rev 1.1.0:	File split from io.c
 *		Added kermit/xmodem support
 *		Added wait_connect field
 */

/*
    Copyright note:

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "hptalx.h"
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define BUFFERSIZE 256

static void set_text ( GtkWidget *w, gpointer data ) {
	if ( preferences.editor )
		free( preferences.editor );
	preferences.editor = strdup( gtk_entry_get_text(data) );
}

static void set_com_port ( GtkWidget *w, gpointer data ) {
	preferences.port = GPOINTER_TO_INT(data);
}

static void set_wait_connect ( GtkWidget *w, gpointer data ) {
	preferences.wait_connect = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(data));

}

static void set_protocol ( GtkWidget *w, gpointer data ) {
	preferences.protocol = (PROTOCOL_TYPE)GPOINTER_TO_INT(data);
}

static void set_toggle ( GtkWidget *w, gpointer data ) {
	if ( !strcmp( data, "delete_confirm" ) )
		preferences.delete_confirm = GTK_TOGGLE_BUTTON(w)->active;
	else if ( !strcmp( data, "start_connected" ) )
		preferences.start_connected = GTK_TOGGLE_BUTTON(w)->active;
	else if ( !strcmp( data, "start_after_dot" ) )
		preferences.start_after_dot = GTK_TOGGLE_BUTTON(w)->active;
	else
		message_box( "!", "Well, this message means that either\n"
				"something has gone very wrong or there's a bug\n"
				"in the set_toggle() function..." );
}

static void save_prefs ( GtkWidget *w, gpointer data ) {
	FILE *fsetup;
	char *dir, *filename, *t;
	
	dir = strdup(getenv( "HOME" ));
	t = strtok( dir, "=" );
	while ( isspace(*t) ) t++;
	filename = (char *)malloc(strlen(t)+9);
	strcpy( filename, t );
	strcat( filename, "/.hptalx" );

	if ( (fsetup = fopen( filename, "w" )) == NULL ) {
		message_box( "Error", "Could not open\npreferences file." );
	}
	else {		
		fprintf( fsetup, "port = %d\n", preferences.port );
		fprintf( fsetup, "delete_confirm = %d\n", preferences.delete_confirm );
		fprintf( fsetup, "start_connected = %d\n", preferences.start_connected );
		fprintf( fsetup, "start_after_dot = %d\n", preferences.start_after_dot );
		fprintf( fsetup, "set_wait_connect = %d\n", preferences.wait_connect );
		fprintf( fsetup, "editor = %s\n", preferences.editor );
		fprintf( fsetup, "protocol = %d\n", preferences.protocol);
		fclose( fsetup );
	}
	free( filename );
	free( dir );
}

/* very simple parsing */
void load_prefs ( void ) {
	FILE *fsetup;
	char *dir, *filename, *t, temp[BUFFERSIZE];
	int i;

	dir = strdup(getenv( "HOME" ));
	t = strtok( dir, "=" );
	while ( isspace(*t) ) t++;
	filename = (char *)malloc(strlen(t)+9);
	strcpy( filename, t );
	strcat( filename, "/.hptalx" );
	
	preferences.port = 0;
	preferences.delete_confirm = TRUE;
	preferences.start_connected = FALSE;
	preferences.start_after_dot = TRUE;
	preferences.wait_connect = 3;
	preferences.editor = strdup( "nedit" );
	preferences.protocol = KERMIT;
	if ( (fsetup = fopen( filename, "r" )) != NULL ) {
		fgets( temp, BUFFERSIZE-1, fsetup );
		t = strchr( temp, '=' ) + 1;
		sscanf( t, "%d", &preferences.port );
		fgets( temp, BUFFERSIZE-1, fsetup );
		t = strchr( temp, '=' ) + 1;
		sscanf( t, "%d", &preferences.delete_confirm );
		fgets( temp, BUFFERSIZE-1, fsetup );
		t = strchr( temp, '=' ) + 1;
		sscanf( t, "%d", &preferences.start_connected );
		fgets( temp, BUFFERSIZE-1, fsetup );
		t = strchr( temp, '=' ) + 1;
		sscanf( t, "%d", &preferences.start_after_dot );
		fgets( temp, BUFFERSIZE-1, fsetup );
		t = strchr( temp, '=' ) + 1;
		sscanf( t, "%d", &preferences.wait_connect );
		fgets( temp, BUFFERSIZE-1, fsetup );
		t = strchr( temp, '=' ) + 1;
		while ( isspace (*t) ) t++;
		preferences.editor = strdup( t );
		t = strchr( preferences.editor, '\n' );
		*t = '\0';
		fgets( temp, BUFFERSIZE-1, fsetup );
		t = strchr( temp, '=' ) + 1;
		sscanf( t, "%d", &i );
		preferences.protocol = (PROTOCOL_TYPE)i;
	}
	free( filename );
	free( dir );
}

void setup ( GtkWidget *w, gpointer data ) {
	GtkWidget *dialog;
	GtkWidget *label;
	GtkWidget *hbox, *vbox;
	GtkWidget *button;
	GtkWidget *sep;
	GtkWidget *entry;
	GtkWidget *wait_but;
	GtkAdjustment *wait_adj;

	dialog = gtk_dialog_new();

	/* 'freeze' */
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

	gtk_window_set_title (GTK_WINDOW(dialog), "Setup");
	gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
	gtk_widget_set_usize(dialog, 0, 0);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 10);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG (dialog)->vbox), hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	/* Radio buttons to set serial port */
	label = gtk_label_new("Set COM port:");
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, FALSE, 0);
	gtk_widget_show(label);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER (vbox), 10);
	gtk_box_pack_start(GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
	gtk_widget_show(vbox);

	button = gtk_radio_button_new_with_label(NULL, "COM 1");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (set_com_port), GINT_TO_POINTER(0) );
	gtk_box_pack_start(GTK_BOX (vbox), button, TRUE, TRUE, 0);
	if ( preferences.port == 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), TRUE);
	gtk_widget_show(button);
	button = gtk_radio_button_new_with_label(
	              gtk_radio_button_group (GTK_RADIO_BUTTON (button)), "COM 2");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (set_com_port), GINT_TO_POINTER(1) );
	gtk_box_pack_start(GTK_BOX (vbox), button, TRUE, TRUE, 0);
	if ( preferences.port == 1 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), TRUE);
	gtk_widget_show(button);
	button = gtk_radio_button_new_with_label(
	              gtk_radio_button_group (GTK_RADIO_BUTTON (button)), "COM 3");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (set_com_port), GINT_TO_POINTER(2) );
	gtk_box_pack_start(GTK_BOX (vbox), button, TRUE, TRUE, 0);
	if ( preferences.port == 2 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), TRUE);
	gtk_widget_show(button);
	button = gtk_radio_button_new_with_label(
	              gtk_radio_button_group (GTK_RADIO_BUTTON (button)), "COM 4");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (set_com_port), GINT_TO_POINTER(3) );
	gtk_box_pack_start(GTK_BOX (vbox), button, TRUE, TRUE, 0);
	if ( preferences.port == 3 )
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button), TRUE);
	gtk_widget_show(button);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), sep, TRUE, TRUE, 0);
	gtk_widget_show(sep);
	
	/* confirm delete? */
	button = gtk_check_button_new_with_label( "Confirm delete and remove dir" );
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), preferences.delete_confirm );
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	        		   GTK_SIGNAL_FUNC(set_toggle), "delete_confirm" );
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), button, TRUE, TRUE, 0);
	gtk_widget_show( button );

	/* start connected? */
	button = gtk_check_button_new_with_label( "Start connected" );
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), preferences.start_connected );
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	        		   GTK_SIGNAL_FUNC(set_toggle), "start_connected" );
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), button, TRUE, TRUE, 0);
	gtk_widget_show( button );
	
	/* select first file after files starting with . */
	button = gtk_check_button_new_with_label( "PC list start showing after files starting with ." );
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), preferences.start_after_dot );
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	        		   GTK_SIGNAL_FUNC(set_toggle), "start_after_dot" );
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), button, TRUE, TRUE, 0);
	gtk_widget_show( button );

	/* wait_connect */
	wait_adj = (GtkAdjustment *)gtk_adjustment_new (preferences.wait_connect,
			0.0, 30.0, 1.0, 5.0, 0.0 );
	wait_but = gtk_spin_button_new(wait_adj, 0, 0);
	gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(wait_but), TRUE);
	gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(wait_but), GTK_SHADOW_OUT);
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), wait_but,
			TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(wait_adj), "value_changed",
			GTK_SIGNAL_FUNC(set_wait_connect), (gpointer)wait_but);
	gtk_widget_show( wait_but );
	
	/* editor */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 10);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG (dialog)->vbox), hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new("Set default editor:");
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, FALSE, 0);
	gtk_widget_show(label);
	
	entry = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY(entry), preferences.editor );
	gtk_box_pack_start(GTK_BOX (hbox), entry,
			FALSE, FALSE, 10);
	gtk_signal_connect(GTK_OBJECT (entry), "changed",
			GTK_SIGNAL_FUNC(set_text), GTK_OBJECT( entry ) );
	gtk_widget_show(entry);

	button = gtk_radio_button_new_with_label(NULL, "Kermit");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (set_protocol), GINT_TO_POINTER(0) );
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), button, TRUE, TRUE, 0);
	if ( preferences.protocol == KERMIT )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), TRUE);
	gtk_widget_show(button);
	button = gtk_radio_button_new_with_label(
	              gtk_radio_button_group (GTK_RADIO_BUTTON (button)), "XModem");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (set_protocol), GINT_TO_POINTER(1) );
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), button, TRUE, TRUE, 0);
	if ( preferences.protocol == XMODEM )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), TRUE);
	gtk_widget_show(button);


	button = gtk_button_new_with_label("OK");
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(gtk_main_quit), GTK_OBJECT(dialog) );
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog) );
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area), button, TRUE, TRUE, 0);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Save");
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
		 		   GTK_SIGNAL_FUNC(save_prefs), GTK_OBJECT(dialog) );
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	gtk_widget_show(dialog);
	gtk_main();
}

void howtouse ( GtkWidget *w, gpointer data ) {
	message_box( "How to use", 
		"HPTalx is a kermit GUI frontend written for Linux using GTK+.\n\n"
		"Double clicking on files will transfer them, if connected;\n"
		"otherwise will open the default editor; double clicking on\n"
		"directories will open them. A right button click will open a popup\n"
		"menu with useful shortcuts.\n\n"
		"Don't forget to setup the correct COM port in Files/Setup. Your\n"
		"setup can be saved (in ~/.hptalx) if you want.\n\n"
		"Any critics, suggestions or praises?\n"
		"Email the author: <brunobg@geocities.com>" );
}

void about ( GtkWidget *w, gpointer data ) {
	message_box("About",
		"HP Talx " VERSION " for Linux\n"
		"Copyright (C) 1999, 2000 Bruno Barberi Gnecco <brunobg@geocities.com>\n"
		"Latest version is at http://www.geocities.com/RodeoDrive/1980/hptalx.html\n"
		"HPTalx comes with ABSOLUTELY NO WARRANTY; for details see `GPL'.\n"
		"This is free software, and you are welcome to redistribute it\n"
		"under certain conditions; see `GPL' for details." );
}
