/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.util.List;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class ACyclicDFACodeGenerator {
    protected CodeGenerator parentGenerator;

    public StringTemplate genFixedLookaheadDecision(StringTemplateGroup templates, DFA dfa) {
        return this.walkFixedDFAGeneratingStateMachine(templates, dfa, dfa.startState, 1);
    }

    protected StringTemplate walkFixedDFAGeneratingStateMachine(StringTemplateGroup templates, DFA dfa, DFAState s, int k) {
        StringTemplate targetST;
        StringTemplate edgeST;
        if (s.isAcceptState()) {
            StringTemplate dfaST = templates.getInstanceOf("dfaAcceptState");
            dfaST.setAttribute("alt", (Object)Utils.integer(s.getUniquelyPredictedAlt()));
            return dfaST;
        }
        String dfaStateName = "dfaState";
        String dfaLoopbackStateName = "dfaLoopbackState";
        String dfaOptionalBlockStateName = "dfaOptionalBlockState";
        String dfaEdgeName = "dfaEdge";
        if (this.parentGenerator.canGenerateSwitch(s)) {
            dfaStateName = "dfaStateSwitch";
            dfaLoopbackStateName = "dfaLoopbackStateSwitch";
            dfaOptionalBlockStateName = "dfaOptionalBlockStateSwitch";
            dfaEdgeName = "dfaEdgeSwitch";
        }
        StringTemplate dfaST = templates.getInstanceOf(dfaStateName);
        if (dfa.getNFADecisionStartState().decisionStateType == 1) {
            dfaST = templates.getInstanceOf(dfaLoopbackStateName);
        } else if (dfa.getNFADecisionStartState().decisionStateType == 3) {
            dfaST = templates.getInstanceOf(dfaOptionalBlockStateName);
        }
        dfaST.setAttribute("k", (Object)Utils.integer(k));
        dfaST.setAttribute("stateNumber", (Object)Utils.integer(s.stateNumber));
        dfaST.setAttribute("semPredState", (Object)s.isResolvedWithPredicates());
        String description = dfa.getNFADecisionStartState().getDescription();
        description = this.parentGenerator.target.getTargetStringLiteralFromString(description);
        if (description != null) {
            dfaST.setAttribute("description", (Object)description);
        }
        int EOTPredicts = -1;
        DFAState EOTTarget = null;
        int i = 0;
        while (i < s.getNumberOfTransitions()) {
            Transition edge = s.transition(i);
            if (edge.label.getAtom() == -2) {
                EOTTarget = (DFAState)edge.target;
                EOTPredicts = EOTTarget.getUniquelyPredictedAlt();
            } else {
                DFAState target;
                SemanticContext preds;
                edgeST = templates.getInstanceOf(dfaEdgeName);
                if (edgeST.getFormalArgument("labels") != null) {
                    List labels = edge.label.getSet().toList();
                    int j = 0;
                    while (j < labels.size()) {
                        Integer vI = (Integer)labels.get(j);
                        String label = this.parentGenerator.getTokenTypeAsTargetLabel(vI);
                        labels.set(j, label);
                        ++j;
                    }
                    edgeST.setAttribute("labels", (Object)labels);
                } else {
                    edgeST.setAttribute("labelExpr", (Object)this.parentGenerator.genLabelExpr(templates, edge, k));
                }
                if (!edge.label.isSemanticPredicate() && (preds = (target = (DFAState)edge.target).getGatedPredicatesInNFAConfigurations()) != null) {
                    StringTemplate predST = preds.genExpr(this.parentGenerator, this.parentGenerator.getTemplates(), dfa);
                    edgeST.setAttribute("predicates", (Object)predST.toString());
                }
                targetST = this.walkFixedDFAGeneratingStateMachine(templates, dfa, (DFAState)edge.target, k + 1);
                edgeST.setAttribute("targetState", (Object)targetST);
                dfaST.setAttribute("edges", (Object)edgeST);
            }
            ++i;
        }
        if (EOTPredicts != -1) {
            dfaST.setAttribute("eotPredictsAlt", (Object)Utils.integer(EOTPredicts));
        } else if (EOTTarget != null && EOTTarget.getNumberOfTransitions() > 0) {
            i = 0;
            while (i < EOTTarget.getNumberOfTransitions()) {
                Transition predEdge = EOTTarget.transition(i);
                edgeST = templates.getInstanceOf(dfaEdgeName);
                edgeST.setAttribute("labelExpr", (Object)this.parentGenerator.genSemanticPredicateExpr(templates, predEdge));
                targetST = this.walkFixedDFAGeneratingStateMachine(templates, dfa, (DFAState)predEdge.target, k + 1);
                edgeST.setAttribute("targetState", (Object)targetST);
                dfaST.setAttribute("edges", (Object)edgeST);
                ++i;
            }
        }
        return dfaST;
    }

    public ACyclicDFACodeGenerator(CodeGenerator parent) {
        this.parentGenerator = parent;
    }
}

