/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TestAutoAST
extends BaseTest {
    protected boolean debug;

    public void testTokenList() throws Exception {
        String grammar = "grammar foo;\noptions {output=AST;}\na : ID INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "abc 34", this.debug);
        TestAutoAST.assertEquals((String)"abc 34\n", (String)found);
    }

    public void testTokenListInSingleAltBlock() throws Exception {
        String grammar = "grammar foo;\noptions {output=AST;}\na : (ID INT) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "abc 34", this.debug);
        TestAutoAST.assertEquals((String)"abc 34\n", (String)found);
    }

    public void testSimpleRootAtOuterLevel() throws Exception {
        String grammar = "grammar foo;\noptions {output=AST;}\na : ID^ INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "abc 34", this.debug);
        TestAutoAST.assertEquals((String)"(abc 34)\n", (String)found);
    }

    public void testSimpleRootAtOuterLevelReverse() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : INT ID^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "34 abc", this.debug);
        TestAutoAST.assertEquals((String)"(abc 34)\n", (String)found);
    }

    public void testBang() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID INT! ID! INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "abc 34 dag 4532", this.debug);
        TestAutoAST.assertEquals((String)"abc 4532\n", (String)found);
    }

    public void testLoopRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ( ID^ INT )* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a 1 b 2 c 3", this.debug);
        TestAutoAST.assertEquals((String)"(a 1) (b 2) (c 3)\n", (String)found);
    }

    public void testLoopRootReverse() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ( ID INT^ )* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a 1 b 2 c 3", this.debug);
        TestAutoAST.assertEquals((String)"(1 a) (2 b) (3 c)\n", (String)found);
    }

    public void testPlusLoopRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ( ID^ INT )+ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a 1 b 2 c 3", this.debug);
        TestAutoAST.assertEquals((String)"(a 1) (b 2) (c 3)\n", (String)found);
    }

    public void testPlusLoopRootReverse() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ( ID^ INT )+ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a 1 b 2 c 3", this.debug);
        TestAutoAST.assertEquals((String)"(a 1) (b 2) (c 3)\n", (String)found);
    }

    public void testOptionalThenRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ( ID INT )? ID^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a 1 b", this.debug);
        TestAutoAST.assertEquals((String)"(b a 1)\n", (String)found);
    }

    public void testLabeledStringRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : v='void'^ ID ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "void foo;", this.debug);
        TestAutoAST.assertEquals((String)"(void foo ;)\n", (String)found);
    }

    public void testWildcard() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : v='void'^ . ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "void foo;", this.debug);
        TestAutoAST.assertEquals((String)"(void foo ;)\n", (String)found);
    }

    public void testWildcardRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : v='void' .^ ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "void foo;", this.debug);
        TestAutoAST.assertEquals((String)"(foo void ;)\n", (String)found);
    }

    public void testRootRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID^ INT^ ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a 34 c", this.debug);
        TestAutoAST.assertEquals((String)"(34 a c)\n", (String)found);
    }

    public void testRootRoot2() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID INT^ ID^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a 34 c", this.debug);
        TestAutoAST.assertEquals((String)"(c (34 a))\n", (String)found);
    }

    public void testNestedSubrule() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : 'void' (({;}ID|INT) ID | 'null' ) ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "void a b;", this.debug);
        TestAutoAST.assertEquals((String)"void a b ;\n", (String)found);
    }

    public void testInvokeRule() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na  : type ID ;\ntype : {;}'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "int a", this.debug);
        TestAutoAST.assertEquals((String)"int a\n", (String)found);
    }

    public void testInvokeRuleAsRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na  : type^ ID ;\ntype : {;}'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "int a", this.debug);
        TestAutoAST.assertEquals((String)"(int a)\n", (String)found);
    }

    public void testRuleRootInLoop() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID ('+'^^ ID)* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a+b+c+d", this.debug);
        TestAutoAST.assertEquals((String)"(+ (+ (+ a b) c) d)\n", (String)found);
    }

    public void testRuleInvocationRuleRootInLoop() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID (op^^ ID)* ;\nop : {;}'+' | '-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a+b+c-d", this.debug);
        TestAutoAST.assertEquals((String)"(- (+ (+ a b) c) d)\n", (String)found);
    }

    public void testTailRecursion() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\ns : a ;\na : atom ('exp'^^ a)? ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "s", "3 exp 4 exp 5", this.debug);
        TestAutoAST.assertEquals((String)"(exp 3 (exp 4 5))\n", (String)found);
    }

    public void testSet() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID|INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "abc", this.debug);
        TestAutoAST.assertEquals((String)"abc\n", (String)found);
    }

    public void testSetRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ('+' | '-')^ ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "+abc", this.debug);
        TestAutoAST.assertEquals((String)"(+ abc)\n", (String)found);
    }

    public void testSetAsRuleRootInLoop() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ID (('+'|'-')^^ ID)* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a+b-c", this.debug);
        TestAutoAST.assertEquals((String)"(- (+ a b) c)\n", (String)found);
    }

    public void testNotSet() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ~ID '+' INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "34+2", this.debug);
        TestAutoAST.assertEquals((String)"34 + 2\n", (String)found);
    }

    public void testNotSetRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ~'+'^ INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "34 55", this.debug);
        TestAutoAST.assertEquals((String)"(34 55)\n", (String)found);
    }

    public void testNotSetRuleRootInLoop() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : INT (~INT^^ INT)* ;\nblort : '+' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "3+4+5", this.debug);
        TestAutoAST.assertEquals((String)"(+ (+ 3 4) 5)\n", (String)found);
    }

    public void testTokenLabelReuse() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : id=ID id=ID {System.out.print(\"2nd id=\"+$id.text+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestAutoAST.assertEquals((String)"2nd id=b;a b\n", (String)found);
    }

    public void testTokenLabelReuse2() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : id=ID id=ID^ {System.out.print(\"2nd id=\"+$id.text+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestAutoAST.assertEquals((String)"2nd id=b;(b a)\n", (String)found);
    }

    public void testTokenListLabelReuse() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ids+=ID ids+=ID {System.out.print(\"id list=\"+$ids+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        String expecting = "id list=[[@0,0:0='a',<4>,1:0], [@2,2:2='b',<4>,1:2]];a b\n";
        TestAutoAST.assertEquals((String)expecting, (String)found);
    }

    public void testTokenListLabelReuse2() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ids+=ID^ ids+=ID {System.out.print(\"id list=\"+$ids+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        String expecting = "id list=[[@0,0:0='a',<4>,1:0], [@2,2:2='b',<4>,1:2]];(a b)\n";
        TestAutoAST.assertEquals((String)expecting, (String)found);
    }

    public void testTokenListLabelRuleRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : id+=ID^^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a", this.debug);
        TestAutoAST.assertEquals((String)"a\n", (String)found);
    }

    public void testTokenListLabelBang() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : id+=ID! ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a", this.debug);
        TestAutoAST.assertEquals((String)"nil\n", (String)found);
    }

    public void testRuleListLabel() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : x+=b x+=b {b_return ret=(b_return)$x.get(1);System.out.print(\"2nd x=\"+((CommonTree)ret.tree).toStringTree()+';');} ;\nb : ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestAutoAST.assertEquals((String)"2nd x=b;a b\n", (String)found);
    }

    public void testRuleListLabelRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ( x+=b^ )+ {b_return ret=(b_return)$x.get(1);System.out.print(\"x=\"+((CommonTree)ret.tree).toStringTree()+';');} ;\nb : ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestAutoAST.assertEquals((String)"x=b;a b\n", (String)found);
    }

    public void testRuleListLabelRuleRoot() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : ( x+=b^^ )+ {b_return ret=(b_return)$x.get(1);System.out.print(\"x=\"+((CommonTree)ret.tree).toStringTree()+';');} ;\nb : ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestAutoAST.assertEquals((String)"x=(b a);(b a)\n", (String)found);
    }

    public void testRuleListLabelBang() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : x+=b! x+=b {b_return ret=(b_return)$x.get(0);System.out.print(\"1st x=\"+((CommonTree)ret.tree).toStringTree()+';');} ;\nb : ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a b", this.debug);
        TestAutoAST.assertEquals((String)"1st x=a;b\n", (String)found);
    }

    public void testComplicatedMelange() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na : A b=B b=B c+=C c+=C D {$D.text;} ;\nA : 'a' ;\nB : 'b' ;\nC : 'c' ;\nD : 'd' ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "a b b c c d", this.debug);
        TestAutoAST.assertEquals((String)"a b b c c d\n", (String)found);
    }

    public void testReturnValueWithAST() throws Exception {
        String grammar = "grammar foo;\noptions {output=AST;}\na : ID b {System.out.println($b.i);} ;\nb returns [int i] : INT {$i=Integer.parseInt($INT.text);} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "abc 34", this.debug);
        TestAutoAST.assertEquals((String)"34\nabc 34\n", (String)found);
    }

    public void _test() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na :  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String found = this.execParser("T.g", grammar, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestAutoAST.assertEquals((String)"\n", (String)found);
    }

    private final /* synthetic */ void this() {
        this.debug = false;
    }

    public TestAutoAST() {
        this.this();
    }
}

