package net.sf.jabref.export.layout.format;

import net.sf.jabref.export.layout.LayoutFormatter;

/**
 * Used to fix [ 1588028 ] export HTML table doi url.
 * 
 * Will prepend "http://dx.doi.org/" if only doi number and not a URL is given.
 * 
 * @author $Author: coezbek $
 * @version $Revision: 1807 $ ($Date: 2006-11-12 03:42:42 +0100 (Sun, 12 Nov 2006) $)
 *
 */
public class DOICheck implements LayoutFormatter {

	public String format(String fieldText) {
		
		if (fieldText == null){
			return null;
		}
		
		fieldText = fieldText.trim();
		
		if (fieldText.length() == 0){
			return fieldText;
		}
		
		if (fieldText.startsWith("10")){
			return "http://dx.doi.org/" + fieldText;
		}
		
		return fieldText;
	}
}
