/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jde.debugger.Application;
import jde.debugger.JDEException;
import jde.debugger.ObjectStore;
import jde.debugger.Protocol;

public abstract class ApplicationCommands
implements Protocol {
    final Application app;
    final ObjectStore store;
    protected Map identifiableEventRequests = Collections.synchronizedMap(new HashMap());

    protected Long addIdentifiableRequest(EventRequest eventRequest) {
        Long l;
        Map map = this.identifiableEventRequests;
        synchronized (map) {
            l = this.app.generateObjectID();
            this.identifiableEventRequests.put(l, eventRequest);
        }
        eventRequest.enable();
        return l;
    }

    protected void deleteIdentifiableRequest(Long l) throws JDEException {
        EventRequestManager eventRequestManager = this.app.getVM().eventRequestManager();
        Map map = this.identifiableEventRequests;
        synchronized (map) {
            if (!this.identifiableEventRequests.containsKey(l)) {
                throw new JDEException("Invalid request ID");
            }
            Object v = this.identifiableEventRequests.get(l);
            if (v == null) {
                throw new JDEException("No such event request");
            }
            if (!(v instanceof EventRequest)) {
                throw new JDEException("Not an event request");
            }
            ((EventRequest)v).disable();
            eventRequestManager.deleteEventRequest((EventRequest)v);
        }
    }

    public ApplicationCommands(Application application, ObjectStore objectStore) {
        this.app = application;
        this.store = objectStore;
    }
}

