/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.spec;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.Iterator;
import java.util.List;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.SessionManager;
import jde.debugger.spec.ReferenceTypeSpec;

public abstract class EventRequestSpec
implements Protocol {
    private final Long m_ID;
    public static final Object expressionKey = "expr";
    private String expr = null;
    public static final Object threadKey = "thread";
    private Object thread = null;
    private int suspendPolicy = 2;
    private List classFilters = null;
    private List classExFilters = null;
    boolean isResolved = false;
    public static final Object specPropertyKey = "spec";
    ReferenceTypeSpec refSpec;
    EventRequest request = null;

    public EventRequestSpec(ReferenceTypeSpec refSpec) {
        this.refSpec = refSpec;
        this.m_ID = SessionManager.generateObjectID();
    }

    public void setExpression(String expr) {
        this.expr = expr;
        if (this.request != null) {
            this.request.putProperty(expressionKey, expr);
        }
    }

    public void setThread(Object thread) {
        this.thread = thread;
        if (this.request != null) {
            this.request.putProperty(threadKey, thread);
        }
    }

    public void setSuspendPolicy(int policy) {
        this.suspendPolicy = policy;
        if (this.request != null) {
            this.request.setSuspendPolicy(policy);
        }
    }

    public void setClassFilters(List filters) {
        this.classFilters = filters;
        if (this.request != null) {
            this.installClassFilters(this.request);
        }
    }

    private void installClassFilters(EventRequest request) {
        if (this.classFilters == null) {
            return;
        }
        Iterator iter = this.classFilters.iterator();
        while (iter.hasNext()) {
            String f = iter.next().toString();
            if (request instanceof ClassPrepareRequest) {
                ((ClassPrepareRequest)request).addClassFilter(f);
                continue;
            }
            if (request instanceof ClassUnloadRequest) {
                ((ClassUnloadRequest)request).addClassFilter(f);
                continue;
            }
            if (request instanceof ExceptionRequest) {
                ((ExceptionRequest)request).addClassFilter(f);
                continue;
            }
            if (!(request instanceof WatchpointRequest)) continue;
            ((WatchpointRequest)request).addClassFilter(f);
        }
    }

    public void setClassExFilters(List filters) {
        this.classExFilters = filters;
        if (this.request != null) {
            this.installClassExFilters(this.request);
        }
    }

    private void installClassExFilters(EventRequest request) {
        if (this.classExFilters == null) {
            return;
        }
        Iterator iter = this.classExFilters.iterator();
        while (iter.hasNext()) {
            String f = iter.next().toString();
            if (request instanceof ClassPrepareRequest) {
                ((ClassPrepareRequest)request).addClassExclusionFilter(f);
                continue;
            }
            if (request instanceof ClassUnloadRequest) {
                ((ClassUnloadRequest)request).addClassExclusionFilter(f);
                continue;
            }
            if (request instanceof ExceptionRequest) {
                ((ExceptionRequest)request).addClassExclusionFilter(f);
                continue;
            }
            if (!(request instanceof WatchpointRequest)) continue;
            ((WatchpointRequest)request).addClassExclusionFilter(f);
        }
    }

    public Long getID() {
        return this.m_ID;
    }

    void setRequest(EventRequest request) {
        this.request = request;
        request.putProperty(specPropertyKey, this);
        request.putProperty(threadKey, this.thread);
        request.putProperty(expressionKey, this.expr);
        request.setSuspendPolicy(this.suspendPolicy);
        this.installClassFilters(request);
        this.installClassExFilters(request);
        request.enable();
    }

    public EventRequest getEventRequest() {
        return this.request;
    }

    abstract boolean resolve(ReferenceType var1) throws JDEException;

    public void attemptResolve(ReferenceType refType, Integer procID) throws JDEException {
        if (!this.isResolved() && this.refSpec.matches(refType) && this.resolve(refType)) {
            JDE.debug(4, "resolve succeeded: " + refType.name());
            this.setIsResolved(procID);
        }
    }

    void attemptImmediateResolve(VirtualMachine vm, Integer procID) throws JDEException {
        Iterator<ReferenceType> iter = vm.allClasses().iterator();
        while (iter.hasNext() && !this.isResolved) {
            ReferenceType refType = iter.next();
            if (!this.refSpec.matches(refType) || !this.resolve(refType)) continue;
            this.setIsResolved(procID);
        }
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setIsResolved(Integer procID) {
        this.isResolved = true;
        JDE.signal(procID, "spec-resolved", this.m_ID.toString(), false);
    }

    boolean isJavaIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

