/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.lang;

import org.apache.java.lang.TimeoutException;

public class Lock {
    private int activeReadLocks = 0;
    private int waitingReadLocks = 0;
    private int activeWriteLocks = 0;
    private int waitingWriteLocks = 0;

    private boolean allowReadLock() {
        return this.activeWriteLocks == 0 && this.waitingWriteLocks == 0;
    }

    private boolean allowWriteLock() {
        return this.activeReadLocks == 0 && this.activeWriteLocks == 0;
    }

    public synchronized void readLock() throws InterruptedException {
        ++this.waitingReadLocks;
        try {
            while (!this.allowReadLock()) {
                this.wait();
            }
            ++this.activeReadLocks;
        }
        finally {
            Object var2_1 = null;
            --this.waitingReadLocks;
        }
    }

    public synchronized void readLock(long l) throws InterruptedException, TimeoutException {
        long l2 = System.currentTimeMillis() + l;
        ++this.waitingReadLocks;
        try {
            while (!this.allowReadLock()) {
                this.wait(l);
                if (this.allowReadLock() || (l = l2 - System.currentTimeMillis()) >= 0L) continue;
                throw new TimeoutException();
            }
            ++this.activeReadLocks;
        }
        finally {
            Object var6_3 = null;
            --this.waitingReadLocks;
        }
    }

    public synchronized void readUnlock() {
        --this.activeReadLocks;
        this.notifyAll();
    }

    public synchronized void writeLock() throws InterruptedException {
        ++this.waitingWriteLocks;
        try {
            while (!this.allowWriteLock()) {
                this.wait();
            }
            ++this.activeWriteLocks;
        }
        finally {
            Object var2_1 = null;
            --this.waitingWriteLocks;
        }
    }

    public synchronized void writeLock(long l) throws InterruptedException, TimeoutException {
        long l2 = System.currentTimeMillis() + l;
        ++this.waitingWriteLocks;
        try {
            if (!this.allowWriteLock()) {
                this.wait(l);
                if (!this.allowWriteLock() && (l = l2 - System.currentTimeMillis()) < 0L) {
                    throw new TimeoutException();
                }
            }
            ++this.activeWriteLocks;
        }
        finally {
            Object var6_3 = null;
            --this.waitingWriteLocks;
        }
    }

    public synchronized void writeUnlock() {
        --this.activeWriteLocks;
        this.notifyAll();
    }
}

