/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructure;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public abstract class AbstractStructureWithAttributes
extends AbstractStructure {
    protected AttributeInfo[] attributes;

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeInfo[] attributeInfoArray) {
        this.attributes = attributeInfoArray;
    }

    public AttributeInfo findAttribute(Class clazz) {
        AttributeInfo attributeInfo = null;
        int n = 0;
        while (n < this.attributes.length) {
            if (this.attributes[n].getClass() == clazz) {
                attributeInfo = this.attributes[n];
                break;
            }
            ++n;
        }
        return attributeInfo;
    }

    protected void readAttributes(DataInput dataInput) throws InvalidByteCodeException, IOException {
        int n = dataInput.readUnsignedShort();
        this.attributes = new AttributeInfo[n];
        int n2 = 0;
        while (n2 < n) {
            this.attributes[n2] = AttributeInfo.createOrSkip(dataInput, this.classFile);
            ++n2;
        }
    }

    protected void writeAttributes(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        int n = this.getLength(this.attributes);
        dataOutput.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            if (this.attributes[n2] == null) {
                throw new InvalidByteCodeException("attribute " + n2 + " is null");
            }
            this.attributes[n2].write(dataOutput);
            ++n2;
        }
    }

    protected int getTotalAttributesLength() {
        int n = 0;
        int n2 = this.getLength(this.attributes);
        int n3 = 0;
        while (n3 < n2) {
            if (this.attributes[n3] != null) {
                n += this.attributes[n3].getAttributeLength();
            }
            ++n3;
        }
        return n;
    }
}

