/***************************************************************
*   
*   Creation Date: <97/07/24 01:19:19 samuel>
*   Time-stamp: <2001/03/30 21:51:15 samuel>
*   
*	<mac_asm.S>
*	
*	TESTING ARENA - emulation testing/debugging
*
*	These assembly functions are run in emulator mode
*	(appears at mac-physical addr 0).
*   
*   Copyright (C) 1997-2001 Samuel Rydh
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*
**************************************************************/

#include "mol_config.h"
#include "asmdefs.h"
#include "processor.h"
	
//#define MOLASM_DEBUG

	.text
GLOBL(_macprog_start):

/************************************************************************/
/*	F U N C T I O N S						*/
/************************************************************************/

#ifdef MOLASM_DEBUG
#warning ********* MAC ASM ENABLED ***********

/***************************************************
 * Timebase / DEC
 **************************************************/

	.org	0
	LOADI	r3,0x1000
	LOADI	r22,0
1:	lwz	r4,0(r3)
	addi	r22,r22,1
	b	1b
	
	b	0x700
	.org 0x700
	.long	0
		
timebase:
	li	r3,0x2000
	li	r4,0x1234
	mttbu	r3
	mttbl	r4

1:	mftbu	r5
	mftb	r6
2:	
	b	2b
		
	li	r5,0x1234	// upper
	li	r6,0x1000	// lower
1:	li	r7,0x22
	subfc	r6,r7,r6
	addme	r5,r5
	b	1b
					
	mftbu	r3
	mftb	r4
	b	timebase

/***************************************************
 * DOZE mode testing
 **************************************************/

doze_test:
	lis	r0,0xffff
	mtspr	HID0, r0
	mfmsr	r1
	LOADI	r2,MSR_POW
	lis	r3,0xffff
1:
//	mtdec	r3
	addi	r8,r8,1
	mtmsr	r2
	b	1b
2:
	nop
	b	2b

	
/***************************************************
 * FPU testing
 **************************************************/

fpu_testing:
	li	r3,MSR_FP | MSR_FE0 | MSR_FE1
	mtmsr	r3

	bl	fp_contents
	mflr	r3
	LOAD_FPR_RANGE fr0,fr31,0,r3
//	mtfsf	0xff,fr13
	addi	r3,r3,1
	mffs	fr5
	mtfsf	0xff,fr5
	LOADI	r4, 0x2000
1:	
//	lfd	fr0,2000(0)
//	lfd	fr1,2000(0)
	fdiv	fr0,fr0,fr1
	b	1b
		
fp_contents:
	blrl
	.long	0x11111111,0x11111111
	.long	0x22222222,0x22222222
	.long	0x33333333,0x33333333
	.long	0x44444444,0x44444444
	.long	0x55555555,0x55555555
	.long	0x66666666,0x66666666
	.long	0x77777777,0x77777777
	.long	0x88888888,0x88888888
	.long	0x99999999,0x99999999
		
	.long	0x11111111,0x11111111
	.long	0x22222222,0x22222222
	.long	0x33333333,0x33333333
	.long	0x44444444,0x44444444
	.long	0x55555555,0x55555555
	.long	0x66666666,0x66666666
	.long	0x77777777,0x77777777
	.long	0x88888888,0x88888888
	.long	0x99999999,0x99999999
	
	.long	0x11111111,0x11111111
	.long	0x22222222,0x22222222
	.long	0x33333333,0x33333333
	.long	0x44444444,0x44444444
	.long	0x55555555,0x55555555
	.long	0x66666666,0x66666666
	.long	0x77777777,0x77777777
	.long	0x88888888,0x88888888
	.long	0x99999999,0x99999999
	
	.long	0x11111111,0x11111111
	.long	0x22222222,0x22222222
	.long	0x33333333,0x33333333
	.long	0x44444444,0x44444444
	.long	0x55555555,0x55555555	

/***************************************************
 * Check Memory (used to test MMU consistency)
 **************************************************/

check_memory:	
	bl	setup
1:	mfctr	r2	
	stwu	r2,4(r4)
	bdnz	1b

	bl	setup
2:	mfctr	r6
	lwzu	r2,4(r4)
	cmpw	r6,r2
	bne	failure
	bdnz	2b	
	b	mem_ok

setup:
	LOADI	r3,0x100000*128		// 128 MB
	subi	r3,r3,0x1000
	srwi	r3,r3,2
	mtctr	r3
	li	r4,0x1000
	subi	r4,r4,4
	blr

failure:
	nop
	b	failure
	addi	r31,r31,1
	b	check_memory
	
mem_ok:
	addi	r30,r30,1
	b	check_memory


/***************************************************
 * Various Stuff
 **************************************************/
	
map_ram:
	LOADI	r3,0x00000006		// 601, 00000 -> 00000
	LOADI	r4,0x0000005F
	mtibatu 1,r3
	mtibatl 1,r4

	li	r5,MSR_DR
	mtmsr	r5

	nop
	nop
	nop
	b	map_ram	
	

setregs:
	li	r0,10
	li	r1,11
	li	r2,12
	li	r3,13
	li	r4,14
	li	r5,15
	li	r6,16
	li	r7,17
	li	r8,18
	li	r9,19
	li	r10,20
	li	r11,21
	li	r12,22
	li	r13,23
	li	r14,24
	li	r15,25
	li	r16,26
	li	r17,27
	li	r18,28
	li	r19,29
	li	r20,30
	li	r21,31
	li	r22,32
	li	r23,33
	li	r24,34
	li	r25,35
	li	r26,36
	li	r27,37
	li	r28,38
	li	r29,39
	li	r30,40
	li	r31,41
	blr

#endif	
GLOBL(_macprog_end ):
