#!/usr/bin/perl -w
#
# Unfortunately, the namespace barrier between the
# assembly files and the c-soruces get breached
# if a record is added to the symbol table 
# (.long <symname> causes this for instance).
# It is not to be possible to solve the problem
# with strip - I think modutils should be altered.
# This script makes sure we don't use local symbols
# as globaly.

$bad = 0;

@msyms = `nm $ARGV[0]` =~ / U (.*)/g or $bad++;
@lsyms = `nm $ARGV[0]` =~ / [td] (.*)/g or $bad++;

for( $i=0; $i <= $#msyms ; $i++ ) {
    for( $j=0; $j <= $#lsyms ; $j++ ) {
	if( $msyms[$i] eq $lsyms[$j] ) {
	    print "Error: *** Local symbol '".$lsyms[$j]."' appears globally! ***\n";
	    $bad++;
	}
    }
}

exit $bad;


