/**************************************************************
*   
*   Creation Date: <97/07/02 19:51:35 samuel>
*   Time-stamp: <2001/05/21 21:32:06 samuel>
*   
*	<extralib.c>
*	
*	Util functions
*   
*   Copyright (C) 1997, 1999, 2001 Samuel Rydh
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*
**************************************************************/

#include "mol_config.h"
#include "mol_assert.h"
#include "extralib.h"


/************************************************************************/
/*	String miscellaneous						*/
/************************************************************************/

ulong 
string_to_ulong( char *str ) 
{
	ulong ret;
	
	/* for now, assume hexadecimal string */
	if( sscanf(str, "%lx",&ret ) )
		return ret;
	return 0;
}

char *
num_to_string( ulong value ) 
{
	char *str;
	
	str = (char*)malloc( 12 );
	sprintf(str,"%lX",value );

	return str;
}

int 
is_number_str( char *str ) 
{
	while( *str ) {
		if( !isxdigit(*str) )
			return 0;
		str++;
	}
	return 1;
}

/* 
 * hexbin - convert numbers to "binhex" format (e.g. 0xA -> 0x1010)
 */
ulong
hexbin( int num ) 
{
	ulong 	ret=0;
	int	i, base=1;
	
	for( i=0; i<8; i++, base=base*16 )
		if( num & (1<<i) )
			ret += base;
	return ret;
}

char *
strncpy0( char *dest, const char *src, size_t n )
{
	char *org = dest;

	if( n<=0 )
		return org;
	while( --n && (*dest++=*src++) )
		;
	if( !n )
		*dest=0;
	return org;
}

char *
strncat0( char *dest, const char *src, size_t n )
{
	char *org = dest;

	if( n<=0 )
		return org;
	while( --n && *dest )
		dest++;

	strncpy0( dest, src, ++n );
	return org;
}

char*
strncat3( char *dest, const char *s1, const char *s2, size_t n )
{
	strncat0( dest, s1, n );
	return strncat0( dest, s2, n );
}

char *
strnpad( char *dest, const char *s1, size_t n )
{
	char *org = dest;
	int len;
	
	if( n<=0 )
		return org;
	strncpy0( dest, s1, n );

	len = strlen( dest );
	n -= len;
	dest += len;

	while( --n )
		*dest++ = ' ';
	*dest++ = 0;
	return org;
}



