/* 
 *   Creation Date: <1999/03/29 05:22:45 samuel>
 *   Time-stamp: <2001/05/19 19:31:22 samuel>
 *   
 *	<long_lseek.c>
 *	
 *	64-bit lseek (for block devices)
 *   
 *   Copyright (C) 1999, 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "mol_config.h"

#include <sys/ioctl.h>
#include <sys/file.h>
#include <linux/hdreg.h>
#include "llseek.h"

/* 
 * linux/fs.h inclues headers incompatible with ioports.h.
 * The following ioctl selector definition has been taken
 * from linux/fs.h
 */
#define BLKGETSIZE _IO(0x12,96) /* return device size (from linux/fs.h) */

_syscall5( int, _llseek, uint, fd, ulong, hi, ulong, lo, loff_t *, res, uint, wh );


ulong
get_file_size_in_blks( int fd )
{
	struct stat	st;
	ulong		num_blocks;
	
	if( fstat( fd, &st ) < 0 ){
		perrorm("fstat");
		return 0;
	}
	num_blocks = st.st_size >> 9;
	if( S_ISBLK( st.st_mode ) ) {
		if( ioctl( fd, BLKGETSIZE, &num_blocks ) < 0 ) {
			/* Certain devices (e.g. /dev/sr0 does not implement BLKGETSIZE) */
			return 0;
		}
	}
	return num_blocks;
}

