// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/include/gc_asserts.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#ifndef _gc_asserts_H_
#define _gc_asserts_H_


//
// Debug time asserts that are frequently checked for
// ensuring heap consistency.
//

#include "platform.h"
#include "orp_types.h"    
#include "object_layout.h"
#include "remembered_set.h"

#if (GC_DEBUG>3)

bool assert_is_object(Object_Gc_Header *p_gc_hdr,
					  Remembered_Set *p_rs = NULL);

bool assert_busy_bit_not_set(Object_Gc_Header *p_gc_hdr,
							 Remembered_Set *p_rs = NULL);

bool assert_object_not_forwarded(Object_Gc_Header *p_gc_hdr,
								 Remembered_Set *p_rs = NULL);

bool assert_object_not_locked(Object_Gc_Header *p_gc_hdr,
							  Remembered_Set *p_rs = NULL);

bool assert_reachable_objects_not_forwarded(Object_Gc_Header *p_gc_hdr,
											Remembered_Set *p_rs = NULL);

#endif // _DEBUG

#endif // _gc_asserts_H_
