// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/include/to_from_table.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#ifndef _TO_FROM_TABLE_H_
#define _TO_FROM_TABLE_H_

//
// Provides To_From table support..
//


#include <iostream.h>
#include "platform.h"
#include "object_layout.h"
#include "orp_for_gc.h"
#include "hash_table.h"

class To_From_Table : Hash_Table {
public:
    To_From_Table();    

    virtual ~To_From_Table();

    void add_key_value(Java_java_lang_Object *address, 
                       Java_java_lang_Object *value);

    void add_key_value_no_lock_needed(Java_java_lang_Object *address, 
                       Java_java_lang_Object *value);
    
    Java_java_lang_Object *get_value(Java_java_lang_Object *address);

    void empty_all();

    bool is_present(Java_java_lang_Object *p_addr);

    To_From_Table *merge(To_From_Table *rs) {
        cerr << "Error: Merge not supported for To_From tables" << endl;
        assert(0);
        orp_exit(1);
        return this;
    }

protected:

    void _extend();

    //
    // Storage for this hash table.
    //
    volatile Java_java_lang_Object **_value_table;
    
private:

};

#endif // _TO_FROM_TABLE_H_

