// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/to_from_table.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


#include "platform.h"
#include "to_from_table.h"
#include <string.h>
#include "gc_globals.h"
#include "train_generation.h"
extern unsigned primes [];

const int NUMBER_OF_PRIMES     = 12;

const double HASH_TABLE_THRESHOLD = 0.6;

To_From_Table::To_From_Table()
: Hash_Table()
{
    if ((_value_table = (volatile Java_java_lang_Object **)malloc(_size_in_bytes)) == NULL) {
        DWORD LastError = GetLastError();
        fprintf(stderr,
                "Error: malloc failed when creating to_from_table table "
                "%d (0x%x)\n",
                LastError, LastError);
        assert(LastError);
    }

    memset(_value_table, 0, _size_in_bytes);
// Pump this up a lot

    _extend();
    _extend();
    _extend();
    _extend();
    return;
}

To_From_Table::~To_From_Table()
/* Discard this pair table. */
{
    free(_value_table);
}

Java_java_lang_Object *
To_From_Table::get_value(Java_java_lang_Object *address)
{
    int offset = _get_offset(address);

#if (GC_DEBUG>0)
    assert(offset >= 0);
#endif

    return (Java_java_lang_Object *)_value_table[offset];
}

static PVOID add_key_value_lock = (PVOID)0;

bool 
To_From_Table::is_present(Java_java_lang_Object *address)
{    
    while ((InterlockedCompareExchange(&add_key_value_lock, (PVOID)1, (PVOID)0)) != 0) {
    }

    bool result = Hash_Table::is_present(address);

    if (InterlockedCompareExchange(&add_key_value_lock, (PVOID)0, (PVOID)1) != (PVOID)1) {
        // Why do I need this wouldn't a simple assign do??
        assert (0);
    }

    return result;
}


void
add_key_value_no_lock_needed (Java_java_lang_Object *address, Java_java_lang_Object *value);

void 
To_From_Table::add_key_value(Java_java_lang_Object *address, Java_java_lang_Object *value)
{
    // Value is in a "to" car and address is in a "from" car.
    assert(p_global_bs->get_mature_generation()->is_object_in_focus_car(value));
    assert(!p_global_bs->get_mature_generation()->is_object_in_focus_car(address));
    // Spin until you get the lock. This fails!!! if we extend holding the lock.
    while ((InterlockedCompareExchange(&add_key_value_lock, (PVOID)1, (PVOID)0)) != 0) {
    }
    add_key_value_no_lock_needed(address, value);

    if (InterlockedCompareExchange(&add_key_value_lock, (PVOID)0, (PVOID)1) != (PVOID)1) {
        // Why do I need this wouldn't a simple assign do??
        assert (0);
    }
}

// Used by the above and by extend.
void
To_From_Table::add_key_value_no_lock_needed (Java_java_lang_Object *address, Java_java_lang_Object *value)
{
    bool is_it_present = Hash_Table::is_present(address);

    if (is_it_present) {
        int test_offset = Hash_Table::_get_offset(address);
        assert (_value_table[test_offset] == value); 
    }
    int offset = Hash_Table::add_entry(address);
    assert ((_value_table[offset] == 0) || (_value_table[offset] == value));
    _value_table[offset] = value;
    assert (add_key_value_lock == (PVOID)1);
}

void
To_From_Table::empty_all()
{
    Hash_Table::empty_all();
    // This is done above.
    memset(_value_table, 0, _size_in_bytes);
}



void
To_From_Table::_extend()
/* The residency in our remembered set has exceeded a pre-defined
   threshold. Therefore we create a larger remembered set and re-
   hash. 
   Always rehash after doing an extend. */
{
    volatile Java_java_lang_Object **p_save_value_table = _value_table;
    volatile Java_java_lang_Object **p_save_table       = (volatile Java_java_lang_Object **)_table;
	int saved_size_in_entries = _size_in_entries;

    if (_prime_index >= NUMBER_OF_PRIMES) {
        _size_in_entries = _size_in_entries * 2; // Not a prime but really big.
    } else {
        _size_in_entries   = primes[_prime_index++];
    }
    _size_in_bytes     = sizeof(void *) * _size_in_entries;
    _threshold_entries = (unsigned int)(_size_in_entries * HASH_TABLE_THRESHOLD);

	_resident_count     = 0;
    _table = (volatile void **)malloc(_size_in_bytes);
    _value_table = (volatile Java_java_lang_Object **)malloc(_size_in_bytes);

    if ((_table == NULL) || (_value_table == NULL)) {
        fprintf(stderr,"Error: malloc failed when extending remembered set\n");
        assert(0);
    }

	memset(_table, 0, _size_in_bytes);
    memset(_value_table, 0, _size_in_bytes);

    for (int index = 0; index < saved_size_in_entries; index++) {
        if (p_save_table[index] != NULL) {
            assert (p_save_value_table[index] != NULL);
            this->add_key_value_no_lock_needed((Java_java_lang_Object *)p_save_table[index], (Java_java_lang_Object *)p_save_value_table[index]);
        } else {
            // If we don't have an address we had better not have a value.
            assert (p_save_value_table[index] == NULL);
        }
    }
    for (int index1 = 0; index1 < _size_in_entries; index1++) {
        if (_table[index1] == NULL) {
            assert (_value_table[index1] == NULL);
        }
    }
    free(p_save_table);
    free(p_save_value_table);
#if (GC_DEBUG>4)
	this->scan_for_bogus_entries();
#endif // _DEBUG
}

// end file gc\To_From_table.cpp




