// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/gc_profile.h,v 1.1 2001/09/14 18:01:59 rlhudson Exp $
//


#ifndef _gc_profile_H_
#define _gc_profile_H_


//
// Prototypes and external declarations for profiling support.
//


//
// The count of incremental reclamations since the ORP started.
//
extern unsigned int incremental_collection_count;

//
// The frequency of the high resolution performance counter.
//
extern LARGE_INTEGER performance_frequency;
//
// Time when most recent gc started.
//
extern LARGE_INTEGER gc_start_time;
//
// Time when most recent gc completed.
//
extern LARGE_INTEGER gc_end_time;
//
// Time when most recent orp cycle started.
//
extern LARGE_INTEGER orp_start_time;

//
// Time when most recent orp cycle completed.
//
extern LARGE_INTEGER orp_end_time;

//
// Time taken to complete most recent gc.
//
extern unsigned long gc_elapsed_time;
//
// Time taken by the most recent ORP cycle
//
extern unsigned long orp_elapsed_time;
//
// Time taken by the most recent enumeration.
//
extern unsigned long enumeration_elapsed_time;

//
// Objects tenured during this minor collection.
//
extern unsigned long tenured_object_count;

//
// Objects tenured since the application started.
//
extern unsigned long total_tenured_object_count;

//
// Time taken by all gcs so far.
//
extern unsigned long total_gc_elapsed_time;
//
// Total time taken by the ORP.
//
extern unsigned long total_orp_elapsed_time;
//
// Total time taken to enumerate live references
//
extern unsigned long total_enumeration_elapsed_time;

#endif // _gc_profile_H_
