// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/jarfile_util.h,v 1.6 2001/12/18 05:35:59 gwu2 Exp $
//

#ifndef __JAR_FILE_UTIL__
#define __JAR_FILE_UTIL__

#ifndef ZIP_JAR_ARCHIVE
#error "Please ensure you've set ZIP_JAR_ARCHIVE preprocessor, or else you couldn't get jar file support." 
#endif

#include "../../jar_zip_utils/JarFile.h"
#include "../../jar_zip_utils/Jar_Entry.h"
#include "platform.h"

//the file's extension
#define ZIP_EXTENSION ".zip"	
#define JAR_EXTENSION ".jar"

#ifndef ORP_NT
extern "C" {
    int strcasecmp(const char *s1, const char *s2);    
}
#endif

inline bool isEndWith(char* allstr, char* endstr)		//Does allstr end with endstr
{
	unsigned allstrlen = strlen(allstr);
	unsigned endstrlen = strlen(endstr);
	if(allstrlen < endstrlen)
		return false;
#ifdef ORP_NT
	if(stricmp(allstr + allstrlen - endstrlen, endstr) == 0)
#else
    if(strcasecmp(allstr + allstrlen - endstrlen, endstr) == 0)
#endif
	return true;
	return false;
}

inline bool isZIPJARFile(char* filename)
{
	return ((isEndWith(filename, ZIP_EXTENSION)) || (isEndWith(filename, JAR_EXTENSION)));
}

inline const char* getMetaInfoFromJARFile(JarFile *jarfl, const char*mi)
{
	if(!jarfl)return NULL;
	Manifest *mf = jarfl->Get_Manifest();
	if(!mf)return NULL;
	Properties *prop = mf->getMainProperties();
	Prop_String *pv = (Prop_String*)prop->get(mi);
	if(!pv)return NULL;
	return (const char*)pv->value;
}

inline const char* getMainClassFromJARFile(JarFile *jarfl)
{
	return getMetaInfoFromJARFile(jarfl, "Main-Class");
}

inline const char* getClassPathFromJARFile(JarFile *jarfl)
{
	return getMetaInfoFromJARFile(jarfl, "Class-Path");
}

inline const char *getJARFilePath(JarFile *jarfl)
{
	if(!jarfl)return NULL;
	general_info *gf = jarfl->Get_JarFile_Info();
	return gf->filename;
}

inline const char* getQualifiedClassPathFromJARFile(JarFile *jarfl, ExpandableMemBlock &mb){
	mb.SetCurrentPos(0);
	
	if(!jarfl)return NULL;
	const char *cp = getClassPathFromJARFile(jarfl);
	if(!cp)return NULL;
	char *r = strdup(cp);
	if(!r)return NULL;
	
	//Extract the directory of jarfl
	char *p = strdup(getJARFilePath(jarfl));
	char *q = strrchr(p, DIR_SEPARATOR);
	if(q)
		*(q+1) = '\0';
	else{
		*p = '\0';
	}

	char buf[_MAX_PATH];
	struct stat nouse;
	//parse Class-Path field
	q = strtok(r, " ");
	while(q){
		if( !stat(q, &nouse) )
			mb.AppendFormatBlock("%c%s", PATH_SEPARATOR, q);
		else{
			int len = strlen(q);
			if(q[len-1] == '\\' || q[len-1] == '/')
				q[len-1] = '\0';
			sprintf(buf, "%s%s", p, q);
			if( !stat(buf, &nouse) )
				mb.AppendFormatBlock("%c%s", PATH_SEPARATOR, buf);
		}
		q = strtok(NULL, " ");
	}

	delete r;
	delete p;
	
	if(mb.GetCurrentPos() == 0)
		return NULL;
	return mb.toString();
}


#endif

