// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/jvmdi_clean.h,v 1.2 2001/09/14 07:36:26 fzhu Exp $
//


#ifndef _JVMDI_CLEAN_H_
#define _JVMDI_CLEAN_H_

#include "jni.h"
#include "root_set_enum.h"

#ifdef __cplusplus
extern "C" {
#endif

enum jvmdiError {
    JVMDI_ERROR_NONE, // successful completion of the function
    JVMDI_ERROR_OUT_OF_MEMORY,
    JVMDI_ERROR_ACCESS_DENIED,
    JVMDI_ERROR_UNATTACHED_THREAD,
    JVMDI_ERROR_VM_DEAD,
    JVMDI_ERROR_INTERNAL,
    JVMDI_ERROR_INVALID_THREAD,
    JVMDI_ERROR_INVALID_FIELDID,
    JVMDI_ERROR_INVALID_METHODID,
    JVMDI_ERROR_INVALID_LOCATION,
    JVMDI_ERROR_INVALID_FRAMEID,
    JVMDI_ERROR_NO_MORE_FRAMES,
    JVMDI_ERROR_OPAQUE_FRAME,
    JVMDI_ERROR_NOT_CURRENT_FRAME,
    JVMDI_ERROR_TYPE_MISMATCH,
    JVMDI_ERROR_INVALID_SLOT,
    JVMDI_ERROR_DUPLICATE,
    JVMDI_ERROR_THREAD_NOT_SUSPENDED,
    JVMDI_ERROR_THREAD_SUSPENDED,
    JVMDI_ERROR_INVALID_OBJECT,
    JVMDI_ERROR_INVALID_CLASS,
    JVMDI_ERROR_CLASS_NOT_PREPARED,
    JVMDI_ERROR_NULL_POINTER,
    JVMDI_ERROR_ABSENT_INFORMATION,
    JVMDI_ERROR_INVALID_EVENT_TYPE,
    JVMDI_ERROR_NOT_IMPLEMENTED,
    JVMDI_ERROR_INVALID_THREAD_GROUP,
    JVMDI_ERROR_INVALID_PRIORITY,
    JVMDI_ERROR_NOT_FOUND,
    JVMDI_ERROR_INVALID_MONITOR,
    JVMDI_ERROR_ILLEGAL_ARGUMENT,
    JVMDI_ERROR_NOT_MONITOR_OWNER,
    JVMDI_ERROR_INTERRUPT,
    JVMDI_ERROR_INVALID_TYPESTATE,

    JVMDI_THREAD_STATUS_UNKNOWN,
    JVMDI_THREAD_STATUS_ZOMBIE,
    JVMDI_THREAD_STATUS_RUNNING,
    JVMDI_THREAD_STATUS_SLEEPING,
    JVMDI_THREAD_STATUS_MONITOR,
    JVMDI_THREAD_STATUS_WAIT,

    JVMDI_SUSPEND_STATUS_SUSPENDED,
    JVMDI_SUSPEND_STATUS_BREAK,

    JVMDI_CLASS_STATUS_PREPARED,
    JVMDI_CLASS_STATUS_INITIALIZED,
    JVMDI_CLASS_STATUS_ERROR,

    JVMDI_EVENT_VM_INIT,
    JVMDI_EVENT_VM_DEATH,
    JVMDI_EVENT_THREAD_START,

    JVMDI_EVENT_CLASS_LOAD,
    JVMDI_EVENT_CLASS_UNLOAD,
    JVMDI_EVENT_CLASS_PREPARE,

    JVMDI_EVENT_SINGLE_STEP,
    JVMDI_EVENT_BREAKPOINT,

    JVMDI_EVENT_EXCEPTION_CATCH,
    JVMDI_EVENT_FRAME_POP,
    JVMDI_EVENT_METHOD_ENTRY,
    JVMDI_EVENT_METHOD_EXIT,

    JVMDI_ENABLE,
    JVMDI_DISABLE,
};

#define jthread        jobject
#define jthreadGroup   jobject
typedef Object_Handle  JVMDI_RawMonitor;
typedef Field_Handle   jfieldID;
typedef Frame_Context *jframeID;
typedef uint64         jlocation;

typedef jvmdiError (*JVMDI_AllocHook)(jlong size, jbyte** memPtr);

typedef jvmdiError (*JVMDI_DeallocHook)(jbyte* buffer);

jvmdiError JNICALL
SetAllocationHooks(JVMDI_AllocHook ahook, JVMDI_DeallocHook dhook);

jvmdiError JNICALL
Allocate(jlong size, jbyte** memPtr);

jvmdiError JNICALL
Deallocate(jbyte* mem);

jvmdiError JNICALL
GetThreadStatus(jthread thread, jint *threadStatusPtr, jint *suspendStatusPtr);

jvmdiError JNICALL
GetAllThreads(jint *threadsCountPtr, jthread **threadsPtr);

jvmdiError JNICALL
SuspendThreadxx(jthread thread);

jvmdiError JNICALL
ResumeThreadxx(jthread thread);

jvmdiError JNICALL
StopThread(jthread thread, jobject exception);

jvmdiError JNICALL
InterruptThread(jthread thread);



typedef struct {
	char *name;             /* Name in UTF-8 */
	jint priority;
	jboolean is_daemon;
	jthreadGroup thread_group;
	jobject context_class_loader;
} JVMDI_thread_info;

jvmdiError JNICALL
GetThreadInfo(jthread thread, JVMDI_thread_info *infoPtr);



typedef struct {
    jint owned_monitor_count;
    jobject *owned_monitors;
} JVMDI_owned_monitor_info;

jvmdiError JNICALL
GetOwnedMonitorInfo(jthread thread, JVMDI_owned_monitor_info *infoPtr);

jvmdiError JNICALL
GetCurrentContendedMonitor(jthread thread, jobject *monitorPtr);

typedef void (*JVMDI_StartFunction)(void *);
jvmdiError JNICALL
RunDebugThread(jthread thread, JVMDI_StartFunction proc, void *arg, int priority);

jvmdiError JNICALL
GetTopThreadGroups(jint *groupCountPtr, jthreadGroup **groupsPtr);



typedef struct {
    jthreadGroup parent;
    char *name;             /* Name in UTF-8 */
    jint  max_priority;
    jboolean is_daemon;
} JVMDI_thread_group_info;

jvmdiError JNICALL
GetThreadGroupInfo(jthreadGroup group, JVMDI_thread_group_info *infoPtr);

jvmdiError JNICALL
GetThreadGroupChildren(jthreadGroup group,
                 jint *threadCountPtr, jthread **threadsPtr,
                 jint *groupCountPtr, jthreadGroup **groupsPtr);

jvmdiError JNICALL
GetFrameCount(jthread thread, jint *countPtr);

jvmdiError JNICALL
GetCurrentFrame(jthread thread, jframeID *framePtr);

jvmdiError JNICALL
GetCallerFrame(jframeID called, jframeID *framePtr);

jvmdiError JNICALL
GetFrameLocation(jframeID frame, jclass *classPtr, jmethodID *methodPtr,
                       jlocation *locationPtr);

jvmdiError JNICALL
NotifyFramePop(jframeID frame); 

jvmdiError JNICALL
GetLocalObject(jframeID frame, jint slot, jobject *valuePtr);

jvmdiError JNICALL
GetLocalInt(jframeID frame, jint slot, jint *valuePtr);

jvmdiError JNICALL
GetLocalLong(jframeID frame, jint slot, jlong *valuePtr);

jvmdiError JNICALL
GetLocalFloat(jframeID frame, jint slot, jfloat *valuePtr);

jvmdiError JNICALL
GetLocalDouble(jframeID frame, jint slot, jdouble *valuePtr);

jvmdiError JNICALL
SetLocalObject(jframeID frame, jint slot, jobject value);

jvmdiError JNICALL
SetLocalInt(jframeID frame, jint slot, jint value);

jvmdiError JNICALL
SetLocalLong(jframeID frame, jint slot, jlong value);

jvmdiError JNICALL
SetLocalFloat(jframeID frame, jint slot, jfloat value);

jvmdiError JNICALL
SetLocalDouble(jframeID frame, jint slot, jdouble value);

jvmdiError JNICALL
SetBreakpoint(jclass clazz, jmethodID method, jlocation location);

jvmdiError JNICALL
ClearBreakpoint(jclass clazz, jmethodID method, jlocation location);

jvmdiError JNICALL
ClearAllBreakpoints();

jvmdiError JNICALL
SetFieldAccessWatch(jclass clazz, jfieldID field);

jvmdiError JNICALL
ClearFieldAccessWatch(jclass clazz, jfieldID field);

jvmdiError JNICALL
SetFieldModificationWatch(jclass clazz, jfieldID field);

jvmdiError JNICALL
ClearFieldModificationWatch(jclass clazz, jfieldID field);

jvmdiError JNICALL
GetClassSignature(jclass clazz, char **sigPtr);

jvmdiError JNICALL
GetClassStatus(jclass clazz, jint *statusPtr);

jvmdiError JNICALL
GetSourceFileName(jclass clazz, char **sourceNamePtr);

jvmdiError JNICALL
GetClassModifiers(jclass clazz, jint *modifiersPtr);

jvmdiError JNICALL
GetClassMethods(jclass clazz, jint *methodCountPtr, jmethodID **methodsPtr);

jvmdiError JNICALL
GetClassFields(jclass clazz, jint *fieldCountPtr, jfieldID **fieldsPtr);

jvmdiError JNICALL
GetImplementedInterfaces(jclass clazz,
                       jint *interfaceCountPtr, 
                       jclass **interfacesPtr);

jvmdiError JNICALL
IsInterface(jclass clazz, jboolean *isInterfacePtr);

jvmdiError JNICALL
IsArrayClass(jclass clazz, jboolean *isArrayClassPtr);

jvmdiError JNICALL
GetClassLoader(jclass clazz, jobject *classloaderPtr);

jvmdiError JNICALL
jvmdiErrorGetObjectHashCode(jobject object, jint *hashCodePtr);



typedef struct {
    jthread owner;
    jint entry_count;
    jint waiter_count;
    jthread *waiters;
} JVMDI_monitor_info;

#if defined(ORP_NT) && defined(_IA64_)
// Name collision between a Win64 symbol and a JVMDI symbol.
// Turn off 'extern "C"', but it means that this function won't
// be available on Win64.
#ifdef __cplusplus
}
#endif
jvmdiError JNICALL
GetMonitorInfo(jobject object, JVMDI_monitor_info *infoPtr);
#ifdef __cplusplus
extern "C" {
#endif
#else
jvmdiError JNICALL
GetMonitorInfo(jobject object, JVMDI_monitor_info *infoPtr);
#endif

jvmdiError JNICALL
GetFieldName(jclass clazz, jfieldID field, 
                   char **namePtr, char **signaturePtr);

jvmdiError JNICALL
GetFieldDeclaringClass(jclass clazz, jfieldID field, jclass *declaringClassPtr);

jvmdiError JNICALL
GetFieldModifiers(jclass clazz, jfieldID field, jint *modifiersPtr);

jvmdiError JNICALL
IsFieldSynthetic(jclass clazz, jfieldID field, jboolean *isSyntheticPtr);

jvmdiError JNICALL
GetMethodName(jclass clazz, jmethodID method, 
                    char **namePtr, char **signaturePtr);

jvmdiError JNICALL
GetMethodDeclaringClass(jclass clazz, jmethodID method,
                                 jclass *declaringClassPtr);

jvmdiError JNICALL
GetMethodModifiers(jclass clazz, jmethodID method,
                         jint *modifiersPtr);

jvmdiError JNICALL
GetMaxStack(jclass clazz, jmethodID method, jint *maxPtr);

jvmdiError JNICALL
GetMaxLocals(jclass clazz, jmethodID method,
                  jint *maxPtr);

jvmdiError JNICALL
GetArgumentsSize(jclass clazz, jmethodID method, jint *sizePtr);



typedef struct {
    jlocation start_location;
    jint line_number;
} JVMDI_line_number_entry;

jvmdiError JNICALL
GetLineNumberTable(jclass clazz, jmethodID method,
 			 jint *entryCountPtr, 
             JVMDI_line_number_entry **tablePtr);

jvmdiError JNICALL
GetMethodLocation(jclass clazz, jmethodID method,
                        jlocation *startLocationPtr, 
                        jlocation *endLocationPtr);



typedef struct {
    jlocation start_location;   /* variable valid start_location */
    jint length;                /* upto start_location+length */ 
    char *name;                 /* name in UTF-8 */
    char *signature;            /* type signature in UTF-8 */
    jint slot;                  /* variable slot, see JVMDI_GetLocal*()  */
} JVMDI_local_variable_entry;

jvmdiError JNICALL
GetLocalVariableTable(jclass clazz, jmethodID method,
                            jint *entryCountPtr, 
                            JVMDI_local_variable_entry **tablePtr);


typedef struct {
    jlocation start_location;
    jlocation end_location;
    jlocation handler_location;
    jclass exception;           /* if null, all exceptions */
} JVMDI_exception_handler_entry;

jvmdiError JNICALL
GetExceptionHandlerTable(jclass clazz, jmethodID method,
                               jint *entryCountPtr, 
                               JVMDI_exception_handler_entry **tablePtr);

jvmdiError JNICALL
GetThrownExceptions(jclass clazz, jmethodID method,
                          jint *exceptionCountPtr, jclass **exceptionsPtr);

jvmdiError JNICALL
GetBytecodes(jclass clazz, jmethodID method, jint *bytecodeCountPtr,
                         jbyte **bytecodesPtr);

jvmdiError JNICALL
IsMethodNative(jclass clazz, jmethodID method, jboolean *isNativePtr);

jvmdiError JNICALL
IsMethodSynthetic(jclass clazz, jmethodID method, jboolean *isSyntheticPtr);

jvmdiError JNICALL
CreateRawMonitor(char *name, JVMDI_RawMonitor *monitorPtr);

jvmdiError JNICALL
DestroyRawMonitor(JVMDI_RawMonitor monitor);

jvmdiError JNICALL
RawMonitorEnter(JVMDI_RawMonitor monitor);

jvmdiError JNICALL
RawMonitorExit(JVMDI_RawMonitor monitor);

jvmdiError JNICALL
RawMonitorWait(JVMDI_RawMonitor monitor, jlong millis);

jvmdiError JNICALL
RawMonitorNotify(JVMDI_RawMonitor monitor);

jvmdiError JNICALL
RawMonitorNotifyAll(JVMDI_RawMonitor monitor);



typedef struct { jthread thread;        jclass clazz;
                 jmethodID method;        jlocation location;
} JVMDI_single_step_event_data;


    typedef struct { 
        jthread thread;
        jclass clazz;
        jmethodID method;
        jlocation location;
    } JVMDI_breakpoint_event_data;

    /* kind = JVMDI_EVENT_FIELD_ACCESS */
    typedef struct { 
        jthread thread;
        jclass clazz;
        jmethodID method;
        jlocation location;
        jclass field_clazz;
        jobject object;
        jfieldID field;
    } JVMDI_field_access_event_data;
    
    /* kind = JVMDI_EVENT_FIELD_MODIFICATION */
    typedef struct { 
        jthread thread;
        jclass clazz;
        jmethodID method;
        jlocation location;
        jclass field_clazz;
        jobject object;
        jfieldID field;
        char signature_type;
        jvalue new_value;
    } JVMDI_field_modification_event_data;


    typedef struct { 
        jthread thread;
        jclass clazz;
        jmethodID method;
        jframeID frame;
    } JVMDI_frame_event_data;

    typedef struct { 
        jthread thread;
        jclass clazz;
        jmethodID method;
        jlocation location;
        jobject exception;
        jclass catch_clazz;
        jmethodID catch_method;
        jlocation catch_location;
    } JVMDI_exception_event_data;


    typedef struct { 
        jthread thread;
        jclass clazz;
        jmethodID method;
        jlocation location;
        jobject exception;
    } JVMDI_exception_catch_event_data;


    typedef struct { 
        jobject object;
        jint key;
    } JVMDI_user_event_data;

    typedef struct { 
        jthread thread;
    } JVMDI_thread_change_event_data;

    typedef struct { 
        jthread thread;
        jclass clazz;
    } JVMDI_class_event_data;






typedef struct {
    jint kind;		/* the discriminant */

    union {
	/* kind = JVMDI_EVENT_SINGLE_STEP */
        JVMDI_single_step_event_data single_step;
			
        /* kind = JVMDI_EVENT_BREAKPOINT */
        JVMDI_breakpoint_event_data breakpoint;

        /* kind = JVMDI_EVENT_FRAME_POP */
        /* kind = JVMDI_EVENT_METHOD_ENTRY */
        /* kind = JVMDI_EVENT_METHOD_EXIT */
        JVMDI_frame_event_data frame;

        /* kind = JVMDI_EVENT_FIELD_ACCESS */
        JVMDI_field_access_event_data field_access;

        /* kind = JVMDI_EVENT_FIELD_MODIFICATION */
        JVMDI_field_modification_event_data field_modification;

        /* kind = JVMDI_EVENT_EXCEPTION */
        JVMDI_exception_event_data exception;

        /* kind = JVMDI_EVENT_EXCEPTION_CATCH */
        JVMDI_exception_catch_event_data exception_catch;

        /* kind = JVMDI_EVENT_USER_DEFINED */
        JVMDI_user_event_data user;
			
        /* kind = JVMDI_EVENT_THREAD_END or */
        /* JVMDI_EVENT_THREAD_START */
        JVMDI_thread_change_event_data thread_change;
			
        /* kind = JVMDI_EVENT_CLASS_LOAD, */
        /* JVMDI_EVENT_CLASS_UNLOAD, or */
        /* JVMDI_EVENT_CLASS_PREPARE */
        JVMDI_class_event_data class_event;
			
        /* kind = JVMDI_EVENT_VM_DEATH, JVMDI_EVENT_VM_INIT */
        /* no additional fields */		
    } u;
} JVMDI_Event;


typedef void (*JVMDI_EventHook)(JNIEnv *env , JVMDI_Event *event);

jvmdiError JNICALL
SetEventHook(JVMDI_EventHook hook);

jvmdiError JNICALL
SetEventNotificationMode(jint mode, jint eventType, jthread thread, ...);

jvmdiError JNICALL
GetLoadedClasses(jint *classCountPtr, jclass **classesPtr);

jvmdiError JNICALL
GetClassLoaderClasses(jobject initiatingLoader, jint *classCountPtr, jclass **classesPtr);

jvmdiError JNICALL
GetVersionNumber(jint *versionPtr);



typedef struct {
    unsigned int can_watch_field_modification      : 1;
    unsigned int can_watch_field_access            : 1;
    unsigned int can_get_bytecodes                 : 1;
    unsigned int can_get_synthetic_attribute       : 1;
    unsigned int can_get_owned_monitor_info        : 1;
    unsigned int can_get_current_contended_monitor : 1;
    unsigned int can_get_monitor_info              : 1;
} JVMDI_capabilities;

jvmdiError JNICALL
GetCapabilities(JVMDI_capabilities *capabilitiesPtr);

extern JVMDI_EventHook jvmdi_hook_function;

Object_Handle orp_create_global_object_handle(); //bugbug where does this go?

extern bool report_jvmdi_event_vm_init;
extern bool report_jvmdi_event_vm_death;
extern bool report_jvmdi_event_thread_start;
extern bool report_jvmdi_event_class_load;
extern bool report_jvmdi_event_class_prepare;
extern bool report_jvmdi_event_class_unload;



void jvmdi_method_entry();
void jvmdi_method_exit();

void  jvmdi_exception(Frame_Context *original_context,
                   volatile Java_java_lang_Object **p_obj,
                   Frame_Context *new_context);

void jvmdi_breakpoint(uint32 *p_eip_arg);
 
#define BUFF_SIZE 256

typedef struct {
    jlocation loc;
    uint32    line_no;
#ifdef USE_IA64_JIT
    jbyte old_value[16];
#else
    jbyte     old_value;
#endif
    void     *method_handle;
    char buff_class[BUFF_SIZE];
    char buff_method[BUFF_SIZE];
    char buff_descriptor[BUFF_SIZE];
} jvmdi_bp;


typedef struct {
    jlocation start_location;  // byte code offset
    jint line_number;

    jbyte old_value;
    jlocation loc;   // actual target address in JITted code
} jvmdi_ss;

#ifdef __cplusplus
}
#endif 

extern bool jvmdi_debugger;

#endif

























































