// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/object_layout.h,v 1.8 2001/12/18 15:44:58 rlhudson Exp $
//




#ifndef _OBJECT_LAYOUT_H_
#define _OBJECT_LAYOUT_H_

#include "orp_types.h"

typedef struct VTable VTable;

#ifdef __cplusplus
extern "C" {
#endif


//
// Built-in types
//

typedef struct Java_java_lang_Object {
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
} Java_java_lang_Object;

//
// Given and object return a pointer to the obj info which holds things like the 
// hash and the lock information.
//
#ifndef OLD_OBJ_LAYOUT
#define P_OBJ_INFO(P_AN_OBJ) ((POINTER_SIZE_INT *)&(P_AN_OBJ->obj_info))
#else
#define P_OBJ_INFO(P_AN_OBJ) ((POINTER_SIZE_INT *)((char *)P_AN_OBJ - sizeof(POINTER_SIZE_INT)))
#endif

// For places in the GC where one wants the start of the object and not the header
// one should use this macro
#ifndef OLD_OBJ_LAYOUT
#define P_OBJ_START(P_AN_OBJ) P_AN_OBJ
#else
#define P_OBJ_START(P_AN_OBJ) ((POINTER_SIZE_INT *)((char *)P_AN_OBJ - sizeof(POINTER_SIZE_INT)))
#endif


// For places in the GC where one wants the start of the object and not the header
// one should use this macro
#ifndef OLD_OBJ_LAYOUT
#define P_OBJ_FROM_START(P_AN_OBJ) (Java_java_lang_Object *)P_AN_OBJ
#else
#define P_OBJ_FROM_START(P_AN_OBJ) ((Java_java_lang_Object *)((char *)P_AN_OBJ + sizeof(POINTER_SIZE_INT)))
#endif


// For places in the GC where one wants the start of the object and not the header
// one should use this macro
#ifndef OLD_OBJ_LAYOUT
#define P_OBJ_INFO_FROM_START(P_AN_OBJ) (POINTER_SIZE_INT *)&(((Java_java_lang_Object *)P_AN_OBJ)->obj_info)
#else
#define P_OBJ_INFO_FROM_START(P_AN_OBJ) P_AN_OBJ
#endif




// Fields of these types are not directly accessible from the corp VM.
typedef struct Java_java_lang_Object Java_java_lang_Class;
typedef struct Java_java_lang_Object Java_java_lang_String;
typedef struct Java_java_lang_Object Java_java_lang_System;
typedef struct Java_java_lang_Object Java_java_lang_Throwable;
typedef struct Java_java_lang_Object Java_java_lang_Thread;
typedef struct Java_java_lang_Object Java_java_lang_ThreadGroup;
typedef struct Java_java_lang_Object Java_java_io_FileInputStream;
typedef struct Java_java_lang_Object Java_java_lang_Throwable;


// See gc_for_orp, any change here needs to be reflected in Partial_Reveal_JavaArray.
typedef struct ORP_Vector
{
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32   length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
} ORP_Vector;



typedef struct ORP_Vector_int8
{
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32   length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    int8    body[1];
} ORP_Vector_int8;



typedef struct ORP_Vector_uint8
{
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32   length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    uint8   body[1];
} ORP_Vector_uint8;



typedef struct ORP_Vector_int16
{
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32   length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    int16   body[1];
} ORP_Vector_int16;



typedef struct ORP_Vector_uint16
{
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32   length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    uint16  body[1];
} ORP_Vector_uint16;


typedef struct ORP_Vector_int32
{
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32   length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    int32   body[1];
} ORP_Vector_int32;



typedef struct ORP_Vector_uint32
{
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32   length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    uint32  body[1];
} ORP_Vector_uint32;



typedef struct ORP_Vector_int64
{
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32   length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    int64   body[1];
} ORP_Vector_int64;



typedef struct ORP_Vector_uint64
{
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32   length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    uint64  body[1];
} ORP_Vector_uint64;



typedef struct ORP_Vector_f32
{
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32   length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    float   body[1];
} ORP_Vector_f32;



typedef struct ORP_Vector_f64
{
    VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32   length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    double  body[1];
} ORP_Vector_f64;



typedef struct ORP_Vector_Ref
{
    VTable                *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32                  length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    Java_java_lang_Object *body[1];
} ORP_Vector_Ref;



typedef ORP_Vector JavaArray;
typedef ORP_Vector_int8 JavaArrayOfBoolean;
typedef ORP_Vector_int8 JavaArrayOfByte;
typedef ORP_Vector_uint16 JavaArrayOfChar;
typedef ORP_Vector_int16 JavaArrayOfShort;
typedef ORP_Vector_int32 JavaArrayOfInt;
typedef ORP_Vector_int64 JavaArrayOfLong;
typedef ORP_Vector_f32 JavaArrayOfFloat;
typedef ORP_Vector_f64 JavaArrayOfDouble;
typedef ORP_Vector_Ref JavaArrayOfObject;


typedef struct JavaArrayOfString
{
    VTable                *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    int32                  length;
#ifdef EIGHT_BYTE_ALIGN_ARRAY
    int32   padding;
#endif
    Java_java_lang_String *body[1];
} JavaArrayOfString;


//
// Weak/soft/phantom reference are simple objects
// that hold pointers to a single referent object.
// The next field can be linked and unlinked from
// various lists based on whether they are soft, weak,
// or phantom references. The reference_queue and the next
// fields are strong pointers and the reference queues associated
// with each nursery/step/car are conisdered roots. Note as long as
// a java_lang_ref_Soft/Weak/PhantomReference is associated with
// a queue then it will remain alive.  
// The next field can be used
// to link the reference objects onto the appropriate queues
// once the object becomes unreachable.
// There is no attempt to keep the java_lang_ref_Reference near
// the referent. If they are created at about the same time they
// will end up close to each other.
//
struct java_lang_ref_ReferenceQueue;

typedef struct java_lang_ref_Reference {
	VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
	Java_java_lang_Object *referent;
	java_lang_ref_ReferenceQueue *queue;
	java_lang_ref_Reference *next;
    bool enqueued;
} Java_java_lang_ref_Reference;

typedef struct java_lang_ref_ReferenceQueue {
	VTable *vt;
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
   	java_lang_ref_Reference *head1;
   	java_lang_ref_Reference *head2;
	volatile int which;
} java_lang_ref_ReferenceQueue;



//////////////////////////////////////////////////////////
// Field access functions follow

// Fields of java.lang.String objects can be set accessed through
// those functions.
void set_java_lang_string_fields(Java_java_lang_String *str,
                                 JavaArrayOfChar       *value,
                                 int32                  offset,
                                 int32                  count);
void get_java_lang_string_fields(Java_java_lang_String  *str,
                                 JavaArrayOfChar       **value,
                                 int32                  *offset,
                                 int32                  *count);
JavaArrayOfChar *get_java_lang_string_field_value(Java_java_lang_String *str);
int32 get_java_lang_string_field_offset(Java_java_lang_String *str);
int32 get_java_lang_string_field_count(Java_java_lang_String *str);

Java_java_lang_Object *get_java_lang_throwable_field_trace(Java_java_lang_Throwable *thr);
Java_java_lang_String *get_java_lang_throwable_field_message(Java_java_lang_Throwable *thr);
void set_java_lang_throwable_field_trace(Java_java_lang_Throwable *thr, Java_java_lang_Object *trace);



#ifdef __cplusplus
}
#endif

#endif // _OBJECT_LAYOUT_H_

