// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/mains/orp/Dll_Jit.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//



#include "platform.h"
#include "Dll_Jit_intf.h"
#include "gc_for_orp.h"

#ifdef ORP_NT

#define GET_FUNCTION(fn, handle, name) \
    fn = GetProcAddress(handle, name); \
    if (fn == NULL) { \
        orp_cout << "Couldn't load dll " << dll_filename << ": missing entry point " << name << endl; \
        return; \
    }

#define GET_OPTIONAL_FUNCTION(fn, handle, name) \
    fn = GetProcAddress(handle, name);

Dll_JIT::Dll_JIT(const char *dll_filename) :
#ifdef USE_METHOD_TABLE
envvar_METHODS(NULL),
call_count(0),
mtable(NULL),
#endif // USE_METHOD_TABLE
_init(NULL),
_deinit(NULL),
_next_command_line_argument(NULL),
_gen_method_info(NULL),
_compile_method(NULL),
_unwind_stack_frame(NULL),
_get_root_set_from_stack_frame(NULL),
_can_enumerate(NULL),
_num_breakpoints(NULL),
_get_breakpoints(NULL),
_fix_handler_context(NULL),
_get_address_of_this(NULL),
_call_returns_a_reference(NULL),
_get_break_point_offset(NULL),
_get_address_of_var(NULL),
_thread_recompile_methods(NULL),
_gc_start(NULL),
_gc_end(NULL),
_gc_object_died(NULL)
{

    init();

    HINSTANCE handle = LoadLibrary(dll_filename);
    if (handle == NULL)
    {
        orp_cout << "Failure to open JIT dll " << dll_filename << endl;
        return;
    }

    FARPROC fn;

    GET_OPTIONAL_FUNCTION(fn, handle, "JIT_init");
    _init = (void (*)(JIT_Handle)) fn;

    GET_OPTIONAL_FUNCTION(fn, handle, "JIT_deinit");
    _deinit = (void (*)()) fn;

    GET_OPTIONAL_FUNCTION(fn, handle, "JIT_next_command_line_argument");
    _next_command_line_argument = (void (*)(const char *, const char *)) fn;

    GET_OPTIONAL_FUNCTION(fn, handle, "JIT_gc_start");
    _gc_start = (void (*)()) fn;

    GET_OPTIONAL_FUNCTION(fn, handle, "JIT_gc_end");
    _gc_end = (void (*)()) fn;

    GET_OPTIONAL_FUNCTION(fn, handle, "JIT_gc_object_died");
    _gc_object_died = (void (*)(void *)) fn;



    GET_FUNCTION(fn, handle, "JIT_unwind_stack_frame");
    _unwind_stack_frame = (void (*)(Method_Handle, Frame_Context *, Boolean)) fn;

    GET_FUNCTION(fn, handle, "JIT_get_root_set_from_stack_frame");
    _get_root_set_from_stack_frame = (void (*)(Method_Handle, GC_Enumeration_Handle, Frame_Context *, Boolean)) fn;

    GET_FUNCTION(fn, handle, "JIT_can_enumerate");
    _can_enumerate = (Boolean (*)(Method_Handle, uint32)) fn;

    GET_FUNCTION(fn, handle, "JIT_num_breakpoints");
    _num_breakpoints = (unsigned (*)(Method_Handle, uint32)) fn;

    GET_FUNCTION(fn, handle, "JIT_get_breakpoints");
    _get_breakpoints = (void (*)(Method_Handle, uint32 *, Frame_Context *)) fn;

    GET_FUNCTION(fn, handle, "JIT_fix_handler_context");
    _fix_handler_context = (void (*)(Method_Handle, Frame_Context *, Boolean)) fn;

    GET_FUNCTION(fn, handle, "JIT_get_address_of_this");
    _get_address_of_this = (void * (*)(Method_Handle, const Frame_Context *, Boolean)) fn;

    GET_FUNCTION(fn, handle, "JIT_call_returns_a_reference");
    _call_returns_a_reference = (Boolean (*)(Method_Handle, const Frame_Context *)) fn;

    GET_FUNCTION(fn, handle, "JIT_gen_method_info");
    _gen_method_info = (JIT_Result (*)(Compile_Handle, Method_Handle, JIT_Flags)) fn;

    GET_FUNCTION(fn, handle, "JIT_compile_method");
    _compile_method = (JIT_Result (*)(Compile_Handle, Method_Handle, JIT_Flags)) fn;

    GET_FUNCTION(fn, handle, "JIT_get_break_point_offset");
    _get_break_point_offset = (int32 (*)(Compile_Handle, Method_Handle, JIT_Flags, unsigned)) fn;

    GET_FUNCTION(fn, handle, "JIT_get_address_of_var");
    _get_address_of_var = (void * (*)(Frame_Context *,Boolean,unsigned)) fn;

    GET_FUNCTION(fn, handle, "JIT_thread_recompile_methods");
    _thread_recompile_methods = (void * (*)()) fn;

    if (_init != NULL)
        _init(this);
}

#endif // ORP_NT
