getEdges.ggobi <-
  #
  # If only one dataset is specified (edgeset), we get the 
  # symbolic edges.
  # If two are specified, we get the resolved edges for that
  # pair of datasets, computing it if necessary.
function(edgeset = 1, .data = NULL, .gobi = getDefaultGGobi())
{
 if(is.numeric(edgeset))
   edgeset <- as.integer(edgeset - 1)

 if(missing(.data)) {
   m <- .GGobiCall("getSymbolicEdges", edgeset, .gobi = .gobi)
 } else {
    if(is.numeric(.data))
      .data <- as.integer(.data - 1)   
    m <- .GGobiCall("getConnectedEdges", edgeset, .data, .gobi = .gobi)
    m <- m + 1
 }

 if(!is.null(m))
   colnames(m) <- c("source", "destination")

  m
}



resolveEdges.ggobi <-
function(symbolic, dataset)
{
 nm = rownames(dataset)
 cbind(match(symbolic[,1], nm), match(symbolic[,2], nm))
}



createEdgeData.ggobi <-
function(numEdges, labels=rep("", numEdges), colors = NULL, .gobi = getDefaultGGobi(), name = "R edge data")
{
 d <- .GGobiCall("createEdgeDataset", as.integer(numEdges), as.character(name), .gobi = .gobi)

 setRowNames.ggobi(as.character(labels), .data = d)

 if(!is.null(colors))
  setColors.ggobi(colors, .data = d)

 d
}



setDisplayEdges.ggobi <-
function(displays, edgeData, directed = FALSE, on = TRUE, .gobi = getDefaultGGobi())
{
 if(missing(displays))
    displays <- getDisplays.ggobi(.gobi = .gobi)

 if(inherits(displays, "ggobiDisplay"))
   displays <- list(displays)

 if(on) {
  if(missing(edgeData)) {
   datasets <- getDatasetReference.ggobi(1:getNumDatasets.ggobi(.gobi=.gobi), .gobi = .gobi)
   e <- sapply(datasets, function(x) inherits(x, "ggobiEdgeDataset"))
   if(!any(e))
     stop("No edge data")

   k <- ((1:length(e))[e])[1] 
   edgeData <- datasets[[ k ]]
  } else {
   if(is.numeric(edgeData)) {
     edgeData <- .gobi[[edgeData]]
   }
  }

  if(!inherits(edgeData, "ggobiEdgeDataset"))
     stop("Not an edge dataset")  
 } else
  edgeData = NULL

 .GGobiCall("setDisplayEdges", displays, edgeData, as.logical(directed), as.logical(on), .gobi = .gobi)
}


# hideEdges.ggobi =
# function(displays, .gobi = getDefaultGGobi())
# {
#  setDisplayEdges.ggobi(..., off = TRUE)
# }  
