\name{getDatasetNames.ggobi}
\alias{getDatasetNames.ggobi}
\alias{datasetIndex.ggobi}
\title{Get the names or index of the datasets in a ggobi instance}
\description{
 The \code{getDatasetNames.ggobi} is a method for 
 obtaining the names of the different datasets 
 within a ggobi instance. Occassionally it is also
 useful to map the name  of one of these datasets
 to is position or index.

 \code{datasetIndex.ggobi}
 does this, but it is used infrequently given the
 introduction of the \code{ggobiDataset} class
 and methods (e.g. \code{\link{getDatasetReference.ggobi}})
 for obtaining references to datasets
 that are position/order invariant. This is also a
 function that is typically used by other functions
 in the package and not directly called by users of the package.
}
\usage{
getDatasetNames.ggobi(.gobi=getDefaultGGobi())
datasetIndex.ggobi(.data, .gobi=getDefaultGGobi())
}
\arguments{
  \item{.data}{the names of one or more dataset whose indices are to be determined.}
  \item{.gobi}{the identifier for the ggobi instance whose datasets are to be queried.
  This should be an object of class \code{ggobi} or else an integer identifying
  the ggobi instance by position in the list of all ggobis.}
}
\details{
 The name of a dataset is defined in a variety of different
ways depending on the format of the input file, data, etc.
}
\value{
 \code{getDatasetNames.ggobi} returns a character vector
containing the names of the datasets.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}


\seealso{
\code{\link{names.ggobi}}
\code{\link{getDatasetReference.ggobi}}
}

\examples{
   g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
   names(g)
   getDatasetNames.ggobi(g)
}
\concept{visualization}
\concept{interactive graphics}
\keyword{classes}
