\name{mapGlyphType}
\alias{mapGlyphType}
\title{Maps glyph names to their internal integer value}
\description{
 This is an ``internal'' or ``infrequently called by users'' function
that takes one or more glyph names (specified as strings) and matches them
agains tthe names of the possible glyphs understood by ggobi and
returns the identifiers (integers) corresponding to ggobi's internal
representation of those glyphs.
}
\usage{
mapGlyphType(types)
}
\arguments{
  \item{types}{a character vector identifying one or more glyphs by name.
  See \code{\link{getGlyphTypes.ggobi}}
}}
\details{
 This queries the ggobi code to ask for the glyph representations
(integers) and names and then matches the user specified values
against these names.
}
\value{
  An integer vector containing the 
internal ggobi glyph identifiers for the glyph types identified by the
user-specified names.
}
\concept{visualization}
\concept{interactive graphics}

\seealso{
\code{\link{getGlyphSizes.ggobi}}
}

\examples{
  mapGlyphType(c("plus", "x"))
}
\concept{visualization}
\concept{interactive graphics}

\keyword{dynamic}
